/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.mission;

import java.util.LinkedList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public abstract class MissionResourceCollection
extends SatelliteBase
implements IMission {
    long startWorldTime;
    double x;
    double y;
    double z;
    long duration;
    ResourceLocation launchDimension;
    StorageChunk rocketStorage;
    StatsRocket rocketStats;
    ResourceLocation worldId;
    CompoundNBT missionPersistantNBT;
    protected LinkedList<HashedBlockPosition> infrastructureCoords;

    public MissionResourceCollection() {
        this.infrastructureCoords = new LinkedList();
    }

    public MissionResourceCollection(long duration, EntityRocket entity, LinkedList<IInfrastructure> infrastructureCoords) {
        this.missionPersistantNBT = new CompoundNBT();
        entity.writeMissionPersistantNBT(this.missionPersistantNBT);
        this.satelliteProperties.setId(DimensionManager.getInstance().getNextSatelliteId());
        this.startWorldTime = AdvancedRocketry.proxy.getWorldTimeUniversal();
        this.duration = duration;
        this.launchDimension = ZUtils.getDimensionIdentifier((World)entity.field_70170_p);
        this.rocketStorage = entity.storage;
        this.rocketStats = entity.stats;
        this.x = entity.func_226277_ct_();
        this.y = entity.func_226278_cu_();
        this.z = entity.func_226281_cx_();
        this.worldId = ZUtils.getDimensionIdentifier((World)entity.field_70170_p);
        this.infrastructureCoords = new LinkedList();
        for (IInfrastructure tile : infrastructureCoords) {
            this.infrastructureCoords.add(new HashedBlockPosition(((TileEntity)tile).func_174877_v()));
        }
    }

    @Override
    public double getProgress(World world) {
        return Math.max((double)(AdvancedRocketry.proxy.getWorldTimeUniversal() - this.startWorldTime) / (double)this.duration, 0.0);
    }

    @Override
    public int getTimeRemainingInSeconds() {
        return (int)Math.max((this.duration - AdvancedRocketry.proxy.getWorldTimeUniversal() + this.startWorldTime) / 20L, 0L);
    }

    @Override
    public String getInfo(World world) {
        return null;
    }

    @Override
    public String getName() {
        return LibVulpes.proxy.getLocalizedString("mission.asteroidmining");
    }

    @Override
    public boolean performAction(PlayerEntity player, World world, BlockPos pos) {
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public boolean canTick() {
        return true;
    }

    @Override
    public abstract void onMissionComplete();

    @Override
    public void tickEntity() {
        if (EffectiveSide.get().isServer() && this.getProgress((World)ZUtils.getWorld((ResourceLocation)this.getDimensionId().get())) >= 1.0) {
            this.remove();
            this.onMissionComplete();
        }
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_218657_a("persist", (INBT)this.missionPersistantNBT);
        CompoundNBT nbt2 = new CompoundNBT();
        this.rocketStats.writeToNBT(nbt2);
        nbt.func_218657_a("rocketStats", (INBT)nbt2);
        nbt2 = new CompoundNBT();
        this.rocketStorage.writeToNBT(nbt2);
        nbt.func_218657_a("rocketStorage", (INBT)nbt2);
        nbt.func_74780_a("launchPosX", this.x);
        nbt.func_74780_a("launchPosY", this.y);
        nbt.func_74780_a("launchPosZ", this.z);
        nbt.func_74772_a("startWorldTime", this.startWorldTime);
        nbt.func_74772_a("duration", this.duration);
        nbt.func_74778_a("startDimid", this.worldId.toString());
        nbt.func_74778_a("launchDim", this.launchDimension.toString());
        ListNBT itemList = new ListNBT();
        for (int i = 0; i < this.infrastructureCoords.size(); ++i) {
            HashedBlockPosition inf = this.infrastructureCoords.get(i);
            CompoundNBT tag = new CompoundNBT();
            tag.func_74783_a("loc", new int[]{inf.x, inf.y, inf.z});
            itemList.add((Object)tag);
        }
        nbt.func_218657_a("infrastructure", (INBT)itemList);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.missionPersistantNBT = nbt.func_74775_l("persist");
        this.rocketStats = new StatsRocket();
        this.rocketStats.readFromNBT(nbt.func_74775_l("rocketStats"));
        this.rocketStorage = new StorageChunk();
        this.rocketStorage.readFromNBT(nbt.func_74775_l("rocketStorage"));
        this.x = nbt.func_74769_h("launchPosX");
        this.y = nbt.func_74769_h("launchPosY");
        this.z = nbt.func_74769_h("launchPosZ");
        this.startWorldTime = nbt.func_74763_f("startWorldTime");
        this.duration = nbt.func_74763_f("duration");
        this.worldId = new ResourceLocation(nbt.func_74779_i("startDimid"));
        this.launchDimension = new ResourceLocation(nbt.func_74779_i("launchDim"));
        ListNBT tagList = nbt.func_150295_c("infrastructure", 10);
        this.infrastructureCoords.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            int[] coords = tagList.func_150305_b(i).func_74759_k("loc");
            this.infrastructureCoords.add(new HashedBlockPosition(coords[0], coords[1], coords[2]));
        }
    }

    @Override
    public long getMissionId() {
        return this.getId();
    }

    @Override
    public ResourceLocation getOriginatingDimention() {
        return this.worldId;
    }

    @Override
    public void unlinkInfrastructure(IInfrastructure tile) {
        HashedBlockPosition pos = new HashedBlockPosition(((TileEntity)tile).func_174877_v());
        this.infrastructureCoords.remove(pos);
    }
}

