/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.util.logging.Logger;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.network.BasePacket;

public class PacketSpaceStationInfo
extends BasePacket {
    SpaceStationObject spaceObject;
    ResourceLocation stationNumber;
    boolean isBeingDeleted;
    int direction;
    String clazzId;
    int fuelAmt;
    CompoundNBT nbt;
    boolean hasWarpCores;

    public PacketSpaceStationInfo() {
    }

    public PacketSpaceStationInfo(ResourceLocation stationNumber, ISpaceObject spaceObject) {
        this.spaceObject = (SpaceStationObject)spaceObject;
        this.stationNumber = stationNumber;
    }

    public void write(PacketBuffer out) {
        CompoundNBT nbt = new CompoundNBT();
        out.func_192572_a(this.stationNumber);
        boolean flag = false;
        if (!flag) {
            try {
                this.spaceObject.writeToNbt(nbt);
                PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)out);
                out.writeBoolean(false);
                packetBuffer.func_180714_a(SpaceObjectManager.getSpaceManager().getItentifierFromClass(this.spaceObject.getClass()));
                packetBuffer.func_150786_a(nbt);
                packetBuffer.writeInt(this.spaceObject.getFuelAmount());
                packetBuffer.writeBoolean(this.spaceObject.hasWarpCores);
                out.writeInt(this.spaceObject.getForwardDirection().ordinal());
            }
            catch (NullPointerException e) {
                out.writeBoolean(true);
                Logger.getLogger("advancedRocketry").warning("Dimension " + this.stationNumber + " has thrown an exception trying to write NBT, deleting!");
                DimensionManager.getInstance().deleteDimension(this.stationNumber);
            }
        } else {
            out.writeBoolean(flag);
        }
    }

    public void readClient(PacketBuffer in) {
        PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)in);
        this.stationNumber = in.func_192575_l();
        this.isBeingDeleted = in.readBoolean();
        if (!this.isBeingDeleted) {
            this.clazzId = packetBuffer.func_150789_c(127);
            this.nbt = packetBuffer.func_150793_b();
            this.fuelAmt = packetBuffer.readInt();
            this.hasWarpCores = in.readBoolean();
            this.direction = in.readInt();
        }
    }

    public void read(PacketBuffer in) {
    }

    public void executeClient(PlayerEntity thePlayer) {
        if (this.isBeingDeleted) {
            if (DimensionManager.getInstance().isDimensionCreated(this.stationNumber)) {
                DimensionManager.getInstance().deleteDimension(this.stationNumber);
            }
        } else {
            ISpaceObject iObject = SpaceObjectManager.getSpaceManager().getSpaceStation(this.stationNumber);
            this.spaceObject = (SpaceStationObject)iObject;
            if (iObject == null) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getNewSpaceObjectFromIdentifier(this.clazzId);
                object.readFromNbt(this.nbt);
                object.setProperties(DimensionProperties.createFromNBT(this.stationNumber, this.nbt));
                ((SpaceStationObject)object).setForwardDirection(Direction.values()[this.direction]);
                SpaceObjectManager.getSpaceManager().registerSpaceObjectClient(object, object.getOrbitingPlanetId(), this.stationNumber);
                ((SpaceStationObject)object).setFuelAmount(this.fuelAmt);
                ((SpaceStationObject)object).hasWarpCores = this.hasWarpCores;
            } else {
                iObject.readFromNbt(this.nbt);
                ((SpaceStationObject)iObject).setForwardDirection(Direction.values()[this.direction]);
                ((SpaceStationObject)iObject).setFuelAmount(this.fuelAmt);
                ((SpaceStationObject)iObject).hasWarpCores = this.hasWarpCores;
            }
        }
    }

    public void executeServer(ServerPlayerEntity player) {
    }
}

