/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.network.BasePacket;

public class PacketStationUpdate
extends BasePacket {
    ISpaceObject spaceObject;
    ResourceLocation stationNumber;
    Type type;
    ResourceLocation destOrbitingBody;
    int fuel;
    double rx;
    double ry;
    double rz;
    double drx;
    double dry;
    double drz;
    float orbitalDistance;
    CompoundNBT nbt;

    public PacketStationUpdate() {
    }

    public PacketStationUpdate(ISpaceObject dimProperties, Type type) {
        this.spaceObject = (SpaceStationObject)dimProperties;
        this.stationNumber = dimProperties.getId();
        this.type = type;
    }

    public void write(PacketBuffer out) {
        out.func_192572_a(this.stationNumber);
        out.writeInt(this.type.ordinal());
        switch (this.type) {
            case DEST_ORBIT_UPDATE: {
                out.func_192572_a(this.spaceObject.getDestOrbitingBody());
                break;
            }
            case ORBIT_UPDATE: {
                out.func_192572_a(this.spaceObject.getOrbitingPlanetId());
                break;
            }
            case FUEL_UPDATE: {
                if (!(this.spaceObject instanceof SpaceStationObject)) break;
                out.writeInt(((SpaceStationObject)this.spaceObject).getFuelAmount());
                break;
            }
            case ROTANGLE_UPDATE: {
                out.writeDouble(this.spaceObject.getRotation(Direction.EAST));
                out.writeDouble(this.spaceObject.getRotation(Direction.UP));
                out.writeDouble(this.spaceObject.getRotation(Direction.NORTH));
                out.writeDouble(this.spaceObject.getDeltaRotation(Direction.EAST));
                out.writeDouble(this.spaceObject.getDeltaRotation(Direction.UP));
                out.writeDouble(this.spaceObject.getDeltaRotation(Direction.NORTH));
                break;
            }
            case ALTITUDE_UPDATE: {
                out.writeFloat(this.spaceObject.getOrbitalDistance());
                break;
            }
            case DIM_PROPERTY_UPDATE: {
                CompoundNBT nbt = new CompoundNBT();
                try {
                    this.spaceObject.getProperties().writeToNBT(nbt);
                    PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)out);
                    packetBuffer.func_150786_a(nbt);
                    break;
                }
                catch (NullPointerException e) {
                    out.writeBoolean(true);
                    Logger.getLogger("advancedRocketry").warning("Dimension " + this.stationNumber + " has thrown an exception trying to write NBT, deleting!");
                    DimensionManager.getInstance().deleteDimension(this.stationNumber);
                }
            }
        }
    }

    public void readClient(PacketBuffer in) {
        this.stationNumber = in.func_192575_l();
        this.type = Type.values()[in.readInt()];
        switch (this.type) {
            case DEST_ORBIT_UPDATE: {
                this.destOrbitingBody = in.func_192575_l();
                break;
            }
            case ORBIT_UPDATE: {
                this.destOrbitingBody = in.func_192575_l();
                break;
            }
            case FUEL_UPDATE: {
                this.fuel = in.readInt();
                break;
            }
            case ROTANGLE_UPDATE: {
                this.rx = in.readDouble();
                this.ry = in.readDouble();
                this.rz = in.readDouble();
                this.drx = in.readDouble();
                this.dry = in.readDouble();
                this.drz = in.readDouble();
                break;
            }
            case SIGNAL_WHITE_BURST: {
                break;
            }
            case ALTITUDE_UPDATE: {
                this.orbitalDistance = in.readFloat();
                break;
            }
            case DIM_PROPERTY_UPDATE: {
                PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)in);
                this.nbt = packetBuffer.func_150793_b();
            }
        }
    }

    public void read(PacketBuffer in) {
    }

    public void executeClient(PlayerEntity thePlayer) {
        this.spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(this.stationNumber);
        switch (this.type) {
            case DEST_ORBIT_UPDATE: {
                this.spaceObject.setDestOrbitingBody(this.destOrbitingBody);
                break;
            }
            case ORBIT_UPDATE: {
                this.spaceObject.setOrbitingBody(this.destOrbitingBody);
                break;
            }
            case FUEL_UPDATE: {
                if (!(this.spaceObject instanceof SpaceStationObject)) break;
                ((SpaceStationObject)this.spaceObject).setFuelAmount(this.fuel);
                break;
            }
            case ROTANGLE_UPDATE: {
                this.spaceObject.setRotation(this.rx, Direction.EAST);
                this.spaceObject.setRotation(this.ry, Direction.UP);
                this.spaceObject.setRotation(this.rz, Direction.NORTH);
                this.spaceObject.setDeltaRotation(this.drx, Direction.EAST);
                this.spaceObject.setDeltaRotation(this.dry, Direction.UP);
                this.spaceObject.setDeltaRotation(this.drz, Direction.NORTH);
                break;
            }
            case SIGNAL_WHITE_BURST: {
                PlanetEventHandler.runBurst(Minecraft.func_71410_x().field_71441_e.func_82737_E() + 20L, 20L);
                break;
            }
            case ALTITUDE_UPDATE: {
                this.spaceObject.setOrbitalDistance(this.orbitalDistance);
                break;
            }
            case DIM_PROPERTY_UPDATE: {
                if (this.nbt == null) break;
                this.spaceObject.getProperties().readFromNBT(this.nbt);
            }
        }
    }

    public void executeServer(ServerPlayerEntity player) {
    }

    public static enum Type {
        DEST_ORBIT_UPDATE,
        ORBIT_UPDATE,
        SIGNAL_WHITE_BURST,
        FUEL_UPDATE,
        ROTANGLE_UPDATE,
        DIM_PROPERTY_UPDATE,
        ALTITUDE_UPDATE;

    }
}

