/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.libVulpes.network.BasePacket;

public class PacketStellarInfo
extends BasePacket {
    StellarBody star;
    ResourceLocation starId;
    CompoundNBT nbt;
    boolean removeStar;

    public PacketStellarInfo() {
    }

    public PacketStellarInfo(ResourceLocation starId, StellarBody star) {
        this.star = star;
        this.starId = starId;
    }

    public void write(PacketBuffer out) {
        CompoundNBT nbt = new CompoundNBT();
        out.func_192572_a(this.starId);
        out.writeBoolean(this.star == null);
        if (this.star != null) {
            this.star.writeToNBT(nbt);
            PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)out);
            packetBuffer.func_150786_a(nbt);
        }
    }

    public void readClient(PacketBuffer in) {
        PacketBuffer packetBuffer = new PacketBuffer((ByteBuf)in);
        this.starId = in.func_192575_l();
        this.removeStar = in.readBoolean();
        if (!this.removeStar) {
            this.nbt = packetBuffer.func_150793_b();
        }
    }

    public void read(PacketBuffer in) {
    }

    public void executeClient(PlayerEntity thePlayer) {
        if (this.removeStar) {
            if (DimensionManager.getInstance().isDimensionCreated(this.starId)) {
                DimensionManager.getInstance().removeStar(this.starId);
            }
        } else if (this.nbt != null) {
            StellarBody star = DimensionManager.getInstance().getStar(this.starId);
            if (star != null) {
                star.readFromNBT(this.nbt);
            } else {
                star = new StellarBody();
                star.readFromNBT(this.nbt);
                DimensionManager.getInstance().addStar(star);
            }
        }
    }

    public void executeServer(ServerPlayerEntity player) {
    }
}

