/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.util.BiomeHandler;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public class SatelliteBiomeChanger
extends SatelliteBase {
    private int biomeId;
    private int radius = 4;
    private List<HashedBlockPosition> toChangeList = new LinkedList<HashedBlockPosition>();
    private Set<ResourceLocation> discoveredBiomes = new HashSet<ResourceLocation>();
    private static int MAX_SIZE = 1024;

    public void setBiome(int biomeId) {
        this.biomeId = biomeId;
    }

    public int getBiome() {
        return this.biomeId;
    }

    public Set<ResourceLocation> discoveredBiomes() {
        return this.discoveredBiomes;
    }

    public void addBiome(ResourceLocation biome) {
        if (!AdvancedRocketryBiomes.instance.getBlackListedBiomes().contains(biome)) {
            this.discoveredBiomes.add(biome);
        }
    }

    @Override
    public String getInfo(World world) {
        return "Ready";
    }

    @Override
    public String getName() {
        return "Biome Changer";
    }

    @Override
    public ItemStack getContollerItemStack(ItemStack satIdChip, SatelliteProperties properties) {
        return satIdChip;
    }

    @Override
    public boolean isAcceptableControllerItemStack(ItemStack stack) {
        return false;
    }

    @Override
    public void tickEntity() {
        ServerWorld world = ZUtils.getWorld((ResourceLocation)this.getDimensionId().get());
        if (world != null) {
            for (int i = 0; i < 10; ++i) {
                if (world.func_82737_E() % 1L != 0L || this.toChangeList.isEmpty()) continue;
                if (this.battery.extractEnergy(120, true) != 120) break;
                HashedBlockPosition pos = this.toChangeList.remove(world.field_73012_v.nextInt(this.toChangeList.size()));
                BiomeHandler.changeBiome((World)world, this.biomeId, pos.getBlockPos());
            }
        }
        super.tickEntity();
    }

    public void addBlockToList(HashedBlockPosition pos) {
        if (this.toChangeList.size() < MAX_SIZE) {
            this.toChangeList.add(pos);
        }
    }

    @Override
    public boolean performAction(PlayerEntity player, World world, BlockPos pos) {
        if (world.field_72995_K) {
            return false;
        }
        HashSet set = new HashSet();
        this.radius = 16;
        MAX_SIZE = 1024;
        for (int xx = -this.radius + pos.func_177958_n(); xx < this.radius + pos.func_177958_n(); ++xx) {
            for (int zz = -this.radius + pos.func_177952_p(); zz < this.radius + pos.func_177952_p(); ++zz) {
                this.addBlockToList(new HashedBlockPosition(xx, 0, zz));
            }
        }
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    public IUniversalEnergy getBattery() {
        return this.battery;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("biomeId", this.biomeId);
        int[] array = new int[this.toChangeList.size() * 3];
        Iterator<HashedBlockPosition> itr = this.toChangeList.iterator();
        for (int i = 0; i < this.toChangeList.size(); i += 3) {
            HashedBlockPosition pos = itr.next();
            array[i] = pos.x;
            array[i + 1] = pos.y;
            array[i + 2] = pos.z;
        }
        nbt.func_218657_a("posList", (INBT)new IntArrayNBT(array));
        array = new int[this.discoveredBiomes.size()];
        ListNBT biomeList = new ListNBT();
        int i = 0;
        for (ResourceLocation biome : this.discoveredBiomes) {
            biomeList.add((Object)StringNBT.func_229705_a_((String)biome.toString()));
            ++i;
        }
        nbt.func_218657_a("biomeList", (INBT)biomeList);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        super.readFromNBT(nbt);
        this.biomeId = nbt.func_74762_e("biomeId");
        int[] array = nbt.func_74759_k("posList");
        this.toChangeList.clear();
        for (int i = 0; i < array.length; i += 3) {
            this.toChangeList.add(new HashedBlockPosition(array[i], array[i + 1], array[i + 2]));
        }
        ListNBT biomeList = nbt.func_150295_c("biomeList", 8);
        this.discoveredBiomes.clear();
        for (int i = 0; i < array.length; ++i) {
            this.discoveredBiomes.add(new ResourceLocation(biomeList.func_150307_f(i)));
        }
    }
}

