/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.entity.EntityLaserNode;
import zmaster587.advancedRocketry.event.BlockBreakEvent;
import zmaster587.advancedRocketry.satellite.SatelliteLaserNoDrill;
import zmaster587.libVulpes.util.ZUtils;

public class SatelliteLaser
extends SatelliteLaserNoDrill {
    private EntityLaserNode laser;
    protected boolean finished = false;
    Vector3i ticketLaser = null;

    public SatelliteLaser(IInventory boundChest) {
        super(boundChest);
    }

    @Override
    public boolean isAlive() {
        return this.laser != null && this.laser.func_70089_S();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean getJammed() {
        return this.jammed;
    }

    @Override
    public void setJammed(boolean newJam) {
        this.jammed = newJam;
    }

    @Override
    public void deactivateLaser() {
        if (this.laser != null) {
            this.laser.func_70106_y();
            this.laser = null;
        }
        if (this.ticketLaser != null) {
            ServerWorld worldServer = (ServerWorld)this.world;
            worldServer.func_217458_b(this.ticketLaser.func_177958_n(), this.ticketLaser.func_177952_p(), true);
            this.ticketLaser = null;
        }
        this.finished = false;
    }

    @Override
    public boolean activateLaser(World world, int x, int z) {
        if (world.field_72995_K) {
            return false;
        }
        ServerWorld worldServer = (ServerWorld)world;
        this.ticketLaser = new Vector3i(x >> 4, 0, z >> 4);
        worldServer.func_217458_b(x >> 4, z >> 4, true);
        if (this.ticketLaser != null) {
            int y = 64;
            if (world.func_217349_x(new BlockPos(x, 0, z)).func_201589_g().func_209003_a(ChunkStatus.field_222617_m)) {
                int current = 0;
                for (int i = 0; i < 9; ++i) {
                    current = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x + i % 3 - 1, z + i / 3 - 1);
                    if (current <= y) continue;
                    y = current;
                }
                if (y < 1) {
                    y = 255;
                }
            } else {
                y = 255;
            }
            this.laser = new EntityLaserNode(world, x, y, z);
            this.laser.markValid();
            this.laser.field_98038_p = true;
            world.func_217376_c((Entity)this.laser);
            return true;
        }
        return false;
    }

    @Override
    public void performOperation() {
        for (int i = 0; i < 9; ++i) {
            int x = (int)this.laser.func_226277_ct_() + i % 3 - 1;
            int z = (int)this.laser.func_226281_cx_() + i / 3 - 1;
            BlockPos laserPos = new BlockPos(x, (int)this.laser.func_226278_cu_(), z);
            BlockState state = this.laser.field_70170_p.func_180495_p(laserPos);
            BlockBreakEvent.LaserBreakEvent event = new BlockBreakEvent.LaserBreakEvent(x, (int)this.laser.func_226278_cu_(), z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) continue;
            if (state == Blocks.field_150350_a.func_176223_P() || state.func_185904_a().func_76222_j() || state.func_185904_a().func_76224_d()) {
                this.laser.field_70170_p.func_175656_a(laserPos, AdvancedRocketryBlocks.blockLightSource.func_176223_P());
                continue;
            }
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.laser.field_70170_p);
            state.func_215693_a(builder);
            List items = state.func_215693_a(builder);
            if (!state.func_185904_a().func_76218_k() || state.func_177230_c() == Blocks.field_150357_h) continue;
            if (items.isEmpty()) {
                this.laser.field_70170_p.func_175656_a(laserPos, AdvancedRocketryBlocks.blockLightSource.func_176223_P());
                continue;
            }
            if (this.boundChest != null) {
                ItemStack[] stacks = new ItemStack[items.size()];
                stacks = items.toArray(stacks);
                ZUtils.mergeInventory((ItemStack[])stacks, (IInventory)this.boundChest);
                if (!ZUtils.isInvEmpty((ItemStack[])stacks)) {
                    this.deactivateLaser();
                    this.jammed = true;
                    return;
                }
            }
            this.laser.field_70170_p.func_175656_a(laserPos, AdvancedRocketryBlocks.blockLightSource.func_176223_P());
        }
        boolean blockInWay = false;
        block1: do {
            if (this.laser.func_226278_cu_() < 1.0) {
                this.laser.func_70106_y();
                this.laser = null;
                this.finished = true;
                break;
            }
            this.laser.func_70107_b((int)this.laser.func_226277_ct_(), this.laser.func_226278_cu_() - 1.0, (int)this.laser.func_226281_cx_());
            for (int i = 0; i < 9; ++i) {
                int x = (int)this.laser.func_226277_ct_() + i % 3 - 1;
                int z = (int)this.laser.func_226281_cx_() + i / 3 - 1;
                BlockPos laserPos = new BlockPos(x, (int)this.laser.func_226278_cu_(), z);
                BlockState state = this.laser.field_70170_p.func_180495_p(laserPos);
                if (!state.func_185904_a().func_76218_k() || state.func_177230_c() == Blocks.field_150357_h) continue;
                if (state == Blocks.field_150350_a.func_176223_P() || state.func_185904_a().func_76224_d()) {
                    this.laser.field_70170_p.func_217377_a(laserPos, false);
                    continue;
                }
                if (state == Blocks.field_150350_a.func_176223_P()) continue;
                blockInWay = true;
                continue block1;
            }
        } while (!blockInWay);
    }

    @Override
    public String getInfo(World world) {
        return null;
    }

    @Override
    public String getName() {
        return "Laser";
    }

    @Override
    public boolean performAction(PlayerEntity player, World world, BlockPos pos) {
        this.performOperation();
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74757_a("finished", this.finished);
        nbt.func_74757_a("jammed", this.jammed);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.finished = nbt.func_74767_n("finished");
        this.jammed = nbt.func_74767_n("jammed");
    }

    @Override
    public boolean canTick() {
        return false;
    }

    @Override
    public void tickEntity() {
    }
}

