/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.libVulpes.util.ZUtils;

public class SatelliteLaserNoDrill
extends SatelliteBase {
    protected boolean jammed;
    protected IInventory boundChest;
    World world;
    private static List<ItemStack> ores;
    Random random;

    public SatelliteLaserNoDrill(IInventory boundChest) {
        this.boundChest = boundChest;
        this.random = new Random(System.currentTimeMillis());
        if (ores == null && !ARConfiguration.getCurrentConfig().standardLaserDrillOres.isEmpty()) {
            ores = new LinkedList<ItemStack>();
            for (int i = 0; i < ARConfiguration.getCurrentConfig().standardLaserDrillOres.size(); ++i) {
                ItemStack stack;
                Item item;
                String oreDictName = ARConfiguration.getCurrentConfig().standardLaserDrillOres.get(i);
                String[] args = oreDictName.split(";");
                ResourceLocation itemResource = ResourceLocation.func_208304_a((String)args[0]);
                if (itemResource == null) continue;
                int count = 5;
                try {
                    if (args.length > 1) {
                        count = Integer.parseInt(args[1]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ItemTags.func_199903_a().func_241834_b(new ResourceLocation(args[0])) != null) {
                    item = (Item)ItemTags.func_199903_a().func_241834_b(itemResource).func_230236_b_().get(0);
                    stack = new ItemStack((IItemProvider)item, count);
                    ores.add(stack);
                    continue;
                }
                if (!ForgeRegistries.ITEMS.containsKey(itemResource)) continue;
                item = (Item)ForgeRegistries.ITEMS.getValue(itemResource);
                stack = new ItemStack((IItemProvider)item, count);
                ores.add(stack);
            }
        }
    }

    public boolean isAlive() {
        return this.world != null;
    }

    public boolean isFinished() {
        return false;
    }

    public boolean getJammed() {
        return this.jammed;
    }

    public void setJammed(boolean newJam) {
        this.jammed = newJam;
    }

    public void deactivateLaser() {
        this.world = null;
    }

    public boolean activateLaser(World world, int x, int z) {
        this.world = world;
        return true;
    }

    public void performOperation() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.random.nextInt(10) == 0) {
            ItemStack item = ores.get(this.random.nextInt(ores.size()));
            ItemStack newStack = item.func_77946_l();
            items.add(newStack);
        } else {
            items.add(new ItemStack((IItemProvider)Items.field_221585_m, 5));
        }
        if (this.boundChest != null) {
            ItemStack[] stacks = new ItemStack[items.size()];
            stacks = items.toArray(stacks);
            ZUtils.mergeInventory((ItemStack[])stacks, (IInventory)this.boundChest);
            if (!ZUtils.isInvEmpty((ItemStack[])stacks)) {
                this.deactivateLaser();
                this.jammed = true;
                return;
            }
        }
    }

    @Override
    public String getInfo(World world) {
        return null;
    }

    @Override
    public String getName() {
        return "Laser";
    }

    @Override
    public boolean performAction(PlayerEntity player, World world, BlockPos pos) {
        this.performOperation();
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74757_a("jammed", this.jammed);
    }

    @Override
    public void readFromNBT(CompoundNBT nbt) {
        this.jammed = nbt.func_74767_n("jammed");
    }

    @Override
    public boolean canTick() {
        return false;
    }

    @Override
    public void tickEntity() {
    }
}

