/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.inventory.ContainerOreMappingSatellite;
import zmaster587.advancedRocketry.inventory.ContainerRegistry;
import zmaster587.advancedRocketry.item.ItemOreScanner;

public class SatelliteOreMapping
extends SatelliteBase
implements INamedContainerProvider {
    int blockCenterX;
    int blockCenterZ;
    public static ArrayList<Item> oreList = new ArrayList();
    int selectedSlot = -1;

    public void setSelectedSlot(int i) {
        if (this.canFilterOre()) {
            this.selectedSlot = i;
        }
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public String getInfo(World world) {
        return "Operational";
    }

    @Override
    public boolean acceptsItemInConstruction(ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return super.acceptsItemInConstruction(item) || SatelliteProperties.Property.DATA.isOfType(flag);
    }

    @Override
    public boolean isAcceptableControllerItemStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemOreScanner;
    }

    @Override
    public ItemStack getContollerItemStack(ItemStack satIdChip, SatelliteProperties properties) {
        ItemStack stack = new ItemStack((IItemProvider)AdvancedRocketryItems.itemOreScanner);
        ItemOreScanner scanner = (ItemOreScanner)AdvancedRocketryItems.itemOreScanner;
        scanner.setSatelliteID(stack, properties.getId());
        return stack;
    }

    @Override
    public boolean performAction(PlayerEntity player, World world, BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, packet -> packet.writeBoolean(false));
        return true;
    }

    public boolean canBeginScan() {
        return this.battery.extractEnergy(1000, true) == 1000;
    }

    public int[][] scanChunk(World world, int offsetX, int offsetZ, int radius, int blocksPerPixel, ItemStack block, int zoomLevel) {
        blocksPerPixel = Math.max(blocksPerPixel, 1);
        int[][] ret = new int[radius * 2 / blocksPerPixel][radius * 2 / blocksPerPixel];
        Chunk chunk = world.func_212866_a_(offsetX << 4, offsetZ << 4);
        AbstractChunkProvider provider = world.func_72863_F();
        if (this.canBeginScan() && this.battery.extractEnergy(375 * zoomLevel, false) == 375 * zoomLevel) {
            this.battery.extractEnergy(1000, false);
            this.battery.extractEnergy(375 * zoomLevel, true);
            for (int z = -radius; z < radius; z += blocksPerPixel) {
                for (int x = -radius; x < radius; x += blocksPerPixel) {
                    int oreCount = 0;
                    int otherCount = 0;
                    for (int y = world.func_217301_I(); y > 0; --y) {
                        for (int deltaY = 0; deltaY < blocksPerPixel; ++deltaY) {
                            for (int deltaZ = 0; deltaZ < blocksPerPixel; ++deltaZ) {
                                BlockPos pos = new BlockPos(x + offsetX, y, z + offsetZ);
                                if (world.func_175623_d(pos)) continue;
                                boolean found = false;
                                BlockState state = world.func_180495_p(pos);
                                List drops = state.func_215693_a(new LootContext.Builder((ServerWorld)world));
                                if (drops != null) {
                                    for (ItemStack stack : drops) {
                                        if (stack.func_77973_b() != block.func_77973_b() || stack.func_77952_i() != block.func_77952_i()) continue;
                                        ++oreCount;
                                        found = true;
                                    }
                                }
                                if (found) continue;
                                ++otherCount;
                            }
                        }
                    }
                    oreCount = (int)((double)oreCount / Math.pow(blocksPerPixel, 2.0));
                    otherCount = (int)((double)otherCount / Math.pow(blocksPerPixel, 2.0));
                    if (Thread.interrupted()) {
                        return null;
                    }
                    ret[(x + radius) / blocksPerPixel][(z + radius) / blocksPerPixel] = (int)((float)oreCount / (float)Math.max(otherCount, 1) * 65535.0f);
                }
            }
        }
        return ret;
    }

    public int[][] scanChunk(World world, int offsetX, int offsetZ, int radius, int blocksPerPixel, int zoomLevel) {
        blocksPerPixel = Math.max(blocksPerPixel, 1);
        int[][] ret = new int[radius * 2 / blocksPerPixel][radius * 2 / blocksPerPixel];
        Chunk chunk = world.func_212866_a_(offsetX << 4, offsetZ << 4);
        AbstractChunkProvider provider = world.func_72863_F();
        if (oreList.isEmpty()) {
            Collection strings = ItemTags.func_199903_a().func_199908_a();
            for (ResourceLocation loc : strings) {
                String str = loc.func_110623_a();
                if (!str.startsWith("ore") && !str.startsWith("dust") && !str.startsWith("gem")) continue;
                oreList.addAll(ItemTags.func_199903_a().func_199910_a(loc).func_230236_b_());
            }
        }
        if (this.canBeginScan() && this.battery.extractEnergy(250 * zoomLevel, false) == 250 * zoomLevel) {
            this.battery.extractEnergy(1000, false);
            this.battery.extractEnergy(250 * zoomLevel, true);
            for (int z = -radius; z < radius; z += blocksPerPixel) {
                for (int x = -radius; x < radius; x += blocksPerPixel) {
                    int oreCount = 0;
                    int otherCount = 0;
                    for (int y = world.func_217301_I(); y > 0; --y) {
                        for (int deltaY = 0; deltaY < blocksPerPixel; ++deltaY) {
                            for (int deltaZ = 0; deltaZ < blocksPerPixel; ++deltaZ) {
                                BlockPos pos = new BlockPos(x + offsetX, y, z + offsetZ);
                                if (world.func_175623_d(pos)) continue;
                                boolean exists = false;
                                for (Item item : oreList) {
                                    if (item != Item.func_150898_a((Block)world.func_180495_p(pos).func_177230_c())) continue;
                                    exists = true;
                                    break;
                                }
                                if (exists) {
                                    ++oreCount;
                                    continue;
                                }
                                ++otherCount;
                            }
                        }
                    }
                    oreCount = (int)((double)oreCount / Math.pow(blocksPerPixel, 2.0));
                    otherCount = (int)((double)otherCount / Math.pow(blocksPerPixel, 2.0));
                    if (Thread.interrupted()) {
                        return null;
                    }
                    ret[(x + radius) / blocksPerPixel][(z + radius) / blocksPerPixel] = (int)((float)oreCount / (float)Math.max(otherCount, 1) * 65535.0f);
                }
            }
        }
        return ret;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public String getName() {
        return "Ore Mapper";
    }

    public int getZoomRadius() {
        return Math.min(this.satelliteProperties.getPowerGeneration() / 4, 7);
    }

    public boolean canFilterOre() {
        return this.satelliteProperties.getMaxDataStorage() == 3000;
    }

    public Container createMenu(int id, PlayerInventory playerinv, PlayerEntity player) {
        return new ContainerOreMappingSatellite(ContainerRegistry.CONTAINER_SATELLITE, id, this, playerinv, player);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.getName());
    }
}

