/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.stations;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;
import zmaster587.advancedRocketry.stations.SpaceObjectBase;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.world.util.MultiData;
import zmaster587.libVulpes.util.ZUtils;

public class SpaceObjectAsteroid
extends SpaceObjectBase
implements IDataHandler {
    HashMap<Block, Integer> compositionMapping;
    int numberOfBlocks;
    long uuid;
    MultiData data = new MultiData();

    public SpaceObjectAsteroid() {
        this.data.setMaxData(5000);
        this.setId(Constants.INVALID_PLANET);
    }

    public SpaceObjectAsteroid(HashMap<Block, Integer> compositionMapping, long uuid, int numBlocks) {
        this();
        this.numberOfBlocks = numBlocks;
        this.compositionMapping = compositionMapping;
        this.uuid = uuid;
    }

    public boolean registered() {
        return this.getId() != Constants.INVALID_PLANET;
    }

    public long getAsteroidId() {
        return this.uuid;
    }

    public void setAsteroidId(long id) {
        this.uuid = id;
    }

    public HashMap<Block, Integer> getCompositionMapping() {
        return this.compositionMapping;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public void registerWithSpaceObjectManager() {
        SpaceObjectManager.getSpaceManager().registerTemporarySpaceObject(this, Constants.INVALID_PLANET, ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId()).func_82737_E() + 100000L);
    }

    public static void generateAsteroid(World world, int x, int y, int z) {
    }

    @Override
    public void writeToNbt(CompoundNBT nbt) {
        super.writeToNbt(nbt);
        ListNBT list = new ListNBT();
        for (Map.Entry<Block, Integer> entry : this.compositionMapping.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("id", entry.getKey().getRegistryName().toString());
            tag.func_74768_a("amt", entry.getValue().intValue());
            list.add((Object)tag);
        }
        nbt.func_218657_a("composition", (INBT)list);
        nbt.func_74768_a("numBlocks", this.numberOfBlocks);
        nbt.func_74772_a("uuid", this.uuid);
        this.data.writeToNBT(nbt);
    }

    @Override
    public void readFromNbt(CompoundNBT nbt) {
        super.readFromNbt(nbt);
        ListNBT list = nbt.func_150295_c("composition", 10);
        this.compositionMapping.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            ResourceLocation blockId = new ResourceLocation(tag.func_74779_i("id"));
            int rarity = tag.func_74762_e("amt");
            this.compositionMapping.put((Block)ForgeRegistries.BLOCKS.getValue(blockId), rarity);
        }
        this.numberOfBlocks = nbt.func_74762_e("numBlocks");
        this.uuid = nbt.func_74763_f("uuid");
        this.data.readFromNBT(nbt);
    }

    @Override
    public double getInsolationMultiplier() {
        return 0.0;
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        return 0;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        return 0;
    }

    @Override
    public void setProperties(IDimensionProperties properties) {
    }

    @Override
    public float getOrbitalDistance() {
        return this.getProperties().getParentOrbitalDistance();
    }

    @Override
    public void setOrbitalDistance(float finalVel) {
    }
}

