/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.stations;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.api.stations.IStorageChunk;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public abstract class SpaceObjectBase
implements ISpaceObject {
    private int posX;
    private int posY;
    private int altitude;
    private HashedBlockPosition spawnLocation;
    private double[] rotation;
    private double[] angularVelocity;
    private long lastTimeModification = 0L;
    private DimensionProperties properties = (DimensionProperties)DimensionManager.defaultSpaceDimensionProperties.clone();

    public SpaceObjectBase() {
        this.angularVelocity = new double[3];
        this.rotation = new double[3];
    }

    @Override
    public long getExpireTime() {
        return Long.MAX_VALUE;
    }

    @Override
    public void beginTransition(long time) {
    }

    @Override
    public long getTransitionTime() {
        return 0L;
    }

    @Override
    public ResourceLocation getId() {
        return this.properties.getId();
    }

    @Override
    public DimensionProperties getProperties() {
        return this.properties;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setProperties(DimensionProperties properties) {
        this.properties = properties;
    }

    @Override
    public ResourceLocation getOrbitingPlanetId() {
        return this.properties.getParentPlanet();
    }

    public void setForwardDirection(Direction direction) {
    }

    @Override
    public Direction getForwardDirection() {
        return Direction.DOWN;
    }

    @Override
    public boolean isAnchored() {
        return false;
    }

    @Override
    public void setIsAnchored(boolean anchored) {
    }

    public int getAltitude() {
        return this.altitude;
    }

    @Override
    public double getRotation(Direction dir) {
        return (this.rotation[this.getIDFromDir(dir)] + this.getDeltaRotation(dir) * (double)(this.getWorldTime() - this.lastTimeModification)) % 360.0;
    }

    protected int getIDFromDir(Direction facing) {
        if (facing == Direction.EAST) {
            return 0;
        }
        if (facing == Direction.UP) {
            return 1;
        }
        return 2;
    }

    @Override
    public void setRotation(double rotation, Direction facing) {
        this.rotation[this.getIDFromDir((Direction)facing)] = rotation;
    }

    @Override
    public double getDeltaRotation(Direction facing) {
        return this.angularVelocity[this.getIDFromDir(facing)];
    }

    @Override
    public void setDeltaRotation(double rotation, Direction facing) {
        this.rotation[this.getIDFromDir((Direction)facing)] = this.getRotation(facing);
        this.lastTimeModification = this.getWorldTime();
        this.angularVelocity[this.getIDFromDir((Direction)facing)] = rotation;
    }

    @Override
    public double getMaxRotationalAcceleration() {
        return 0.0;
    }

    private long getWorldTime() {
        return AdvancedRocketry.proxy.getWorldTimeUniversal();
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    @Override
    public HashedBlockPosition getSpawnLocation() {
        return this.spawnLocation;
    }

    @Override
    public void setId(ResourceLocation id) {
        this.properties.setId(id);
    }

    @Override
    public void setPos(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
    }

    @Override
    public void setSpawnLocation(int x, int y, int z) {
        this.spawnLocation = new HashedBlockPosition(x, y, z);
    }

    @Override
    public void setOrbitingBody(ResourceLocation id) {
        if (id == this.getOrbitingPlanetId()) {
            return;
        }
        this.properties.setParentPlanet(DimensionManager.getInstance().getDimensionProperties(id), false);
    }

    @Override
    public void setDestOrbitingBody(ResourceLocation id) {
        if (EffectiveSide.get().isServer()) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(this, PacketStationUpdate.Type.DEST_ORBIT_UPDATE));
        }
    }

    @Override
    public ResourceLocation getDestOrbitingBody() {
        return DimensionManager.overworldProperties.getId();
    }

    @Override
    public void onModuleUnpack(IStorageChunk chunk) {
        ServerWorld worldObj = ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId());
        chunk.pasteInWorld((World)worldObj, this.spawnLocation.x - chunk.getSizeX() / 2, this.spawnLocation.y - chunk.getSizeY() / 2, this.spawnLocation.z - chunk.getSizeZ() / 2);
    }

    @Override
    public void writeToNbt(CompoundNBT nbt) {
        this.properties.writeToNBT(nbt);
        nbt.func_74778_a("id", this.getId().toString());
        nbt.func_74768_a("posX", this.posX);
        nbt.func_74768_a("posY", this.posY);
        nbt.func_74768_a("alitude", this.altitude);
        nbt.func_74768_a("spawnX", this.spawnLocation.x);
        nbt.func_74768_a("spawnY", (int)this.spawnLocation.y);
        nbt.func_74768_a("spawnZ", this.spawnLocation.z);
        nbt.func_74780_a("rotationX", this.rotation[0]);
        nbt.func_74780_a("rotationY", this.rotation[1]);
        nbt.func_74780_a("rotationZ", this.rotation[2]);
        nbt.func_74780_a("deltaRotationX", this.angularVelocity[0]);
        nbt.func_74780_a("deltaRotationY", this.angularVelocity[1]);
        nbt.func_74780_a("deltaRotationZ", this.angularVelocity[2]);
    }

    @Override
    public void readFromNbt(CompoundNBT nbt) {
        this.properties.readFromNBT(nbt);
        this.posX = nbt.func_74762_e("posX");
        this.posY = nbt.func_74762_e("posY");
        this.altitude = nbt.func_74762_e("altitude");
        this.spawnLocation = new HashedBlockPosition(nbt.func_74762_e("spawnX"), nbt.func_74762_e("spawnY"), nbt.func_74762_e("spawnZ"));
        this.properties.setId(new ResourceLocation(nbt.func_74779_i("id")));
        this.rotation[0] = nbt.func_74769_h("rotationX");
        this.rotation[1] = nbt.func_74769_h("rotationY");
        this.rotation[2] = nbt.func_74769_h("rotationZ");
        this.angularVelocity[0] = nbt.func_74769_h("deltaRotationX");
        this.angularVelocity[1] = nbt.func_74769_h("deltaRotationY");
        this.angularVelocity[2] = nbt.func_74769_h("deltaRotationZ");
    }

    @Override
    public boolean hasCustomSpawnLocation() {
        return false;
    }

    @Override
    public boolean hasFreeLandingPad() {
        return false;
    }

    @Override
    public HashedBlockPosition getNextLandingPad(boolean commit) {
        return null;
    }

    @Override
    public void addLandingPad(int x, int z, String name) {
    }

    @Override
    public void removeLandingPad(int x, int z) {
    }

    @Override
    public void setPadStatus(int posX, int posZ, boolean full) {
    }
}

