/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.stations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.ISpaceObjectManager;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public class SpaceObjectManager
implements ISpaceObjectManager {
    public static final ResourceLocation WARPDIMID = new ResourceLocation("warp", "warp");
    private long nextStationTransitionTick = -1L;
    HashMap<ResourceLocation, ISpaceObject> stationLocations = new HashMap();
    HashMap<ResourceLocation, List<ISpaceObject>> spaceStationOrbitMap = new HashMap();
    HashMap<ResourceLocation, Long> temporaryDimensions;
    HashMap<ResourceLocation, Integer> temporaryDimensionPlayerNumber;
    HashMap<String, Class> nameToClass = new HashMap();
    HashMap<Class, String> classToString = new HashMap();
    public static final String STATION_NAMESPACE = "station";
    private static final SpaceObjectManager spaceObjectManager = new SpaceObjectManager();

    private SpaceObjectManager() {
        this.temporaryDimensions = new HashMap();
        AdvancedRocketryAPI.spaceObjectManager = this;
    }

    public static final SpaceObjectManager getSpaceManager() {
        return spaceObjectManager;
    }

    public ISpaceObject getSpaceStation(ResourceLocation id) {
        return this.stationLocations.get(id);
    }

    public Collection<ISpaceObject> getSpaceObjects() {
        return this.stationLocations.values();
    }

    public ResourceLocation getNextStationId() {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            ResourceLocation newID = new ResourceLocation(STATION_NAMESPACE, String.valueOf(i));
            if (this.stationLocations.containsKey(newID)) continue;
            return newID;
        }
        return null;
    }

    public void registerSpaceObjectType(String str, Class<? extends Object> clazz) {
        this.nameToClass.put(str, clazz);
        this.classToString.put(clazz, str);
    }

    public ISpaceObject getNewSpaceObjectFromIdentifier(String id) {
        Class clazz = this.nameToClass.get(id);
        try {
            return (ISpaceObject)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getItentifierFromClass(Class<? extends ISpaceObject> clazz) {
        return this.classToString.get(clazz);
    }

    @Override
    public ISpaceObject getSpaceStationFromBlockCoords(BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        x = Math.round((float)x / (2.0f * (float)((Integer)ARConfiguration.getCurrentConfig().stationSize.get()).intValue()));
        z = Math.round((float)z / (2.0f * (float)((Integer)ARConfiguration.getCurrentConfig().stationSize.get()).intValue()));
        int radius = Math.max(Math.abs(x), Math.abs(z));
        int index = (int)Math.pow(2 * radius - 1, 2.0) + x + radius;
        if (Math.abs(z) != radius) {
            index = (int)Math.pow(2 * radius - 1, 2.0) + z + radius + (4 * radius + 2) - 1;
            if (x > 0) {
                index += 2 * radius - 1;
            }
        } else if (z > 0) {
            index += 2 * radius + 1;
        }
        return this.getSpaceStation(new ResourceLocation(STATION_NAMESPACE, String.valueOf(index)));
    }

    public void registerSpaceObject(ISpaceObject object, ResourceLocation dimId, ResourceLocation stationId) {
        int z;
        int x;
        object.setId(stationId);
        this.stationLocations.put(stationId, object);
        int stationIDAsInt = Integer.parseInt(stationId.func_110623_a());
        int radius = (int)Math.floor(Math.ceil(Math.sqrt(stationIDAsInt + 1)) / 2.0);
        int ringIndex = (int)((double)stationIDAsInt - Math.pow(radius * 2 - 1, 2.0));
        if (ringIndex < (radius * 2 + 1) * 2) {
            x = ringIndex % (radius * 2 + 1) - radius;
            z = ringIndex < radius * 2 + 1 ? -radius : radius;
        } else {
            int newIndex = ringIndex - (radius * 2 + 1) * 2;
            z = newIndex % ((radius - 1) * 2 + 1) - (radius - 1);
            x = newIndex < (radius - 1) * 2 + 1 ? -radius : radius;
        }
        if (!object.hasCustomSpawnLocation()) {
            object.setSpawnLocation(2 * (Integer)ARConfiguration.getCurrentConfig().stationSize.get() * x + (Integer)ARConfiguration.getCurrentConfig().stationSize.get() / 2, 128, 2 * (Integer)ARConfiguration.getCurrentConfig().stationSize.get() * z + (Integer)ARConfiguration.getCurrentConfig().stationSize.get() / 2);
        }
        object.setOrbitingBody(dimId);
        this.moveStationToBody(object, dimId, false);
    }

    public void registerTemporarySpaceObject(ISpaceObject object, ResourceLocation dimId, long expireTime) {
        ResourceLocation nextDimId = this.getNextStationId();
        this.temporaryDimensions.put(nextDimId, expireTime);
        this.temporaryDimensionPlayerNumber.put(dimId, 0);
        this.registerSpaceObject(object, nextDimId);
    }

    public void registerSpaceObject(ISpaceObject object, ResourceLocation nextDimId) {
        this.registerSpaceObject(object, nextDimId, this.getNextStationId());
        PacketHandler.sendToAll((BasePacket)new PacketSpaceStationInfo(object.getId(), object));
    }

    public void unregisterSpaceObject(ResourceLocation id) {
        this.temporaryDimensions.remove(id);
        this.temporaryDimensionPlayerNumber.remove(id);
        this.spaceStationOrbitMap.remove(id);
        this.stationLocations.remove(id);
        PacketHandler.sendToAll((BasePacket)new PacketSpaceStationInfo(id, null));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerSpaceObjectClient(ISpaceObject object, ResourceLocation dimId, ResourceLocation stationId) {
        this.registerSpaceObject(object, dimId, stationId);
    }

    public List<ISpaceObject> getSpaceStationsOrbitingPlanet(ResourceLocation planetId) {
        return this.spaceStationOrbitMap.get(planetId);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)event.player.field_70170_p))) {
            int result;
            ISpaceObject object;
            if (event.player.func_226278_cu_() < 0.0 && !event.player.field_70170_p.field_72995_K && (object = this.getSpaceStationFromBlockCoords(new BlockPos(event.player.func_213303_ch()))) != null) {
                HashedBlockPosition loc = object.getSpawnLocation();
                event.player.field_70143_R = 0.0f;
                event.player.func_213317_d(event.player.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                event.player.func_70634_a((double)loc.x, (double)(loc.y + 2), (double)loc.z);
                event.player.func_145747_a((ITextComponent)new StringTextComponent("You wake up finding yourself back on the station"), Util.field_240973_b_);
            }
            if ((result = Math.abs(2 * (((int)event.player.func_226281_cx_() + (Integer)ARConfiguration.getCurrentConfig().stationSize.get() / 2) % (2 * (Integer)ARConfiguration.getCurrentConfig().stationSize.get())) / (Integer)ARConfiguration.getCurrentConfig().stationSize.get())) == 0 || result == 3) {
                event.player.func_213317_d(event.player.func_213322_ci().func_216372_d(1.0, 1.0, -1.0));
                if (result == 0) {
                    event.player.func_70107_b(event.player.func_226277_ct_(), event.player.func_226278_cu_(), event.player.func_226281_cx_() + (event.player.func_226281_cx_() < 0.0 ? Math.abs(event.player.func_226281_cx_() % 16.0) : 16.0 - event.player.func_226281_cx_() % 16.0));
                } else {
                    event.player.func_70107_b(event.player.func_226277_ct_(), event.player.func_226278_cu_(), event.player.func_226281_cx_() - (event.player.func_226281_cx_() < 0.0 ? 16.0 - Math.abs(event.player.func_226281_cx_() % 16.0) : event.player.func_226281_cx_() % 16.0));
                }
            }
            result = Math.abs(2 * (((int)event.player.func_226277_ct_() + (Integer)ARConfiguration.getCurrentConfig().stationSize.get() / 2) % (2 * (Integer)ARConfiguration.getCurrentConfig().stationSize.get())) / (Integer)ARConfiguration.getCurrentConfig().stationSize.get());
            if (event.player.func_226277_ct_() < (double)(-((Integer)ARConfiguration.getCurrentConfig().stationSize.get()).intValue() / 2)) {
                if (result == 3) {
                    result = 0;
                } else if (result == 0) {
                    result = 3;
                }
            }
            if (result == 0 || result == 3) {
                event.player.func_213317_d(event.player.func_213322_ci().func_216372_d(-1.0, 1.0, 1.0));
                if (result == 0) {
                    event.player.func_70107_b(event.player.func_226277_ct_() + (event.player.func_226277_ct_() < 0.0 ? Math.abs(event.player.func_226277_ct_() % 16.0) : 16.0 - event.player.func_226277_ct_() % 16.0), event.player.func_226278_cu_(), event.player.func_226281_cx_());
                } else {
                    event.player.func_70107_b(event.player.func_226277_ct_() - (event.player.func_226277_ct_() < 0.0 ? 16.0 - Math.abs(event.player.func_226277_ct_() % 16.0) : event.player.func_226277_ct_() % 16.0), event.player.func_226278_cu_(), event.player.func_226281_cx_());
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId()) == null) {
            return;
        }
        long worldTime = ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId()).func_82737_E();
        if (this.nextStationTransitionTick != -1L && worldTime >= this.nextStationTransitionTick && this.spaceStationOrbitMap.get(WARPDIMID) != null || this.nextStationTransitionTick == -1L && this.spaceStationOrbitMap.get(WARPDIMID) != null && !this.spaceStationOrbitMap.get(WARPDIMID).isEmpty()) {
            long newNextTransitionTick = -1L;
            for (ISpaceObject obj : this.spaceStationOrbitMap.get(WARPDIMID)) {
                if (obj.getTransitionTime() <= worldTime) {
                    this.moveStationToBody(obj, obj.getDestOrbitingBody());
                    this.spaceStationOrbitMap.get(WARPDIMID).remove(obj);
                    continue;
                }
                if (newNextTransitionTick != -1L && obj.getTransitionTime() >= newNextTransitionTick) continue;
                newNextTransitionTick = obj.getTransitionTime();
            }
            this.nextStationTransitionTick = newNextTransitionTick;
        }
    }

    public void onServerStopped() {
        this.stationLocations.clear();
        this.spaceStationOrbitMap.clear();
        this.temporaryDimensions.clear();
        this.nextStationTransitionTick = -1L;
    }

    public void moveStationToBody(ISpaceObject station, ResourceLocation dimId) {
        this.moveStationToBody(station, dimId, true);
    }

    public void moveStationToBody(ISpaceObject station, ResourceLocation dimId, boolean update) {
        if (this.spaceStationOrbitMap.get(station.getOrbitingPlanetId()) != null) {
            this.spaceStationOrbitMap.get(station.getOrbitingPlanetId()).remove(station);
        }
        if (this.spaceStationOrbitMap.get(dimId) == null) {
            this.spaceStationOrbitMap.put(dimId, new LinkedList());
        }
        if (!this.spaceStationOrbitMap.get(dimId).contains(station)) {
            this.spaceStationOrbitMap.get(dimId).add(station);
        }
        station.setOrbitingBody(dimId);
        if (update) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(station, PacketStationUpdate.Type.ORBIT_UPDATE));
            AdvancedRocketry.proxy.fireFogBurst(station);
        }
    }

    public void moveStationToBody(ISpaceObject station, ResourceLocation dimId, int timeDelta) {
        if (!WARPDIMID.equals((Object)station.getOrbitingPlanetId()) && this.spaceStationOrbitMap.get(station.getOrbitingPlanetId()) != null) {
            this.spaceStationOrbitMap.get(station.getOrbitingPlanetId()).remove(station);
        }
        if (this.spaceStationOrbitMap.get(WARPDIMID) == null) {
            this.spaceStationOrbitMap.put(WARPDIMID, new LinkedList());
        }
        if (!this.spaceStationOrbitMap.get(WARPDIMID).contains(station)) {
            this.spaceStationOrbitMap.get(WARPDIMID).add(station);
        }
        station.setOrbitingBody(WARPDIMID);
        PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(station, PacketStationUpdate.Type.ORBIT_UPDATE));
        AdvancedRocketry.proxy.fireFogBurst(station);
        ((DimensionProperties)station.getProperties()).setAtmosphereDensityDirect(0);
        this.nextStationTransitionTick = (long)((int)((Double)ARConfiguration.getCurrentConfig().travelTimeMultiplier.get() * (double)timeDelta)) + ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId()).func_82737_E();
        station.beginTransition(this.nextStationTransitionTick);
    }

    public void writeToNBT(CompoundNBT nbt) {
        Iterator<ISpaceObject> iterator = this.stationLocations.values().iterator();
        ListNBT nbtList = new ListNBT();
        while (iterator.hasNext()) {
            ISpaceObject object = iterator.next();
            CompoundNBT nbtTag = new CompoundNBT();
            object.writeToNbt(nbtTag);
            nbtTag.func_74778_a("type", this.classToString.get(object.getClass()));
            if (this.temporaryDimensions.containsKey(object.getId())) {
                nbtTag.func_74772_a("expireTime", this.temporaryDimensions.get(object.getId()).longValue());
                nbtTag.func_74768_a("numPlayers", this.temporaryDimensionPlayerNumber.get(object.getId()).intValue());
            }
            nbtList.add((Object)nbtTag);
        }
        nbt.func_218657_a("spaceContents", (INBT)nbtList);
        nbt.func_74772_a("nextStationTransitionTick", this.nextStationTransitionTick);
    }

    public void readFromNBT(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("spaceContents", 10);
        this.nextStationTransitionTick = nbt.func_74763_f("nextStationTransitionTick");
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            try {
                ISpaceObject object = (ISpaceObject)this.nameToClass.get(tag.func_74779_i("type")).newInstance();
                object.readFromNbt(tag);
                if (tag.func_74764_b("expireTime")) {
                    long expireTime = tag.func_74763_f("expireTime");
                    int numPlayers = tag.func_74762_e("numPlayers");
                    if (ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId()).func_82737_E() >= expireTime && numPlayers == 0) continue;
                    this.temporaryDimensions.put(object.getId(), expireTime);
                    this.temporaryDimensionPlayerNumber.put(object.getId(), numPlayers);
                }
                this.registerSpaceObject(object, object.getOrbitingPlanetId(), object.getId());
                continue;
            }
            catch (Exception e) {
                System.out.println(tag.func_74779_i("type"));
                e.printStackTrace();
            }
        }
    }
}

