/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.stations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.api.stations.IStorageChunk;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.tile.station.TileDockingPort;
import zmaster587.advancedRocketry.util.SpacePosition;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.libVulpes.block.BlockFullyRotatable;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.ZUtils;

public class SpaceStationObject
implements ISpaceObject,
IPlanetDefiner {
    private int launchPosX;
    private int launchPosZ;
    private int posX;
    private int posZ;
    private boolean created = false;
    private int altitude;
    private float orbitalDistance = 4.0f;
    private ResourceLocation destinationDimId;
    private int fuelAmount;
    private final int MAX_FUEL = 1000;
    private HashedBlockPosition spawnLocation;
    private List<StationLandingLocation> spawnLocations;
    private List<HashedBlockPosition> warpCoreLocation;
    private Set<ResourceLocation> knownPlanetList;
    private HashMap<HashedBlockPosition, String> dockingPoints;
    private long transitionEta = -1L;
    private boolean isAnchored = false;
    private double[] rotation;
    private double[] angularVelocity;
    private long lastTimeModification = 0L;
    private DimensionProperties properties = (DimensionProperties)DimensionManager.defaultSpaceDimensionProperties.clone();
    public boolean hasWarpCores = false;
    private Direction direction;
    public int targetOrbitalDistance = 4;
    public int targetGravity = 10;
    public int[] targetRotationsPerHour = new int[]{0, 0, 0};

    public SpaceStationObject() {
        this.spawnLocations = new LinkedList<StationLandingLocation>();
        this.warpCoreLocation = new LinkedList<HashedBlockPosition>();
        this.dockingPoints = new HashMap();
        this.destinationDimId = DimensionManager.overworldProperties.getId();
        this.knownPlanetList = new HashSet<ResourceLocation>();
        this.angularVelocity = new double[3];
        this.rotation = new double[3];
    }

    @Override
    public long getExpireTime() {
        return Long.MAX_VALUE;
    }

    @Override
    public void beginTransition(long time) {
        if (time > 0L) {
            this.transitionEta = time;
        }
        this.created = true;
    }

    public boolean isWarping() {
        return this.getOrbitingPlanetId() == SpaceObjectManager.WARPDIMID;
    }

    @Override
    public long getTransitionTime() {
        return this.transitionEta;
    }

    public void setTargetRotationsPerHour(int index, int rotations) {
        this.targetRotationsPerHour[index] = rotations;
    }

    public void discoverPlanet(ResourceLocation pid) {
        this.knownPlanetList.add(pid);
        PacketHandler.sendToAll((BasePacket)new PacketSpaceStationInfo(this.getId(), this));
    }

    @Override
    public DimensionProperties getProperties() {
        return this.properties;
    }

    @Override
    public double getInsolationMultiplier() {
        return this.isWarping() ? 0.0 : this.getOrbitingPlanet().getPeakInsolationMultiplierWithoutAtmosphere();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setProperties(IDimensionProperties properties) {
        this.properties = (DimensionProperties)properties;
    }

    @Override
    public ResourceLocation getOrbitingPlanetId() {
        return this.created ? this.properties.getParentPlanet() : Constants.INVALID_PLANET;
    }

    public DimensionProperties getOrbitingPlanet() {
        ResourceLocation planetId = this.getOrbitingPlanetId();
        if (!Constants.INVALID_PLANET.equals((Object)planetId)) {
            return DimensionManager.getInstance().getDimensionProperties(planetId);
        }
        return null;
    }

    public void setForwardDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public Direction getForwardDirection() {
        if (this.direction == null) {
            return Direction.NORTH;
        }
        return this.direction;
    }

    @Override
    public boolean isAnchored() {
        return this.isAnchored;
    }

    @Override
    public void setIsAnchored(boolean anchored) {
        this.isAnchored = anchored;
    }

    public int getAltitude() {
        return this.altitude;
    }

    @Override
    public double getRotation(Direction dir) {
        return (this.rotation[this.getIDFromDir(dir)] + this.getDeltaRotation(dir) * (double)(this.getWorldTime() - this.lastTimeModification)) % 360.0;
    }

    public boolean isStationFacingPlanet() {
        return Math.abs(this.rotation[0] - (double)((int)this.rotation[0]) - 0.5) > 0.4 && Math.abs(this.rotation[2] - (double)((int)this.rotation[2]) - 0.5) > 0.4;
    }

    public boolean wouldStationBreakTether() {
        return 0.47 > Math.abs(this.rotation[0] - (double)((int)this.rotation[0]) - 0.5) || 0.47 > Math.abs(this.rotation[2] - (double)((int)this.rotation[2]) - 0.5) || Math.abs(this.getDeltaRotation(Direction.UP)) > 0.0 || Math.abs(this.getDeltaRotation(Direction.NORTH)) > 0.0 || Math.abs(this.getDeltaRotation(Direction.EAST)) > 0.0;
    }

    private int getIDFromDir(Direction facing) {
        if (facing == Direction.EAST) {
            return 0;
        }
        if (facing == Direction.UP) {
            return 1;
        }
        return 2;
    }

    @Override
    public void setRotation(double rotation, Direction facing) {
        this.rotation[this.getIDFromDir((Direction)facing)] = rotation;
    }

    @Override
    public double getDeltaRotation(Direction facing) {
        return this.angularVelocity[this.getIDFromDir(facing)];
    }

    @Override
    public void setDeltaRotation(double rotation, Direction facing) {
        if (!this.isAnchored()) {
            this.rotation[this.getIDFromDir((Direction)facing)] = this.getRotation(facing);
            this.lastTimeModification = this.getWorldTime();
            this.angularVelocity[this.getIDFromDir((Direction)facing)] = rotation;
        }
    }

    @Override
    public double getMaxRotationalAcceleration() {
        return 5.0E-6;
    }

    private long getWorldTime() {
        return AdvancedRocketry.proxy.getWorldTimeUniversal();
    }

    public int getLaunchPosX() {
        return this.launchPosX;
    }

    public int getLaunchPosZ() {
        return this.launchPosZ;
    }

    public int getOrbitalPosX() {
        return this.posX;
    }

    public int getOrbitalPosZ() {
        return this.posZ;
    }

    public double getOrbitalVelocity() {
        return 0.0;
    }

    @Override
    public HashedBlockPosition getSpawnLocation() {
        return this.spawnLocation;
    }

    public SpacePosition getSpacePosition() {
        List<ISpaceObject> stations = SpaceObjectManager.getSpaceManager().getSpaceStationsOrbitingPlanet(this.getOrbitingPlanetId());
        if (stations.size() == 0) {
            return new SpacePosition();
        }
        DimensionProperties properties = this.getOrbitingPlanet();
        int stationCount = stations.size();
        int myIndex = stations.indexOf(this);
        float theta = myIndex * (360 / stationCount);
        return new SpacePosition().getFromSpherical(properties.getRenderSizePlanetView() * 2.0f, theta);
    }

    public void addWarpCore(HashedBlockPosition position) {
        this.warpCoreLocation.add(position);
        this.hasWarpCores = true;
    }

    public void removeWarpCore(HashedBlockPosition position) {
        this.warpCoreLocation.remove(position);
        if (this.warpCoreLocation.size() == 0) {
            this.hasWarpCores = false;
        }
    }

    public List<HashedBlockPosition> getWarpCoreLocations() {
        return this.warpCoreLocation;
    }

    public boolean hasUsableWarpCore() {
        return this.hasWarpCores && !SpaceObjectManager.WARPDIMID.equals((Object)this.properties.getParentPlanet()) && !this.getOrbitingPlanetId().equals((Object)this.getDestOrbitingBody());
    }

    public int getFuelAmount() {
        return this.fuelAmount;
    }

    public int getMaxFuelAmount() {
        return 1000;
    }

    public void setFuelAmount(int amt) {
        this.fuelAmount = amt;
    }

    public int addFuel(int amt) {
        if (amt < 0) {
            return amt;
        }
        int oldFuelAmt = this.fuelAmount;
        this.fuelAmount = Math.min(this.fuelAmount + amt, 1000);
        amt = this.fuelAmount - oldFuelAmt;
        if (EffectiveSide.get().isServer()) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(this, PacketStationUpdate.Type.FUEL_UPDATE));
        }
        return amt;
    }

    public int useFuel(int amt) {
        if (amt > this.getFuelAmount()) {
            return 0;
        }
        this.fuelAmount -= amt;
        if (EffectiveSide.get().isServer()) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(this, PacketStationUpdate.Type.FUEL_UPDATE));
        }
        return amt;
    }

    public void setLandingPadAutoLandStatus(BlockPos pos, boolean status) {
        this.setLandingPadAutoLandStatus(pos.func_177958_n(), pos.func_177952_p(), status);
    }

    public void setLandingPadAutoLandStatus(int x, int z, boolean status) {
        HashedBlockPosition pos = new HashedBlockPosition(x, 0, z);
        for (StationLandingLocation loc : this.spawnLocations) {
            if (!loc.getPos().equals((Object)pos)) continue;
            loc.setAllowedForAutoLand(status);
        }
    }

    public void addLandingPad(BlockPos pos, String name) {
        this.addLandingPad(pos.func_177958_n(), pos.func_177952_p(), name);
    }

    @Override
    public void addLandingPad(int x, int z, String name) {
        StationLandingLocation pos = new StationLandingLocation(new HashedBlockPosition(x, 0, z), name);
        if (!this.spawnLocations.contains(pos)) {
            this.spawnLocations.add(pos);
            pos.setOccupied(false);
        }
    }

    public void removeLandingPad(BlockPos pos) {
        this.removeLandingPad(pos.func_177958_n(), pos.func_177952_p());
    }

    @Override
    public void removeLandingPad(int x, int z) {
        HashedBlockPosition pos = new HashedBlockPosition(x, 0, z);
        Iterator<StationLandingLocation> itr = this.spawnLocations.iterator();
        while (itr.hasNext()) {
            StationLandingLocation loc = itr.next();
            if (!loc.getPos().equals((Object)pos)) continue;
            itr.remove();
        }
    }

    public void addDockingPosition(BlockPos pos, String str) {
        HashedBlockPosition pos2 = new HashedBlockPosition(pos);
        this.dockingPoints.put(pos2, str);
    }

    public void removeDockingPosition(BlockPos pos) {
        HashedBlockPosition pos2 = new HashedBlockPosition(pos);
        this.dockingPoints.remove(pos2);
    }

    @Override
    public HashedBlockPosition getNextLandingPad(boolean commit) {
        for (StationLandingLocation pos : this.spawnLocations) {
            if (pos.getOccupied() || !pos.getAllowedForAutoLand()) continue;
            if (commit) {
                pos.setOccupied(true);
            }
            return pos.getPos();
        }
        return null;
    }

    public List<StationLandingLocation> getLandingPads() {
        return this.spawnLocations;
    }

    @Override
    public boolean hasFreeLandingPad() {
        for (StationLandingLocation pos : this.spawnLocations) {
            if (pos.getOccupied()) continue;
            return true;
        }
        return false;
    }

    public void setPadStatus(BlockPos pos, boolean full) {
        this.setPadStatus(pos.func_177958_n(), pos.func_177952_p(), full);
    }

    public StationLandingLocation getPadAtLocation(HashedBlockPosition pos) {
        pos.y = 0;
        for (StationLandingLocation loc : this.spawnLocations) {
            if (!loc.equals(pos)) continue;
            return loc;
        }
        return null;
    }

    public void setPadName(World worldObj, HashedBlockPosition pos, String name) {
        StationLandingLocation loc = this.getPadAtLocation(pos);
        if (loc != null) {
            loc.setName(name);
        }
        if (!worldObj.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSpaceStationInfo(this.getId(), this));
        }
    }

    @Override
    public void setPadStatus(int x, int z, boolean full) {
        StationLandingLocation pos = new StationLandingLocation(new HashedBlockPosition(x, 0, z));
        for (StationLandingLocation loc : this.spawnLocations) {
            if (!loc.equals(pos)) continue;
            loc.setOccupied(full);
        }
    }

    @Override
    public void setId(ResourceLocation id) {
        this.properties.setId(id);
    }

    @Override
    public void setPos(int posX, int posY) {
        this.posX = posX;
        this.posZ = posY;
    }

    public void setLaunchPos(int posX, int posY) {
        this.launchPosX = posX;
        this.launchPosZ = posY;
    }

    @Override
    public void setSpawnLocation(int x, int y, int z) {
        this.spawnLocation = new HashedBlockPosition(x, y, z);
    }

    @Override
    public void setOrbitingBody(ResourceLocation id) {
        if (this.getOrbitingPlanetId().equals((Object)id)) {
            return;
        }
        this.properties.setParentPlanet(DimensionManager.getInstance().getDimensionProperties(id), false);
        if (!SpaceObjectManager.WARPDIMID.equals((Object)id)) {
            this.destinationDimId = id;
        }
    }

    @Override
    public void setDestOrbitingBody(ResourceLocation id) {
        this.destinationDimId = id;
        if (EffectiveSide.get().isServer()) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(this, PacketStationUpdate.Type.DEST_ORBIT_UPDATE));
        }
    }

    @Override
    public ResourceLocation getDestOrbitingBody() {
        return this.destinationDimId;
    }

    @Override
    public void onModuleUnpack(IStorageChunk chunk) {
        if (ZUtils.isWorldLoaded((ResourceLocation)ARConfiguration.GetSpaceDimId()) && ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId()) == null) {
            ZUtils.initDimension((ResourceLocation)ARConfiguration.GetSpaceDimId());
        }
        ServerWorld worldObj = ZUtils.getWorld((ResourceLocation)ARConfiguration.GetSpaceDimId());
        if (!this.created) {
            chunk.pasteInWorld((World)worldObj, this.spawnLocation.x - chunk.getSizeX() / 2, this.spawnLocation.y - chunk.getSizeY() / 2, this.spawnLocation.z - chunk.getSizeZ() / 2);
            this.created = true;
            this.setLaunchPos(this.posX, this.posZ);
            this.setPos(this.posX, this.posZ);
        } else {
            List<TileEntity> tiles = chunk.getTileEntityList();
            LinkedList<String> targetIds = new LinkedList<String>();
            LinkedList<TileEntity> myPoss = new LinkedList<TileEntity>();
            HashedBlockPosition pos = null;
            TileDockingPort destTile = null;
            TileDockingPort srcTile = null;
            for (TileEntity tileEntity : tiles) {
                if (!(tileEntity instanceof TileDockingPort)) continue;
                targetIds.add(((TileDockingPort)tileEntity).getTargetId());
                myPoss.add(tileEntity);
            }
            for (Map.Entry entry : this.dockingPoints.entrySet()) {
                if (!targetIds.contains(entry.getValue())) continue;
                int loc = targetIds.indexOf(entry.getValue());
                pos = (HashedBlockPosition)entry.getKey();
                TileEntity tile = worldObj.func_175625_s(pos.getBlockPos());
                if (!(tile instanceof TileDockingPort)) continue;
                destTile = (TileDockingPort)tile;
                srcTile = (TileDockingPort)((Object)myPoss.get(loc));
                break;
            }
            if (destTile != null) {
                Direction stationFacing = (Direction)destTile.func_195044_w().func_177229_b((Property)BlockFullyRotatable.FACING);
                Direction direction = (Direction)srcTile.func_195044_w().func_177229_b((Property)BlockFullyRotatable.FACING);
                Direction cross = SpaceStationObject.rotateAround(direction, stationFacing.func_176740_k());
                if (stationFacing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
                    cross = cross.func_176734_d();
                }
                if (cross == direction) {
                    if (direction == stationFacing) {
                        if (cross == Direction.DOWN || cross == Direction.UP) {
                            chunk.rotateBy(Direction.NORTH);
                            chunk.rotateBy(Direction.NORTH);
                        } else {
                            chunk.rotateBy(Direction.UP);
                            chunk.rotateBy(Direction.UP);
                        }
                    }
                } else if (cross.func_176734_d() != direction) {
                    chunk.rotateBy(stationFacing.func_96559_d() == 0 ? cross : cross.func_176734_d());
                }
                int xCoord = (stationFacing.func_82601_c() == 0 ? -srcTile.func_174877_v().func_177958_n() : srcTile.func_174877_v().func_177958_n() * stationFacing.func_82601_c()) + stationFacing.func_82601_c() + destTile.func_174877_v().func_177958_n();
                int yCoord = (stationFacing.func_96559_d() == 0 ? -srcTile.func_174877_v().func_177956_o() : srcTile.func_174877_v().func_177956_o() * stationFacing.func_96559_d()) + stationFacing.func_96559_d() + destTile.func_174877_v().func_177956_o();
                int zCoord = (stationFacing.func_82599_e() == 0 ? -srcTile.func_174877_v().func_177952_p() : srcTile.func_174877_v().func_177952_p() * stationFacing.func_82599_e()) + stationFacing.func_82599_e() + destTile.func_174877_v().func_177952_p();
                chunk.pasteInWorld((World)worldObj, xCoord, yCoord, zCoord);
                worldObj.func_217377_a(destTile.func_174877_v().func_177972_a(stationFacing), false);
                worldObj.func_217377_a(destTile.func_174877_v(), false);
            }
        }
    }

    private static Direction rotateAround(Direction inputDir, Direction.Axis axis) {
        switch (axis) {
            case X: {
                if (inputDir != Direction.WEST && inputDir != Direction.EAST) {
                    return SpaceStationObject.rotateX(inputDir);
                }
                return inputDir;
            }
            case Y: {
                if (inputDir != Direction.UP && inputDir != Direction.DOWN) {
                    return SpaceStationObject.rotateY(inputDir);
                }
                return inputDir;
            }
            case Z: {
                if (inputDir != Direction.NORTH && inputDir != Direction.SOUTH) {
                    return SpaceStationObject.rotateZ(inputDir);
                }
                return inputDir;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    private static Direction rotateX(Direction inputDir) {
        switch (inputDir) {
            case NORTH: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + inputDir);
            }
            case SOUTH: {
                return Direction.UP;
            }
            case UP: {
                return Direction.NORTH;
            }
            case DOWN: 
        }
        return Direction.SOUTH;
    }

    private static Direction rotateZ(Direction inputDir) {
        switch (inputDir) {
            case EAST: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + inputDir);
            }
            case WEST: {
                return Direction.UP;
            }
            case UP: {
                return Direction.EAST;
            }
            case DOWN: 
        }
        return Direction.WEST;
    }

    private static Direction rotateY(Direction inputDir) {
        switch (inputDir) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + inputDir);
    }

    @Override
    public void writeToNbt(CompoundNBT nbt) {
        CompoundNBT tag;
        this.properties.writeToNBT(nbt);
        nbt.func_74778_a("id", this.getId().toString());
        nbt.func_74768_a("launchposX", this.launchPosX);
        nbt.func_74768_a("launchposY", this.launchPosZ);
        nbt.func_74757_a("isAnchored", this.isAnchored);
        nbt.func_74768_a("posX", this.posX);
        nbt.func_74768_a("posY", this.posZ);
        nbt.func_74757_a("created", this.created);
        nbt.func_74768_a("alitude", this.altitude);
        nbt.func_74768_a("spawnX", this.spawnLocation.x);
        nbt.func_74768_a("spawnY", (int)this.spawnLocation.y);
        nbt.func_74768_a("spawnZ", this.spawnLocation.z);
        nbt.func_74778_a("destinationDimId", this.destinationDimId.toString());
        nbt.func_74768_a("fuel", this.fuelAmount);
        nbt.func_74776_a("orbitalDistance", this.orbitalDistance);
        nbt.func_74768_a("targetOrbitalDistance", this.targetOrbitalDistance);
        nbt.func_74768_a("targetGravity", this.targetGravity);
        nbt.func_74768_a("targetRotationX", this.targetRotationsPerHour[0]);
        nbt.func_74768_a("targetRotationY", this.targetRotationsPerHour[1]);
        nbt.func_74768_a("targetRotationZ", this.targetRotationsPerHour[2]);
        nbt.func_74780_a("rotationX", this.rotation[0]);
        nbt.func_74780_a("rotationY", this.rotation[1]);
        nbt.func_74780_a("rotationZ", this.rotation[2]);
        nbt.func_74780_a("deltaRotationX", this.angularVelocity[0]);
        nbt.func_74780_a("deltaRotationY", this.angularVelocity[1]);
        nbt.func_74780_a("deltaRotationZ", this.angularVelocity[2]);
        ListNBT planetList = new ListNBT();
        for (ResourceLocation i : this.knownPlanetList) {
            planetList.add((Object)StringNBT.func_229705_a_((String)i.toString()));
        }
        nbt.func_218657_a("knownPlanets", (INBT)planetList);
        if (this.direction != null) {
            nbt.func_74768_a("direction", this.direction.ordinal());
        }
        if (this.transitionEta > -1L) {
            nbt.func_74772_a("transitionEta", this.transitionEta);
        }
        ListNBT list = new ListNBT();
        for (StationLandingLocation stationLandingLocation : this.spawnLocations) {
            tag = new CompoundNBT();
            tag.func_74757_a("occupied", stationLandingLocation.getOccupied());
            tag.func_74757_a("autoLand", stationLandingLocation.getAllowedForAutoLand());
            tag.func_74783_a("pos", new int[]{stationLandingLocation.getPos().x, stationLandingLocation.getPos().z});
            tag.func_74778_a("name", stationLandingLocation.getName());
            list.add((Object)tag);
        }
        nbt.func_218657_a("spawnPositions", (INBT)list);
        list = new ListNBT();
        for (HashedBlockPosition hashedBlockPosition : this.warpCoreLocation) {
            tag = new CompoundNBT();
            tag.func_74783_a("pos", new int[]{hashedBlockPosition.x, hashedBlockPosition.y, hashedBlockPosition.z});
            list.add((Object)tag);
        }
        nbt.func_218657_a("warpCorePositions", (INBT)list);
        list = new ListNBT();
        for (Map.Entry entry : this.dockingPoints.entrySet()) {
            tag = new CompoundNBT();
            HashedBlockPosition pos = (HashedBlockPosition)entry.getKey();
            String str = (String)entry.getValue();
            tag.func_74783_a("pos", new int[]{pos.x, pos.y, pos.z});
            tag.func_74778_a("id", str);
            list.add((Object)tag);
        }
        nbt.func_218657_a("dockingPositons", (INBT)list);
    }

    @Override
    public void readFromNbt(CompoundNBT nbt) {
        HashedBlockPosition pos;
        int[] posInt;
        CompoundNBT tag;
        int i;
        this.properties.readFromNBT(nbt);
        this.destinationDimId = new ResourceLocation(nbt.func_74779_i("destinationDimId"));
        this.isAnchored = nbt.func_74767_n("isAnchored");
        this.launchPosX = nbt.func_74762_e("launchposX");
        this.launchPosZ = nbt.func_74762_e("launchposY");
        this.posX = nbt.func_74762_e("posX");
        this.posZ = nbt.func_74762_e("posY");
        this.created = nbt.func_74767_n("created");
        this.altitude = nbt.func_74762_e("altitude");
        this.fuelAmount = nbt.func_74762_e("fuel");
        this.orbitalDistance = nbt.func_74760_g("orbitalDistance");
        this.targetOrbitalDistance = nbt.func_74762_e("targetOrbitalDistance");
        this.targetRotationsPerHour[0] = nbt.func_74762_e("targetRotationX");
        this.targetRotationsPerHour[1] = nbt.func_74762_e("targetRotationY");
        this.targetRotationsPerHour[2] = nbt.func_74762_e("targetRotationZ");
        this.targetGravity = nbt.func_74762_e("targetGravity");
        this.spawnLocation = new HashedBlockPosition(nbt.func_74762_e("spawnX"), nbt.func_74762_e("spawnY"), nbt.func_74762_e("spawnZ"));
        this.properties.setId(new ResourceLocation(nbt.func_74779_i("id")));
        this.rotation[0] = nbt.func_74769_h("rotationX");
        this.rotation[1] = nbt.func_74769_h("rotationY");
        this.rotation[2] = nbt.func_74769_h("rotationZ");
        this.angularVelocity[0] = nbt.func_74769_h("deltaRotationX");
        this.angularVelocity[1] = nbt.func_74769_h("deltaRotationY");
        this.angularVelocity[2] = nbt.func_74769_h("deltaRotationZ");
        ListNBT planetList = nbt.func_150295_c("knownPlanets", 8);
        for (int i2 = 0; i2 < planetList.size(); ++i2) {
            this.knownPlanetList.add(new ResourceLocation(planetList.func_150307_f(i2)));
        }
        if (nbt.func_74764_b("direction")) {
            this.direction = Direction.values()[nbt.func_74762_e("direction")];
        }
        if (nbt.func_74764_b("transitionEta")) {
            this.transitionEta = nbt.func_74763_f("transitionEta");
        }
        ListNBT list = nbt.func_150295_c("spawnPositions", 10);
        this.spawnLocations.clear();
        for (i = 0; i < list.size(); ++i) {
            tag = list.func_150305_b(i);
            posInt = tag.func_74759_k("pos");
            pos = new HashedBlockPosition(posInt[0], 0, posInt[1]);
            StationLandingLocation loc = new StationLandingLocation(pos, tag.func_74779_i("name"));
            this.spawnLocations.add(loc);
            loc.setOccupied(tag.func_74767_n("occupied"));
            loc.setAllowedForAutoLand(tag.func_74764_b("occupied") ? tag.func_74767_n("occupied") : true);
        }
        list = nbt.func_150295_c("warpCorePositions", 10);
        this.hasWarpCores = false;
        this.warpCoreLocation.clear();
        for (i = 0; i < list.size(); ++i) {
            tag = list.func_150305_b(i);
            posInt = tag.func_74759_k("pos");
            pos = new HashedBlockPosition(posInt[0], posInt[1], posInt[2]);
            this.warpCoreLocation.add(pos);
            this.hasWarpCores = true;
        }
        list = nbt.func_150295_c("dockingPositons", 10);
        this.dockingPoints.clear();
        for (i = 0; i < list.size(); ++i) {
            tag = list.func_150305_b(i);
            posInt = tag.func_74759_k("pos");
            pos = new HashedBlockPosition(posInt[0], posInt[1], posInt[2]);
            String str = tag.func_74779_i("id");
            this.dockingPoints.put(pos, str);
        }
    }

    @Override
    public boolean hasCustomSpawnLocation() {
        return false;
    }

    @Override
    public float getOrbitalDistance() {
        return this.orbitalDistance;
    }

    @Override
    public void setOrbitalDistance(float finalVel) {
        if (!this.isAnchored()) {
            this.orbitalDistance = Math.max(4.0f, finalVel);
        }
    }

    @Override
    public boolean isPlanetKnown(IDimensionProperties properties) {
        return (Boolean)ARConfiguration.getCurrentConfig().planetsMustBeDiscovered.get() == false || this.knownPlanetList.contains(properties.getId()) || DimensionManager.getInstance().knownPlanets.contains(properties.getId());
    }

    @Override
    public boolean isStarKnown(StellarBody body) {
        return true;
    }

    @Override
    public ResourceLocation getId() {
        return this.properties.getId();
    }
}

