/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileDrill
extends TileEntity
implements IModularInventory,
IToggleButton,
INetworkMachine {
    private float distanceExtended = 0.0f;
    private boolean extended;
    private ModuleToggleSwitch toggleSwitch;

    public TileDrill() {
        super(AdvancedRocketryTileEntityType.TILE_DRILL);
    }

    public float getDistanceExtended() {
        return this.distanceExtended;
    }

    public void setDistanceExtended(float distance) {
        this.distanceExtended = distance;
    }

    public boolean drillExtended() {
        return this.extended;
    }

    public void setDrillExtended(boolean value) {
        this.extended = value;
        this.distanceExtended = value ? 1.0f : 0.0f;
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        this.toggleSwitch = (ModuleToggleSwitch)new ModuleToggleSwitch(160, 5, "", (IToggleButton)this, TextureResources.buttonToggleImage, 11, 26, this.drillExtended()).setAdditionalData((Object)0);
        modules.add((ModuleBase)this.toggleSwitch);
        return modules;
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.drill";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void onInventoryButtonPressed(ModuleButton buttonId) {
        if (buttonId == this.toggleSwitch) {
            this.setDrillExtended(this.toggleSwitch.getState());
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        }
    }

    public void stateUpdated(ModuleBase module) {
        if (module == this.toggleSwitch) {
            this.setDrillExtended(this.toggleSwitch.getState());
        }
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        out.writeBoolean(this.extended);
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        nbt.func_74757_a("enabled", in.readBoolean());
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        this.setDrillExtended(nbt.func_74767_n("enabled"));
        this.toggleSwitch.setToggleState(this.drillExtended());
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 0), (ResourceLocation)ZUtils.getDimensionIdentifier((World)this.field_145850_b), (BlockPos)this.field_174879_c, (double)64.0);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("extendAmt", this.distanceExtended);
        nbt.func_74757_a("extended", this.extended);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.distanceExtended = nbt.func_74760_g("extendAmt");
        this.extended = nbt.func_74767_n("extended");
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

