/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.world.util.WorldDummy;
import zmaster587.libVulpes.tile.multiblock.hatch.TileFluidHatch;

public class TileFluidTank
extends TileFluidHatch {
    private long lastUpdateTime;
    private static final int MAX_UPDATE = 5;
    private boolean fluidChanged = false;

    public TileFluidTank() {
        super(AdvancedRocketryTileEntityType.TILE_FLUID_TANK);
    }

    public TileFluidTank(int i) {
        super(AdvancedRocketryTileEntityType.TILE_FLUID_TANK, i);
    }

    private void checkForUpdate() {
        if (this.fluidChanged && this.field_145850_b instanceof WorldDummy || this.field_145850_b.func_82737_E() - this.lastUpdateTime > 5L) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.lastUpdateTime = this.field_145850_b.func_82737_E();
            this.fluidChanged = false;
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (resource == null || resource.isEmpty()) {
            return 0;
        }
        TileFluidTank handler2 = this.getFluidTankInDirection(Direction.UP);
        if (handler2 != null && handler2.canFill(resource)) {
            return handler2.fill(resource, doFill);
        }
        return this.fillInternal2(resource, doFill);
    }

    private int fillInternal2(FluidStack resource, IFluidHandler.FluidAction doFill) {
        TileFluidTank handler = this.getFluidTankInDirection(Direction.DOWN);
        int amt = 0;
        if (handler != null) {
            amt = handler.fillInternal2(resource, doFill);
        }
        FluidStack resource2 = resource.copy();
        resource2.setAmount(resource2.getAmount() - amt);
        if (resource2.getAmount() > 0) {
            amt += super.fill(resource2, doFill);
        }
        if (amt > 0 && doFill.execute()) {
            this.fluidChanged = true;
        }
        this.checkForUpdate();
        return amt;
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.pressurizedtank";
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        TileFluidTank handler = this.getFluidTankInDirection(Direction.UP);
        FluidStack stack = null;
        if (handler != null && handler.getFluidInTank(0) != null && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == handler.getFluidInTank(0).getFluid()) {
            stack = handler.drain(maxDrain, doDrain);
        }
        if (stack != null) {
            return stack;
        }
        FluidStack stack2 = super.drain(maxDrain - (stack != null ? stack.getAmount() : 0), doDrain);
        if (stack != null && stack2 != null) {
            stack2.setAmount(stack2.getAmount() + stack.getAmount());
        }
        if (stack2 != null && doDrain.execute()) {
            this.fluidChanged = true;
        }
        this.checkForUpdate();
        return stack2;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        if (this.fluidTank.getFluid().isEmpty() || resource.getFluid() != this.fluidTank.getFluid().getFluid()) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), doDrain);
    }

    public TileFluidTank getFluidTankInDirection(Direction direction) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
        if (tile instanceof TileFluidTank) {
            return (TileFluidTank)tile;
        }
        return null;
    }

    private boolean canFill(FluidStack stack) {
        FluidStack stack2 = this.fluidTank.getFluid();
        return stack2.isEmpty() || stack2.getFluid() == stack.getFluid();
    }

    protected CompoundNBT writeToNBTHelper(CompoundNBT nbtTagCompound) {
        super.writeToNBTHelper(nbtTagCompound);
        this.fluidTank.writeToNBT(nbtTagCompound);
        return nbtTagCompound;
    }

    protected void readFromNBTHelper(CompoundNBT nbtTagCompound) {
        super.readFromNBTHelper(nbtTagCompound);
        this.fluidTank.readFromNBT(nbtTagCompound);
    }

    protected boolean useBucket(int slot, ItemStack stack) {
        FluidStack othertank;
        TileFluidTank handler;
        boolean bucketUsed = super.useBucket(slot, stack);
        if (bucketUsed && (handler = this.getFluidTankInDirection(Direction.DOWN)) != null && ((othertank = handler.getFluidInTank(0)) == null || othertank.getAmount() < handler.getTankCapacity(0))) {
            this.fluidTank.drain(handler.fill(this.fluidTank.getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
        return bucketUsed;
    }

    public void onAdjacentBlockUpdated(Direction dir) {
        if (dir != Direction.DOWN) {
            return;
        }
        TileFluidTank tank = this.getFluidTankInDirection(Direction.UP);
        if (tank != null && tank.getFluidInTank(0) != null) {
            if (this.fluidTank.getFluid().isEmpty()) {
                this.fluidTank.fill(tank.fluidTank.drain(this.fluidTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            } else if (tank.getFluidInTank(0).getFluid() == this.fluidTank.getFluid().getFluid()) {
                this.fluidTank.fill(tank.drain(this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                tank.fluidTank.drain(this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
            this.func_70296_d();
        }
    }
}

