/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.libVulpes.api.LibVulpesItems;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInventoryHatch;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class TileGuidanceComputer
extends TileInventoryHatch
implements IModularInventory {
    ResourceLocation destinationId;
    Vector3F<Float> landingPos;
    Map<ResourceLocation, HashedBlockPosition> landingLoc;

    public TileGuidanceComputer() {
        super(AdvancedRocketryTileEntityType.TILE_GUIDANCE_COMPUTER, 1);
        this.inventory.setCanInsertSlot(0, true);
        this.inventory.setCanExtractSlot(0, true);
        this.landingPos = new Vector3F((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        this.destinationId = Constants.INVALID_PLANET;
        this.landingLoc = new HashMap<ResourceLocation, HashedBlockPosition>();
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        return modules;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void setLandingLocation(ResourceLocation stationId, StationLandingLocation loc) {
        if (loc == null) {
            this.landingLoc.remove(stationId);
        } else {
            this.landingLoc.put(stationId, loc.getPos());
        }
    }

    public StationLandingLocation getLandingLocation(ResourceLocation stationId) {
        ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStation(stationId);
        if (obj == null) {
            this.landingLoc.remove(stationId);
            return null;
        }
        HashedBlockPosition myLoc = this.landingLoc.get(stationId);
        if (myLoc == null) {
            return null;
        }
        return ((SpaceStationObject)obj).getPadAtLocation(myLoc);
    }

    public long getTargetSatellite() {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            return ((ItemSatelliteIdentificationChip)stack.func_77973_b()).getSatelliteId(stack);
        }
        return -1L;
    }

    public ResourceLocation getDestinationDimId(ResourceLocation currentDimension, BlockPos pos) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b()) {
            Item itemType = stack.func_77973_b();
            if (itemType instanceof ItemPlanetIdentificationChip) {
                ItemPlanetIdentificationChip item = (ItemPlanetIdentificationChip)itemType;
                return item.getDimensionId(stack);
            }
            if (itemType instanceof ItemStationChip) {
                if (ARConfiguration.GetSpaceDimId().equals((Object)currentDimension)) {
                    ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
                    if (object != null) {
                        if (ItemStationChip.getUUID(stack).equals((Object)object.getId())) {
                            return object.getOrbitingPlanetId();
                        }
                    } else {
                        return Constants.INVALID_PLANET;
                    }
                }
                return ARConfiguration.GetSpaceDimId();
            }
            if (itemType instanceof ItemAsteroidChip) {
                this.destinationId = currentDimension;
                this.landingPos = new Vector3F((Object)Float.valueOf(pos.func_177958_n()), (Object)Float.valueOf(pos.func_177956_o()), (Object)Float.valueOf(pos.func_177952_p()));
                return currentDimension;
            }
            if (itemType instanceof ItemSatelliteIdentificationChip) {
                SatelliteBase sat;
                long l = this.getTargetSatellite();
                if (l != -1L && (sat = DimensionManager.getInstance().getSatellite(l)) != null) {
                    return sat.getDimensionId().get();
                }
            } else if (stack.func_77973_b() == LibVulpesItems.itemLinker && ItemLinker.getDimId((ItemStack)stack) != Constants.INVALID_PLANET) {
                return ItemLinker.getDimId((ItemStack)stack);
            }
        }
        return this.destinationId;
    }

    public Vector3F<Float> getLandingLocation(ResourceLocation landingDimension, boolean commit) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b()) {
            Item itemType = stack.func_77973_b();
            if (itemType instanceof ItemPlanetIdentificationChip) {
                return null;
            }
            if (itemType instanceof ItemStationChip) {
                ItemStationChip chip = (ItemStationChip)stack.func_77973_b();
                if (ARConfiguration.GetSpaceDimId().equals((Object)landingDimension)) {
                    ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(stack));
                    return this.getStationLocation(object, commit);
                }
                ItemStationChip.LandingLocation loc = chip.getTakeoffCoords(stack, landingDimension);
                if (loc != null) {
                    return loc.location;
                }
                return null;
            }
            if (itemType instanceof ItemAsteroidChip) {
                return this.landingPos;
            }
            if (itemType instanceof ItemSatelliteIdentificationChip) {
                return null;
            }
            if (stack.func_77973_b() == LibVulpesItems.itemLinker && ItemLinker.getDimId((ItemStack)stack) != Constants.INVALID_PLANET) {
                BlockPos landingBlock = ItemLinker.getMasterCoords((ItemStack)stack);
                return new Vector3F((Object)Float.valueOf((float)landingBlock.func_177958_n() + 0.5f), (Object)Float.valueOf(((Integer)ARConfiguration.getCurrentConfig().orbit.get()).intValue()), (Object)Float.valueOf((float)landingBlock.func_177952_p() + 0.5f));
            }
        } else if (stack.func_190926_b() && !Constants.INVALID_PLANET.equals((Object)this.destinationId)) {
            return this.landingPos;
        }
        return null;
    }

    private Vector3F<Float> getStationLocation(ISpaceObject object, boolean commit) {
        HashedBlockPosition vec = null;
        if (object instanceof SpaceStationObject) {
            if (this.landingLoc.get(object.getId()) != null) {
                vec = this.landingLoc.get(object.getId());
                if (commit) {
                    ((SpaceStationObject)object).getPadAtLocation(this.landingLoc.get(object.getId())).setOccupied(true);
                }
            } else {
                vec = ((SpaceStationObject)object).getNextLandingPad(commit);
            }
        }
        if (object == null) {
            return null;
        }
        if (vec == null) {
            vec = object.getSpawnLocation();
        }
        return new Vector3F((Object)new Float(vec.x), (Object)new Float(vec.y), (Object)new Float(vec.z));
    }

    public void overrideLandingStation(ISpaceObject object) {
        this.setFallbackDestination(ARConfiguration.GetSpaceDimId(), this.getStationLocation(object, true));
    }

    public String getDestinationName(ResourceLocation landingDimension) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStationChip) {
            ItemStationChip.LandingLocation loc;
            ItemStationChip chip = (ItemStationChip)stack.func_77973_b();
            if (!ARConfiguration.GetSpaceDimId().equals((Object)landingDimension) && (loc = chip.getTakeoffCoords(stack, landingDimension)) != null) {
                return loc.name;
            }
        }
        return "";
    }

    public void setFallbackDestination(ResourceLocation dimID, Vector3F<Float> coords) {
        this.destinationId = dimID;
        this.landingPos = coords;
    }

    public int getLaunchSequence(ResourceLocation currentDimensionID, BlockPos currentPosition) {
        int totalBurn = currentDimensionID.func_110623_a().equals(ARConfiguration.getCurrentConfig().spaceDimId.get()) ? ((Integer)ARConfiguration.getCurrentConfig().stationClearanceHeight.get()).intValue() : ((Integer)ARConfiguration.getCurrentConfig().orbit.get()).intValue();
        ResourceLocation destinationDimensionID = this.getDestinationDimId(currentDimensionID, currentPosition);
        return totalBurn += currentDimensionID.func_110623_a().equals(ARConfiguration.getCurrentConfig().spaceDimId.get()) ? this.getTransBodyInjection(currentDimensionID, destinationDimensionID, currentPosition) : this.getTransBodyInjection(currentDimensionID, destinationDimensionID);
    }

    public int getTransBodyInjection(ResourceLocation currentDimensionID, ResourceLocation destinationDimensionID) {
        ISpaceObject destinationSpaceStation = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(this.func_70301_a(0)));
        ResourceLocation resourceLocation = destinationDimensionID = destinationDimensionID.func_110623_a().equals(ARConfiguration.getCurrentConfig().spaceDimId.get()) && destinationSpaceStation != null ? destinationSpaceStation.getOrbitingPlanetId() : destinationDimensionID;
        if (destinationDimensionID == Constants.INVALID_PLANET) {
            return 0;
        }
        return PlanetaryTravelHelper.isTravelWithinOrbit(currentDimensionID, destinationDimensionID) && !this.isAsteroidMission() ? 0 : PlanetaryTravelHelper.getTransbodyInjectionBurn(currentDimensionID, destinationDimensionID, this.isAsteroidMission());
    }

    public int getTransBodyInjection(ResourceLocation currentDimensionID, ResourceLocation destinationDimensionID, BlockPos currentPosition) {
        ISpaceObject currentSpaceStation = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(currentPosition);
        ISpaceObject destinationSpaceStation = SpaceObjectManager.getSpaceManager().getSpaceStation(ItemStationChip.getUUID(this.func_70301_a(0)));
        ResourceLocation resourceLocation = destinationDimensionID = destinationDimensionID.func_110623_a().equals(ARConfiguration.getCurrentConfig().spaceDimId.get()) && destinationSpaceStation != null ? destinationSpaceStation.getOrbitingPlanetId() : destinationDimensionID;
        if (destinationDimensionID == Constants.INVALID_PLANET) {
            return 0;
        }
        return PlanetaryTravelHelper.isTravelWithinOrbit(currentSpaceStation.getOrbitingPlanetId(), destinationDimensionID) && !this.isAsteroidMission() ? 0 : PlanetaryTravelHelper.getTransbodyInjectionBurn(currentSpaceStation.getOrbitingPlanetId(), destinationDimensionID, this.isAsteroidMission());
    }

    public boolean isAsteroidMission() {
        return this.func_70301_a(0).func_77973_b() instanceof ItemAsteroidChip;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.destinationId != null) {
            nbt.func_74778_a("destDimId", this.destinationId.toString());
        }
        nbt.func_74776_a("landingx", ((Float)this.landingPos.x).floatValue());
        nbt.func_74776_a("landingy", ((Float)this.landingPos.y).floatValue());
        nbt.func_74776_a("landingz", ((Float)this.landingPos.z).floatValue());
        ListNBT stationList = new ListNBT();
        for (ResourceLocation locationID : this.landingLoc.keySet()) {
            CompoundNBT tag = new CompoundNBT();
            HashedBlockPosition loc = this.landingLoc.get(locationID);
            tag.func_74783_a("pos", new int[]{loc.x, loc.y, loc.z});
            tag.func_74778_a("id", locationID.toString());
            stationList.add((Object)tag);
        }
        nbt.func_218657_a("stationMapping", (INBT)stationList);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.destinationId = nbt.func_74764_b("destDimId") ? new ResourceLocation(nbt.func_74779_i("destDimId")) : Constants.INVALID_PLANET;
        this.landingPos.x = Float.valueOf(nbt.func_74760_g("landingx"));
        this.landingPos.y = Float.valueOf(nbt.func_74760_g("landingy"));
        this.landingPos.z = Float.valueOf(nbt.func_74760_g("landingz"));
        ListNBT stationList = nbt.func_150295_c("stationMapping", 10);
        for (int i = 0; i < stationList.size(); ++i) {
            CompoundNBT tag = stationList.func_150305_b(i);
            int[] pos = tag.func_74759_k("pos");
            ResourceLocation id = new ResourceLocation(tag.func_74779_i("id"));
            this.landingLoc.put(id, new HashedBlockPosition(pos[0], pos[1], pos[2]));
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!stack.func_190926_b()) {
            this.destinationId = Constants.INVALID_PLANET;
        }
    }

    public void setReturnPosition(Vector3F<Float> pos, ResourceLocation dimId) {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemStationChip) {
            ItemStationChip item = (ItemStationChip)stack.func_77973_b();
            item.setTakeoffCoords(stack, pos, dimId, 0);
        }
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.guidancecomputer";
    }
}

