/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.network.PacketFluidParticle;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.cap.FluidCapability;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleLiquidIndicator;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.tile.TileEntityRFConsumer;
import zmaster587.libVulpes.util.ZUtils;

public class TilePump
extends TileEntityRFConsumer
implements IFluidHandler,
IModularInventory {
    private FluidTank tank = new FluidTank(16000);
    private List<BlockPos> cache = new LinkedList<BlockPos>();
    private final int RANGE = 64;

    public TilePump() {
        super(AdvancedRocketryTileEntityType.TILE_PUMP, 1000);
    }

    public int getPowerPerOperation() {
        return 100;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new FluidCapability((IFluidHandler)this)).cast();
        }
        return super.getCapability(capability);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && !this.tank.getFluid().isEmpty()) {
            for (Direction direction : Direction.values()) {
                BlockPos newBlock = this.func_174877_v().func_177972_a(direction);
                TileEntity tile = this.field_145850_b.func_175625_s(newBlock);
                if (tile == null || !tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent()) continue;
                IFluidHandler cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d()).orElse(null);
                FluidStack stack = this.tank.getFluid().copy();
                stack.setAmount(Math.min(this.tank.getFluid().getAmount(), 1000));
                cap.fill(this.tank.drain(cap.fill(stack, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                if (this.tank.getFluid().isEmpty()) break;
            }
        }
    }

    private int getFrequencyFromPower() {
        float ratio = (float)this.energy.getUniversalEnergyStored() / (float)this.energy.getMaxEnergyStored();
        if ((double)ratio > 0.5) {
            return 1;
        }
        return 10;
    }

    public void performFunction() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getCapacity() - 1000 < this.tank.getFluidAmount()) {
                return;
            }
            BlockPos nextPos = this.getNextBlockLocation();
            if (nextPos != null && this.canFitFluid(nextPos)) {
                BlockState state = this.field_145850_b.func_180495_p(nextPos);
                Block worldBlock = state.func_177230_c();
                Material mat = this.field_145850_b.func_180495_p(nextPos).func_185904_a();
                if (worldBlock instanceof FlowingFluidBlock) {
                    Fluid stack = ((FlowingFluidBlock)worldBlock).func_204508_a((IWorld)this.field_145850_b, nextPos, state);
                    if (stack != null) {
                        this.tank.fill(new FluidStack(stack, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                    int colour = ((FlowingFluidBlock)worldBlock).getFluid().getAttributes().getColor();
                    if (mat == Material.field_151587_i) {
                        colour = -4376808;
                    }
                    PacketHandler.sendToNearby((BasePacket)new PacketFluidParticle(nextPos, this.field_174879_c, 200, colour), (ResourceLocation)ZUtils.getDimensionIdentifier((World)this.field_145850_b), (BlockPos)this.field_174879_c, (double)128.0);
                }
            }
        }
    }

    private boolean canFitFluid(BlockPos pos) {
        Block worldBlock = this.field_145850_b.func_180495_p(pos).func_177230_c();
        return worldBlock instanceof FlowingFluidBlock && (this.tank.getFluid().isEmpty() || this.tank.getFluid().getFluid() == ((FlowingFluidBlock)worldBlock).getFluid());
    }

    private BlockPos getNextBlockLocation() {
        if (!this.cache.isEmpty()) {
            return this.cache.remove(0);
        }
        BlockPos currentPos = new BlockPos((Vector3i)this.func_174877_v().func_177977_b());
        while (this.field_145850_b.func_175623_d(currentPos)) {
            currentPos = currentPos.func_177977_b();
        }
        Block worldBlock = this.field_145850_b.func_180495_p(currentPos).func_177230_c();
        if (this.canFitFluid(currentPos)) {
            this.findFluidAtOrAbove(currentPos, (Fluid)((FlowingFluidBlock)worldBlock).getFluid());
        }
        if (!this.cache.isEmpty()) {
            return this.cache.remove(0);
        }
        return null;
    }

    private List<BlockPos> findFluidAtOrAbove(BlockPos pos, Fluid fluid) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(pos);
        while (!queue.isEmpty()) {
            BlockState state;
            Block worldBlock;
            BlockPos nextElement = (BlockPos)queue.poll();
            if (visited.contains(nextElement) || !nextElement.func_218141_a(new Vector3i(pos.func_177958_n(), nextElement.func_177956_o(), pos.func_177952_p()), 64.0) || !((worldBlock = (state = this.field_145850_b.func_180495_p(nextElement)).func_177230_c()) instanceof FlowingFluidBlock) || !fluid.func_207187_a(Fluids.field_204541_a) && !((FlowingFluidBlock)worldBlock).getFluid().func_207187_a(fluid)) continue;
            if (((FlowingFluidBlock)worldBlock).func_204507_t(state).func_206889_d()) {
                this.cache.add(0, nextElement);
            }
            visited.add(nextElement);
            queue.add(nextElement.func_177976_e());
            queue.add(nextElement.func_177974_f());
            queue.add(nextElement.func_177978_c());
            queue.add(nextElement.func_177968_d());
            queue.add(nextElement.func_177984_a());
        }
        return this.cache;
    }

    public boolean canPerformFunction() {
        return this.tank.getFluidAmount() <= this.tank.getCapacity() && AdvancedRocketry.proxy.getWorldTimeUniversal() % (long)this.getFrequencyFromPower() == 0L;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModuleLiquidIndicator(27, 18, (IFluidHandler)this));
        return modules;
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.blockpump";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }

    public int getTanks() {
        return this.tank.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.tank.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(tank, stack);
    }
}

