/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.tile.TileInventoriedForgePowerMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileSolarPanel
extends TileInventoriedForgePowerMachine {
    ModuleText text = new ModuleText(60, 40, LibVulpes.proxy.getLocalizedString("msg.solar.collectingenergy"), 0x2F2F2F);

    public TileSolarPanel() {
        super(AdvancedRocketryTileEntityType.TILE_SOLAR_PANEL, 10000, 1);
    }

    public boolean canGeneratePower() {
        return this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) && this.field_145850_b.func_72935_r();
    }

    public void func_73660_a() {
        if (this.canGeneratePower()) {
            if (this.field_145850_b.field_72995_K) {
                this.text.setText(LibVulpes.proxy.getLocalizedString("msg.solar.collectingenergy") + "\n" + this.getPowerPerOperation() + " " + LibVulpes.proxy.getLocalizedString("msg.powerunit.rfpertick"));
            }
            if (this.hasEnoughEnergyBuffer(this.getPowerPerOperation())) {
                if (!this.field_145850_b.field_72995_K) {
                    this.energy.acceptEnergy(this.getPowerPerOperation(), false);
                }
                this.onGeneratePower();
            } else {
                this.notEnoughBufferForFunction();
            }
        } else if (this.field_145850_b.field_72995_K) {
            this.text.setText(LibVulpes.proxy.getLocalizedString("msg.solar.cannotcollectenergy"));
        }
        if (!this.field_145850_b.field_72995_K) {
            this.transmitPower();
        }
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        modules.add(this.text);
        return modules;
    }

    public int getPowerPerOperation() {
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b);
        double insolationMultiplier = ZUtils.getDimensionIdentifier((World)this.field_145850_b).equals(ARConfiguration.getCurrentConfig().spaceDimId.get()) ? SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c).getInsolationMultiplier() : properties.getPeakInsolationMultiplier();
        return (int)Math.min(2.001 * (double)((Integer)ARConfiguration.getCurrentConfig().solarGeneratorMult.get()).intValue() * insolationMultiplier, 10000.0);
    }

    public void onGeneratePower() {
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.solargenerator";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }
}

