/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.IFuelTank;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IIntake;
import zmaster587.advancedRocketry.api.IRocketEngine;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.block.BlockAdvancedBipropellantRocketMotor;
import zmaster587.advancedRocketry.block.BlockAdvancedRocketMotor;
import zmaster587.advancedRocketry.block.BlockBipropellantFuelTank;
import zmaster587.advancedRocketry.block.BlockBipropellantRocketMotor;
import zmaster587.advancedRocketry.block.BlockFuelTank;
import zmaster587.advancedRocketry.block.BlockOxidizerFuelTank;
import zmaster587.advancedRocketry.block.BlockRocketMotor;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityStationDeployedRocket;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.TileRocketAssemblingMachine;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.block.BlockFullyRotatable;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.ZUtils;

public class TileUnmannedVehicleAssembler
extends TileRocketAssemblingMachine {
    private static final int MAX_SIZE = 17;
    private static final int MAX_SIZE_Y = 17;
    private static final int MIN_SIZE = 3;
    private static final int MIN_SIZE_Y = 3;

    public TileUnmannedVehicleAssembler() {
        super(AdvancedRocketryTileEntityType.TILE_STATION_DEPLOYED_ASSEMBLER);
    }

    @Override
    public AxisAlignedBB getRocketPadBounds(World world, BlockPos pos2) {
        int zSize;
        int xSize;
        int zMin;
        int xMin;
        Direction direction = RotatableBlock.getFront((BlockState)world.func_180495_p(pos2)).func_176734_d();
        int yCurrent = pos2.func_177956_o();
        int xCurrent = pos2.func_177958_n();
        int zCurrent = pos2.func_177952_p();
        int xMax = xMin = xCurrent;
        int zMax = zMin = zCurrent;
        int yMax = ZUtils.getContinuousBlockLength((World)world, (Direction)Direction.UP, (BlockPos)this.func_174877_v().func_177982_a(0, 1, 0), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
        if (direction.func_82601_c() != 0) {
            xSize = ZUtils.getContinuousBlockLength((World)world, (Direction)direction, (BlockPos)pos2.func_177982_a(0, yMax, 0), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
            zMin = ZUtils.getContinuousBlockLength((World)world, (Direction)Direction.NORTH, (BlockPos)pos2.func_177982_a(0, 0, -1), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower) + 1;
            zMax = ZUtils.getContinuousBlockLength((World)world, (Direction)Direction.SOUTH, (BlockPos)pos2.func_177982_a(0, 0, 1), (int)(17 - zMin), (Block)AdvancedRocketryBlocks.blockStructureTower);
            zSize = zMin + zMax;
            zMin = zCurrent - zMin + 1;
            zMax = zCurrent + zMax;
            if (direction.func_82601_c() > 0) {
                xMax = xCurrent + xSize - 1;
                ++xMin;
            }
            if (direction.func_82601_c() < 0) {
                xMin = xCurrent - xSize + 1;
                --xMax;
            }
        } else {
            zSize = ZUtils.getContinuousBlockLength((World)world, (Direction)direction, (BlockPos)pos2.func_177982_a(0, yMax, 0), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
            xMin = ZUtils.getContinuousBlockLength((World)world, (Direction)Direction.WEST, (BlockPos)pos2.func_177982_a(-1, 0, 0), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower) + 1;
            xMax = ZUtils.getContinuousBlockLength((World)world, (Direction)Direction.EAST, (BlockPos)pos2.func_177982_a(1, 0, 0), (int)(17 - xMin), (Block)AdvancedRocketryBlocks.blockStructureTower);
            xSize = xMin + xMax;
            xMin = xCurrent - xMin + 1;
            xMax = xCurrent + xMax;
            if (direction.func_82599_e() > 0) {
                zMax = zCurrent + zSize - 1;
                ++zMin;
            }
            if (direction.func_82599_e() < 0) {
                zMin = zCurrent - zSize + 1;
                --zMax;
            }
        }
        if (yMax < 3 || xSize < 3 || zSize < 3) {
            return null;
        }
        return new AxisAlignedBB((double)xMin, (double)yCurrent, (double)zMin, (double)xMax, (double)(yCurrent + yMax - 1), (double)zMax);
    }

    @Override
    public void assembleRocket() {
        StorageChunk storageChunk;
        if (this.bbCache == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.scanRocket(this.field_145850_b, this.func_174877_v(), this.bbCache);
        if (this.status != TileRocketAssemblingMachine.ErrorCodes.SUCCESS) {
            return;
        }
        try {
            storageChunk = StorageChunk.cutWorldBB(this.field_145850_b, this.bbCache);
        }
        catch (NegativeArraySizeException e) {
            return;
        }
        EntityStationDeployedRocket rocket = new EntityStationDeployedRocket(this.field_145850_b, storageChunk, this.stats.copy(), this.bbCache.field_72340_a + (this.bbCache.field_72336_d - this.bbCache.field_72340_a) / 2.0 + 0.5, this.func_174877_v().func_177956_o(), this.bbCache.field_72339_c + (this.bbCache.field_72334_f - this.bbCache.field_72339_c) / 2.0 + 0.5);
        rocket.forwardDirection = RotatableBlock.getFront((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v())).func_176734_d();
        rocket.launchDirection = Direction.DOWN;
        for (int x = 0; x < storageChunk.getSizeX(); ++x) {
            for (int y = 0; y < storageChunk.getSizeY(); ++y) {
                for (int z = 0; z < storageChunk.getSizeZ(); ++z) {
                    BlockPos pos3 = new BlockPos(x, y, z);
                    if (!(storageChunk.func_180495_p(pos3).func_177230_c() instanceof BlockRocketMotor)) continue;
                    storageChunk.setBlockState(pos3, (BlockState)storageChunk.func_180495_p(pos3).func_206870_a((Property)BlockFullyRotatable.FACING, (Comparable)rocket.forwardDirection));
                }
            }
        }
        this.field_145850_b.func_217376_c((Entity)rocket);
        CompoundNBT nbtdata = new CompoundNBT();
        rocket.func_184198_c(nbtdata);
        PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)rocket, 0, nbtdata), (World)rocket.field_70170_p, (BlockPos)this.field_174879_c, (double)64.0);
        this.stats.reset();
        this.status = TileRocketAssemblingMachine.ErrorCodes.UNSCANNED;
        this.func_70296_d();
        for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
            rocket.linkInfrastructure(infrastructure);
        }
    }

    @Override
    public void scanRocket(World world, BlockPos pos2, AxisAlignedBB bb) {
        int thrustMonopropellant = 0;
        int thrustBipropellant = 0;
        int monopropellantfuelUse = 0;
        int bipropellantfuelUse = 0;
        int fuelCapacityMonopropellant = 0;
        int fuelCapacityBipropellant = 0;
        int fuelCapacityOxidizer = 0;
        int numBlocks = 0;
        float drillPower = 0.0f;
        this.stats.reset();
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int xCurr = (int)bb.field_72340_a;
        while ((double)xCurr <= bb.field_72336_d) {
            int zCurr = (int)bb.field_72339_c;
            while ((double)zCurr <= bb.field_72334_f) {
                int yCurr = (int)bb.field_72338_b;
                while ((double)yCurr <= bb.field_72337_e) {
                    BlockPos currPos = new BlockPos(xCurr, yCurr, zCurr);
                    if (!world.func_175623_d(currPos)) {
                        if (xCurr < actualMinX) {
                            actualMinX = xCurr;
                        }
                        if (yCurr < actualMinY) {
                            actualMinY = yCurr;
                        }
                        if (zCurr < actualMinZ) {
                            actualMinZ = zCurr;
                        }
                        if (xCurr > actualMaxX) {
                            actualMaxX = xCurr;
                        }
                        if (yCurr > actualMaxY) {
                            actualMaxY = yCurr;
                        }
                        if (zCurr > actualMaxZ) {
                            actualMaxZ = zCurr;
                        }
                    }
                    ++yCurr;
                }
                ++zCurr;
            }
            ++xCurr;
        }
        boolean hasSatellite = false;
        boolean hasGuidance = false;
        int fluidCapacity = 0;
        if (this.verifyScan(bb, world)) {
            int yCurr = (int)bb.field_72338_b;
            while ((double)yCurr <= bb.field_72337_e) {
                int xCurr2 = (int)bb.field_72340_a;
                while ((double)xCurr2 <= bb.field_72336_d) {
                    int zCurr = (int)bb.field_72339_c;
                    while ((double)zCurr <= bb.field_72334_f) {
                        BlockPos currPos = new BlockPos(xCurr2, yCurr, zCurr);
                        BlockPos belowPos = new BlockPos(xCurr2, yCurr - 1, zCurr);
                        if (!world.func_175623_d(currPos)) {
                            TileEntity tile;
                            BlockState state = world.func_180495_p(currPos);
                            Block block = state.func_177230_c();
                            ++numBlocks;
                            if (block instanceof IRocketEngine) {
                                if (block instanceof BlockBipropellantRocketMotor || block instanceof BlockAdvancedBipropellantRocketMotor) {
                                    bipropellantfuelUse += ((IRocketEngine)block).getFuelConsumptionRate(world, xCurr2, yCurr, zCurr);
                                    thrustBipropellant += ((IRocketEngine)block).getThrust(world, currPos);
                                } else if (block instanceof BlockRocketMotor || block instanceof BlockAdvancedRocketMotor) {
                                    monopropellantfuelUse += ((IRocketEngine)block).getFuelConsumptionRate(world, xCurr2, yCurr, zCurr);
                                    thrustMonopropellant += ((IRocketEngine)block).getThrust(world, currPos);
                                }
                                this.stats.addEngineLocation((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f, yCurr - actualMinY, (float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f);
                            }
                            if (block instanceof IFuelTank) {
                                if (block instanceof BlockFuelTank) {
                                    fuelCapacityMonopropellant = (int)((double)fuelCapacityMonopropellant + (double)((IFuelTank)block).getMaxFill(world, currPos, state) * (Double)ARConfiguration.getCurrentConfig().fuelCapacityMultiplier.get());
                                } else if (block instanceof BlockBipropellantFuelTank) {
                                    fuelCapacityBipropellant = (int)((double)fuelCapacityBipropellant + (double)((IFuelTank)block).getMaxFill(world, currPos, state) * (Double)ARConfiguration.getCurrentConfig().fuelCapacityMultiplier.get());
                                } else if (block instanceof BlockOxidizerFuelTank) {
                                    fuelCapacityOxidizer = (int)((double)fuelCapacityOxidizer + (double)((IFuelTank)block).getMaxFill(world, currPos, state) * (Double)ARConfiguration.getCurrentConfig().fuelCapacityMultiplier.get());
                                }
                            }
                            if (block instanceof IIntake) {
                                this.stats.setStatTag("intakePower", (Integer)this.stats.getStatTag("intakePower") + ((IIntake)block).getIntakeAmt(state));
                            }
                            if ((tile = world.func_175625_s(currPos)) instanceof TileSatelliteHatch) {
                                hasSatellite = true;
                            }
                            if (tile instanceof TileGuidanceComputer) {
                                hasGuidance = true;
                            }
                            if (tile instanceof IFluidHandler) {
                                for (int i = 0; i < ((IFluidHandler)tile).getTanks(); ++i) {
                                    fluidCapacity += ((IFluidHandler)tile).getTankCapacity(i);
                                }
                            }
                        }
                        ++zCurr;
                    }
                    ++xCurr2;
                }
                ++yCurr;
            }
            if (thrustBipropellant >= thrustMonopropellant) {
                this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, 0.0f);
                this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, bipropellantfuelUse);
                this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER, bipropellantfuelUse);
                this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, 0);
                this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fuelCapacityBipropellant);
                this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_OXIDIZER, fuelCapacityOxidizer);
            } else {
                this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, monopropellantfuelUse);
                this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, 0.0f);
                this.stats.setBaseFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER, 0.0f);
                this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fuelCapacityMonopropellant);
                this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, 0);
                this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID_OXIDIZER, 0);
            }
            this.stats.setThrust(Math.max(thrustMonopropellant, thrustBipropellant));
            this.stats.setWeight(numBlocks);
            this.stats.setDrillingPower(drillPower);
            this.stats.setStatTag("liquidCapacity", fluidCapacity);
            this.status = (float)this.getThrust() < this.getNeededThrust() ? TileRocketAssemblingMachine.ErrorCodes.NOENGINES : (thrustBipropellant >= thrustMonopropellant && (float)this.getFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT) < this.getNeededFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT) * (float)(1 + fluidCapacity / 1000) || thrustMonopropellant >= thrustBipropellant && (float)this.getFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) < this.getNeededFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) * (float)(1 + fluidCapacity / 1000) ? TileRocketAssemblingMachine.ErrorCodes.NOFUEL : TileRocketAssemblingMachine.ErrorCodes.SUCCESS);
        }
    }

    @Override
    public float getNeededFuel(FuelRegistry.FuelType fuelType) {
        return this.getAcceleration(DimensionManager.getInstance().getDimensionProperties(this.field_145850_b).getGravitationalMultiplier()) > 0.0f ? (float)this.stats.getFuelRate(fuelType) : 0.0f;
    }

    @Override
    protected boolean verifyScan(AxisAlignedBB bb, World world) {
        return true;
    }
}

