/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.atmosphere;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.block.BlockRedstoneEmitter;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileAtmosphereDetector
extends TileEntity
implements ITickableTileEntity,
IModularInventory,
IButtonInventory,
INetworkMachine {
    IAtmosphere atmosphereToDetect = AtmosphereType.AIR;

    public TileAtmosphereDetector() {
        super(AdvancedRocketryTileEntityType.TILE_ATM_DETECTOR);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_73046_m().func_211150_az() % 10L == 0L) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean detectedAtm = false;
            if (AtmosphereHandler.getOxygenHandler(ZUtils.getDimensionIdentifier((World)this.field_145850_b)) == null) {
                detectedAtm = this.atmosphereToDetect == AtmosphereType.AIR;
            } else {
                for (Direction direction : Direction.values()) {
                    boolean bl = detectedAtm = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)).func_196954_c((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(direction)) != VoxelShapes.func_197868_b() && this.atmosphereToDetect == AtmosphereHandler.getOxygenHandler(this.field_145850_b).getAtmosphereType(this.field_174879_c.func_177972_a(direction));
                    if (detectedAtm) break;
                }
            }
            if (((BlockRedstoneEmitter)state.func_177230_c()).getState(this.field_145850_b, state, this.field_174879_c) != detectedAtm) {
                ((BlockRedstoneEmitter)state.func_177230_c()).setState(this.field_145850_b, state, this.field_174879_c, detectedAtm);
            }
        }
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        LinkedList<ModuleButton> btns = new LinkedList<ModuleButton>();
        Iterator<IAtmosphere> atmIter = AtmosphereRegister.getInstance().getAtmosphereList().iterator();
        int i = 0;
        while (atmIter.hasNext()) {
            IAtmosphere atm = atmIter.next();
            btns.add(new ModuleButton(60, 4 + i * 24, LibVulpes.proxy.getLocalizedString(atm.getUnlocalizedName()), (IButtonInventory)this, TextureResources.buttonBuild).setAdditionalData((Object)atm));
            ++i;
        }
        ModuleContainerPan panningContainer = new ModuleContainerPan(5, 20, btns, new LinkedList(), TextureResources.starryBG, 165, 120, 0, 500);
        modules.add((ModuleBase)panningContainer);
        return modules;
    }

    public String getModularInventoryName() {
        return "atmosphereDetector";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void onInventoryButtonPressed(ModuleButton buttonId) {
        this.atmosphereToDetect = (IAtmosphere)buttonId.getAdditionalData();
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 0) {
            PacketBuffer buf = new PacketBuffer((ByteBuf)out);
            buf.writeShort(this.atmosphereToDetect.getUnlocalizedName().length());
            buf.func_180714_a(this.atmosphereToDetect.getUnlocalizedName());
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == 0) {
            PacketBuffer buf = new PacketBuffer((ByteBuf)in);
            nbt.func_74778_a("uName", buf.func_150789_c((int)buf.readShort()));
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == 0) {
            String name = nbt.func_74779_i("uName");
            this.atmosphereToDetect = AtmosphereRegister.getInstance().getAtmosphere(name);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("atmName", this.atmosphereToDetect.getUnlocalizedName());
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.atmosphereToDetect = AtmosphereRegister.getInstance().getAtmosphere(nbt.func_74779_i("atmName"));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

