/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.cables;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.cable.EnergyNetwork;
import zmaster587.advancedRocketry.cable.HandlerCableNetwork;
import zmaster587.advancedRocketry.cable.NetworkRegistry;
import zmaster587.advancedRocketry.tile.cables.TilePipe;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;

public class TileEnergyPipe
extends TilePipe
implements IUniversalEnergy {
    public TileEnergyPipe() {
        super(AdvancedRocketryTileEntityType.TILE_POWER_PIPE);
    }

    @Override
    public boolean canExtract(Direction dir, TileEntity e) {
        LazyOptional cap = e.getCapability(CapabilityEnergy.ENERGY, dir);
        return cap.isPresent() && ((IEnergyStorage)cap.orElse(null)).canExtract() && !(e instanceof TileEnergyPipe);
    }

    @Override
    public boolean canInject(Direction dir, TileEntity e) {
        LazyOptional cap = e.getCapability(CapabilityEnergy.ENERGY, dir);
        return cap.isPresent() && ((IEnergyStorage)cap.orElse(null)).canReceive() && !(e instanceof TileEnergyPipe);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> new ForgePowerCapability((IUniversalEnergy)this)).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public HandlerCableNetwork getNetworkHandler() {
        return NetworkRegistry.energyNetwork;
    }

    @Override
    protected void attemptLink(Direction dir, TileEntity tile) {
        if (this.canExtract(dir, tile) && !this.field_145850_b.field_72995_K) {
            this.connectedSides[dir.ordinal()] = true;
            this.getNetworkHandler().removeFromAllTypes(this, tile);
            this.getNetworkHandler().addSource(this, tile, dir);
        }
        if (this.canInject(dir, tile) && !this.field_145850_b.field_72995_K) {
            this.connectedSides[dir.ordinal()] = true;
            this.getNetworkHandler().removeFromAllTypes(this, tile);
            this.getNetworkHandler().addSink(this, tile, dir);
        }
    }

    public void setEnergyStored(int amt) {
    }

    public int extractEnergy(int amt, boolean simulate) {
        return 0;
    }

    public int getUniversalEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public int acceptEnergy(int amt, boolean simulate) {
        if (this.isInitialized()) {
            EnergyNetwork network = (EnergyNetwork)this.getNetworkHandler().getNetwork(this.getNetworkID());
            return network.acceptEnergy(amt, simulate);
        }
        return 0;
    }

    public void setMaxEnergyStored(int max) {
    }

    public boolean canReceive() {
        return true;
    }

    public boolean canExtract() {
        return false;
    }
}

