/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.cables;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;
import zmaster587.advancedRocketry.cable.NetworkRegistry;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.world.util.MultiData;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileWirelessTransciever
extends TileEntity
implements INetworkMachine,
IModularInventory,
ILinkableTile,
IDataHandler,
ITickableTileEntity,
IToggleButton {
    boolean extractMode;
    boolean enabled;
    int networkID = -1;
    MultiData data = new MultiData();
    ModuleToggleSwitch toggle;
    protected ModuleToggleSwitch toggleSwitch;

    public TileWirelessTransciever() {
        super(AdvancedRocketryTileEntityType.TILE_WIRELESS_TRANSCIEVER);
        this.data.setMaxData(100);
        this.toggle = new ModuleToggleSwitch(50, 50, LibVulpes.proxy.getLocalizedString("msg.wirelesstransciever.extract"), (IToggleButton)this, TextureResources.buttonGeneric, 64, 18, false);
        this.toggleSwitch = new ModuleToggleSwitch(160, 5, "", (IToggleButton)this, zmaster587.libVulpes.inventory.TextureResources.buttonToggleImage, 11, 26, true);
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        if (world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.linker.program"), Util.field_240973_b_);
        }
        return true;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (NetworkRegistry.dataNetwork.doesNetworkExist(this.networkID)) {
            NetworkRegistry.dataNetwork.getNetwork(this.networkID).removeFromAll(this);
        }
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        BlockPos pos = ItemLinker.getMasterCoords((ItemStack)item);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileWirelessTransciever) {
            if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.linker.success"), Util.field_240973_b_);
                return true;
            }
            int othernetworkid = ((TileWirelessTransciever)tile).networkID;
            if (this.networkID == -1 && othernetworkid == -1) {
                ((TileWirelessTransciever)tile).networkID = this.networkID = NetworkRegistry.dataNetwork.getNewNetworkID();
            } else if (this.networkID == -1) {
                this.networkID = othernetworkid;
            } else {
                ((TileWirelessTransciever)tile).networkID = othernetworkid == -1 ? this.networkID : (this.networkID = NetworkRegistry.dataNetwork.mergeNetworks(othernetworkid, this.networkID));
            }
            this.addToNetwork();
            ((TileWirelessTransciever)tile).addToNetwork();
            ItemLinker.resetPosition((ItemStack)item);
            return true;
        }
        return false;
    }

    private void addToNetwork() {
        if (this.networkID == -1 || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!NetworkRegistry.dataNetwork.doesNetworkExist(this.networkID)) {
            NetworkRegistry.dataNetwork.getNewNetworkID(this.networkID);
        }
        if (this.extractMode) {
            NetworkRegistry.dataNetwork.getNetwork(this.networkID).addSource(this, Direction.UP);
        } else {
            NetworkRegistry.dataNetwork.getNetwork(this.networkID).addSink(this, Direction.UP);
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean canExtract(Direction dir, TileEntity e) {
        return e instanceof IDataHandler;
    }

    public boolean canInject(Direction dir, TileEntity e) {
        return e instanceof IDataHandler;
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> list = new LinkedList<ModuleBase>();
        list.add((ModuleBase)this.toggle);
        list.add((ModuleBase)this.toggleSwitch);
        return list;
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.wirelesstransciever";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 0) {
            out.writeBoolean(this.toggle.getState());
        } else if (id == 1) {
            out.writeBoolean(this.toggleSwitch.getState());
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        nbt.func_74757_a("state", in.readBoolean());
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (side.isDedicatedServer()) {
            if (id == 0) {
                this.extractMode = nbt.func_74767_n("state");
                if (NetworkRegistry.dataNetwork.doesNetworkExist(this.networkID)) {
                    NetworkRegistry.dataNetwork.getNetwork(this.networkID).removeFromAll(this);
                    if (this.extractMode) {
                        NetworkRegistry.dataNetwork.getNetwork(this.networkID).addSource(this, Direction.UP);
                    } else {
                        NetworkRegistry.dataNetwork.getNetwork(this.networkID).addSink(this, Direction.UP);
                    }
                }
            } else if (id == 1) {
                this.enabled = nbt.func_74767_n("state");
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.extractMode = nbt.func_74767_n("mode");
        this.enabled = nbt.func_74767_n("enabled");
        this.networkID = nbt.func_74762_e("networkID");
        this.data.readFromNBT(nbt);
        this.toggle.setToggleState(this.extractMode);
        this.toggleSwitch.setToggleState(this.enabled);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74757_a("mode", this.extractMode);
        nbt.func_74757_a("enabled", this.enabled);
        nbt.func_74768_a("networkID", this.networkID);
        this.data.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        return this.enabled ? this.data.extractData(maxAmount, type, dir, commit) : 0;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        return this.enabled ? this.data.addData(maxAmount, type, dir, commit) : 0;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            if (!NetworkRegistry.dataNetwork.doesNetworkExist(this.networkID)) {
                NetworkRegistry.dataNetwork.getNewNetworkID(this.networkID);
            }
            NetworkRegistry.dataNetwork.getNetwork(this.networkID).removeFromAll(this);
            if (this.extractMode) {
                NetworkRegistry.dataNetwork.getNetwork(this.networkID).addSource(this, Direction.UP);
            } else {
                NetworkRegistry.dataNetwork.getNetwork(this.networkID).addSink(this, Direction.UP);
            }
        }
    }

    public void func_73660_a() {
        BlockState state;
        if (!this.field_145850_b.field_72995_K && (state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177230_c() instanceof RotatableBlock) {
            Direction facing = RotatableBlock.getFront((BlockState)state).func_176734_d();
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e()));
            if (tile instanceof IDataHandler && !(tile instanceof TileWirelessTransciever)) {
                for (DataStorage.DataType data : DataStorage.DataType.values()) {
                    if (data == DataStorage.DataType.UNDEFINED) continue;
                    if (!this.extractMode) {
                        int amountCurrent = this.data.getDataAmount(data);
                        if (amountCurrent <= 0) continue;
                        int amt = ((IDataHandler)tile).addData(amountCurrent, data, facing.func_176734_d(), true);
                        this.data.extractData(amt, data, facing.func_176734_d(), true);
                        continue;
                    }
                    int amt = ((IDataHandler)tile).extractData(this.data.getMaxData() - this.data.getDataAmount(data), data, facing.func_176734_d(), true);
                    this.data.addData(amt, data, facing.func_176734_d(), true);
                }
            }
        }
    }

    public void onInventoryButtonPressed(ModuleButton buttonId) {
        if (buttonId == this.toggleSwitch) {
            this.enabled = this.toggleSwitch.getState();
        } else if (buttonId == this.toggle) {
            this.extractMode = this.toggle.getState();
        }
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(buttonId != this.toggle ? 1 : 0)));
    }

    public void stateUpdated(ModuleBase module) {
        if (module == this.toggleSwitch) {
            this.enabled = this.toggleSwitch.getState();
        } else if (module == this.toggle) {
            this.extractMode = this.toggle.getState();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

