/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.block.BlockTileRedstoneEmitter;
import zmaster587.advancedRocketry.tile.TileRocketAssemblingMachine;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleLiquidIndicator;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumerTank;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.IconResource;
import zmaster587.libVulpes.util.ZUtils;

public class TileFuelingStation
extends TileInventoriedRFConsumerTank
implements IModularInventory,
IMultiblock,
IInfrastructure,
ILinkableTile,
INetworkMachine,
IButtonInventory {
    EntityRocketBase linkedRocket;
    HashedBlockPosition masterBlock = new HashedBlockPosition(0, -1, 0);
    ModuleRedstoneOutputButton redstoneControl = new ModuleRedstoneOutputButton(174, 4, "", (IButtonInventory)this);
    ZUtils.RedstoneState state = ZUtils.RedstoneState.ON;
    final int fuelPointsPer10Mb = 10;

    public TileFuelingStation() {
        super(AdvancedRocketryTileEntityType.TILE_FUELING_STATION, 1000, 3, 5000);
    }

    @Override
    public int getMaxLinkDistance() {
        return 10;
    }

    private void setRedstoneState(boolean condition) {
        if (this.state == ZUtils.RedstoneState.INVERTED) {
            condition = !condition;
        } else if (this.state == ZUtils.RedstoneState.OFF) {
            condition = false;
        }
        ((BlockTileRedstoneEmitter)AdvancedRocketryBlocks.blockFuelingStation).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, condition);
    }

    public void performFunction() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getFluid() != null && this.linkedRocket.stats.getFuelFluid() == null) {
                if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, this.tank.getFluid().getFluid()) && this.linkedRocket.stats.getFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) > 0 || FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, this.tank.getFluid().getFluid()) && this.linkedRocket.stats.getFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT) > 0) {
                    this.linkedRocket.stats.setFuelFluid(this.tank.getFluid().getFluid().getRegistryName());
                }
            } else if (this.tank.getFluid() != null && this.linkedRocket.stats.getOxidizerFluid() == null && FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, this.tank.getFluid().getFluid())) {
                this.linkedRocket.stats.setOxidizerFluid(this.tank.getFluid().getFluid().getRegistryName());
            }
            if (this.tank.getFluid() != null && this.isFluidFillable(this.tank.getFluid().getFluid())) {
                if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, this.tank.getFluid().getFluid())) {
                    int fuelRate = (int)(FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, this.tank.getFluid().getFluid()) * this.linkedRocket.stats.getBaseFuelRate(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT));
                    this.tank.drain(this.linkedRocket.addFuelAmountMonopropellant(10), IFluidHandler.FluidAction.EXECUTE);
                    this.linkedRocket.setFuelRateMonopropellant(fuelRate);
                } else if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, this.tank.getFluid().getFluid())) {
                    int fuelRate = (int)(FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, this.tank.getFluid().getFluid()) * this.linkedRocket.stats.getBaseFuelRate(FuelRegistry.FuelType.LIQUID_BIPROPELLANT));
                    this.tank.drain(this.linkedRocket.addFuelAmountBipropellant(10), IFluidHandler.FluidAction.EXECUTE);
                    this.linkedRocket.setFuelRateBipropellant(fuelRate);
                } else if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, this.tank.getFluid().getFluid())) {
                    int fuelRate = (int)(FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID_OXIDIZER, this.tank.getFluid().getFluid()) * this.linkedRocket.stats.getBaseFuelRate(FuelRegistry.FuelType.LIQUID_OXIDIZER));
                    this.tank.drain(this.linkedRocket.addFuelAmountOxidizer(10), IFluidHandler.FluidAction.EXECUTE);
                    this.linkedRocket.setFuelRateOxidizer(fuelRate);
                }
            }
            if (this.tank.getFluid() != null) {
                this.setRedstoneState(!this.canRocketFitFluid(this.tank.getFluid().getFluid()));
            }
        }
        this.useBucket(0, this.inventory.func_70301_a(0));
    }

    public boolean isFluidFillable(Fluid fluid) {
        return FluidUtils.areFluidsSameType((ResourceLocation)this.linkedRocket.stats.getFuelFluid(), (Fluid)fluid) || FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluid) && FluidUtils.areFluidsSameType((ResourceLocation)this.linkedRocket.stats.getOxidizerFluid(), (Fluid)fluid) && FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, (Fluid)ForgeRegistries.FLUIDS.getValue(this.linkedRocket.stats.getFuelFluid()));
    }

    public int getPowerPerOperation() {
        return 30;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean canPerformFunction() {
        return this.linkedRocket != null && this.tank.getFluid() != null && this.tank.getFluidAmount() > 9 && (this.linkedRocket.getRocketStats().getFuelAmount(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) < this.linkedRocket.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT) || this.linkedRocket.getRocketStats().getFuelAmount(FuelRegistry.FuelType.LIQUID_BIPROPELLANT) < this.linkedRocket.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.LIQUID_BIPROPELLANT) || this.linkedRocket.getRocketStats().getFuelAmount(FuelRegistry.FuelType.LIQUID_OXIDIZER) < this.linkedRocket.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.LIQUID_OXIDIZER));
    }

    public boolean canFill(Fluid fluid) {
        return FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluid) || FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluid) || FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluid);
    }

    public boolean canRocketFitFluid(Fluid fluid) {
        return this.isFluidFillable(fluid) && FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluid) ? this.linkedRocket.getFuelCapacityMonopropellant() > this.linkedRocket.getFuelAmountMonopropellant() : (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluid) ? this.linkedRocket.getFuelCapacityBipropellant() > this.linkedRocket.getFuelAmountBipropellant() : this.linkedRocket.getFuelCapacityOxidizer() > this.linkedRocket.getFuelAmountOxidizer());
    }

    public String getModularInventoryName() {
        return "Fueling Station";
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        while (this.useBucket(0, this.func_70301_a(0))) {
        }
    }

    private boolean useBucket(int slot, ItemStack stack) {
        FluidStack preTransfer;
        IFluidHandlerItem fluidItem;
        FluidStack fluidStack;
        if (slot == 0 && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() && (fluidStack = (fluidItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null)).getFluidInTank(0)) != null && (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluidStack.getFluid()) || FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluidStack.getFluid()) || FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluidStack.getFluid())) && this.tank.getFluidAmount() + fluidItem.getTankCapacity(0) <= this.tank.getCapacity() && fluidStack != null && (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fluidStack.getFluid()) || FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_BIPROPELLANT, fluidStack.getFluid()) || FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_OXIDIZER, fluidStack.getFluid())) && (preTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)((IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null)), (int)5000, (boolean)false)) != null) {
            FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)((IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null)), (int)5000, (boolean)true);
            ItemStack resultContainer = ((IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null)).getContainer();
            if (!resultContainer.func_190926_b() && resultContainer.func_77969_a(this.inventory.func_70301_a(1)) && this.inventory.func_70301_a(1).func_77976_d() > this.inventory.func_70301_a(1).func_190916_E()) {
                this.inventory.func_70301_a(1).func_190920_e(this.inventory.func_70301_a(1).func_190916_E() + 1);
                super.func_70299_a(0, ItemStack.field_190927_a);
            } else if (!resultContainer.func_190926_b() && this.inventory.func_70301_a(1).func_190926_b()) {
                super.func_70299_a(1, resultContainer.func_77946_l());
                super.func_70299_a(0, ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            FluidStack fstack = ((IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null)).getFluidInTank(0);
            return fstack != null && FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, fstack.getFluid());
        }
        return FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, stack);
    }

    @Override
    public void unlinkRocket() {
        this.linkedRocket = null;
        ((BlockTileRedstoneEmitter)AdvancedRocketryBlocks.blockFuelingStation).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, false);
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return true;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.linkedRocket = rocket;
        if (this.tank.getFluid() != null) {
            this.setRedstoneState(!this.canRocketFitFluid(this.tank.getFluid().getFluid()));
        }
        return true;
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.field_174879_c);
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(LibVulpes.proxy.getLocalizedString("msg.fuelingStation.link") + ": " + this.field_174879_c.func_177958_n() + " " + this.field_174879_c.func_177956_o() + " " + this.field_174879_c.func_177952_p()));
        }
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getMasterBlock() instanceof TileRocketAssemblingMachine) {
            ((TileRocketAssemblingMachine)this.getMasterBlock()).removeConnectedInfrastructure((TileEntity)this);
        }
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
        }
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("msg.linker.error.firstmachine"));
        }
        return false;
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        ArrayList<ModuleBase> list = new ArrayList<ModuleBase>();
        list.add((ModuleBase)new ModulePower(156, 12, (IUniversalEnergy)this));
        list.add((ModuleBase)new ModuleSlotArray(45, 18, (IInventory)this, 0, 1));
        list.add((ModuleBase)new ModuleSlotArray(45, 54, (IInventory)this, 1, 2));
        list.add((ModuleBase)this.redstoneControl);
        if (this.field_145850_b.field_72995_K) {
            list.add((ModuleBase)new ModuleImage(44, 35, new IconResource(194, 0, 18, 18, CommonResources.genericBackground)));
        }
        list.add((ModuleBase)new ModuleLiquidIndicator(27, 18, (IFluidHandler)this));
        return list;
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    @Override
    public boolean linkMission(IMission misson) {
        return false;
    }

    @Override
    public void unlinkMission() {
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        if (this.hasMaster()) {
            nbt.func_74783_a("masterPos", new int[]{this.masterBlock.x, this.masterBlock.y, this.masterBlock.z});
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        ZUtils.RedstoneState redstate = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(redstate);
        if (nbt.func_74764_b("masterPos")) {
            int[] pos = nbt.func_74759_k("masterPos");
            this.setMasterBlock(new BlockPos(pos[0], pos[1], pos[2]));
        }
    }

    public boolean hasMaster() {
        return this.masterBlock.y > -1;
    }

    public TileEntity getMasterBlock() {
        return this.field_145850_b.func_175625_s(new BlockPos(this.masterBlock.x, (int)this.masterBlock.y, this.masterBlock.z));
    }

    public void setComplete(BlockPos pos) {
    }

    public void setIncomplete() {
        this.masterBlock.y = (short)-1;
    }

    public void setMasterBlock(BlockPos pos) {
        this.masterBlock = new HashedBlockPosition(pos);
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    public void onInventoryButtonPressed(ModuleButton buttonId) {
        this.state = this.redstoneControl.getState();
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        out.writeByte(this.state.ordinal());
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        nbt.func_74774_a("state", in.readByte());
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        if (this.linkedRocket != null && this.tank.getFluid() != null) {
            this.setRedstoneState(!this.canRocketFitFluid(this.tank.getFluid().getFluid()));
        }
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

