/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.block.multiblock.BlockARHatch;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.tile.TileRocketAssemblingMachine;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleBlockSideSelector;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.hatch.TileFluidOutputHatch;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileRocketFluidUnloader
extends TileFluidOutputHatch
implements IInfrastructure,
ITickableTileEntity,
IButtonInventory,
INetworkMachine,
IGuiCallback {
    EntityRocket rocket;
    ModuleRedstoneOutputButton redstoneControl;
    ZUtils.RedstoneState state;
    ModuleRedstoneOutputButton inputRedstoneControl;
    ZUtils.RedstoneState inputstate;
    ModuleBlockSideSelector sideSelectorModule;
    private static int ALLOW_REDSTONEOUT = 2;

    public TileRocketFluidUnloader() {
        super(AdvancedRocketryTileEntityType.TILE_FLUID_UNLOADER);
    }

    public TileRocketFluidUnloader(int size) {
        super(AdvancedRocketryTileEntityType.TILE_FLUID_UNLOADER, size);
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.funloader";
    }

    protected boolean getStrongPowerForSides(World world, BlockPos pos) {
        for (int i = 0; i < 6; ++i) {
            if (this.sideSelectorModule.getStateForSide(i) != ALLOW_REDSTONEOUT || world.func_175651_c(pos.func_177972_a(Direction.values()[i]), Direction.values()[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isStateActive(ZUtils.RedstoneState state, boolean condition) {
        if (state == ZUtils.RedstoneState.INVERTED) {
            return !condition;
        }
        if (state == ZUtils.RedstoneState.OFF) {
            return false;
        }
        return condition;
    }

    protected void setRedstoneState(boolean condition) {
        condition = this.isStateActive(this.state, condition);
        ((BlockARHatch)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, condition);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.rocket != null) {
            boolean isAllowToOperate = this.inputstate == ZUtils.RedstoneState.OFF || this.isStateActive(this.inputstate, this.getStrongPowerForSides(this.field_145850_b, this.func_174877_v()));
            List<TileEntity> tiles = this.rocket.storage.getFluidTiles();
            boolean rocketContainsItems = false;
            for (TileEntity tile : tiles) {
                IFluidHandler handler = (IFluidHandler)tile;
                if (handler.drain(1, IFluidHandler.FluidAction.SIMULATE) != null) {
                    rocketContainsItems = true;
                }
                if (!isAllowToOperate) continue;
                FluidStack stack = this.fluidTank.getFluid();
                if (stack == null) {
                    this.fill(handler.drain(this.fluidTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    continue;
                }
                stack = stack.copy();
                stack.setAmount(this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount());
                if (stack.getAmount() == 0) continue;
                this.fill(handler.drain(stack, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            }
            this.setRedstoneState(!rocketContainsItems);
        }
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.rocket = (EntityRocket)rocket;
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean linkMission(IMission misson) {
        return false;
    }

    @Override
    public void unlinkMission() {
    }

    @Override
    public int getMaxLinkDistance() {
        return 32;
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    public void func_230337_a_(BlockState blkstate, CompoundNBT nbt) {
        super.func_230337_a_(blkstate, nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        this.inputstate = ZUtils.RedstoneState.values()[nbt.func_74771_c("inputRedstoneState")];
        this.inputRedstoneControl.setRedstoneState(this.inputstate);
        this.sideSelectorModule.readFromNBT(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        nbt.func_74774_a("inputRedstoneState", (byte)this.inputstate.ordinal());
        this.sideSelectorModule.write(nbt);
        return nbt;
    }

    public void onInventoryButtonPressed(ModuleButton buttonId) {
        if (buttonId == this.redstoneControl) {
            this.state = this.redstoneControl.getState();
        }
        if (buttonId == this.inputRedstoneControl) {
            this.inputstate = this.inputRedstoneControl.getState();
        }
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        out.writeByte(this.state.ordinal());
        out.writeByte(this.inputstate.ordinal());
        for (int i = 0; i < 6; ++i) {
            out.writeByte(this.sideSelectorModule.getStateForSide(i));
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        nbt.func_74774_a("state", in.readByte());
        nbt.func_74774_a("inputstate", in.readByte());
        byte[] bytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            bytes[i] = in.readByte();
        }
        nbt.func_74773_a("bytes", bytes);
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        this.inputstate = ZUtils.RedstoneState.values()[nbt.func_74771_c("inputstate")];
        byte[] bytes = nbt.func_74770_j("bytes");
        for (int i = 0; i < 6; ++i) {
            this.sideSelectorModule.setStateForSide(i, (int)bytes[i]);
        }
        if (this.rocket == null) {
            this.setRedstoneState(this.state == ZUtils.RedstoneState.INVERTED);
        }
        this.func_70296_d();
        this.field_145850_b.func_175646_b(this.func_174877_v(), (TileEntity)this);
    }

    public void onModuleUpdated(ModuleBase module) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getMasterBlock() instanceof TileRocketAssemblingMachine) {
            ((TileRocketAssemblingMachine)this.getMasterBlock()).removeConnectedInfrastructure((TileEntity)this);
        }
    }

    public boolean allowRedstoneOutputOnSide(Direction facing) {
        return this.sideSelectorModule.getStateForSide(facing.func_176734_d()) == 1;
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List list = super.getModules(ID, player);
        list.add(this.redstoneControl);
        list.add(this.inputRedstoneControl);
        list.add(this.sideSelectorModule);
        return list;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        if (this.rocket != null) {
            this.rocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("%s %s", new Object[]{new TranslationTextComponent("msg.fluidloader.link"), ": " + this.func_174877_v().func_177958_n() + " " + this.func_174877_v().func_177956_o() + " " + this.func_174877_v().func_177952_p()}));
        }
        return true;
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("msg.linker.error.firstmachine"));
        }
        return false;
    }

    @Override
    public void unlinkRocket() {
        this.rocket = null;
        ((BlockARHatch)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).setRedstoneState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, false);
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return true;
    }
}

