/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.client.util.IndicatorBarImage;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.IAdjBlockUpdate;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileRocketMonitoringStation
extends TileEntity
implements IModularInventory,
IAdjBlockUpdate,
IInfrastructure,
ILinkableTile,
INetworkMachine,
IButtonInventory,
IProgressBar {
    EntityRocketBase linkedRocket;
    IMission mission = null;
    ModuleText missionText = new ModuleText(20, 90, LibVulpes.proxy.getLocalizedString("msg.monitoringstation.missionprogressna"), 0x2B2B2B);
    ZUtils.RedstoneState state;
    ModuleRedstoneOutputButton redstoneControl = new ModuleRedstoneOutputButton(174, 4, "", (IButtonInventory)this);
    int rocketHeight;
    int velocity;
    int fuelLevel;
    int maxFuelLevel;

    public TileRocketMonitoringStation() {
        super(AdvancedRocketryTileEntityType.TILE_MONITORIING_STATION);
        this.state = ZUtils.RedstoneState.ON;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (this.mission != null) {
            this.mission.unlinkInfrastructure(this);
            this.unlinkMission();
        }
    }

    public boolean getEquivilentPower() {
        boolean state2;
        if (this.state == ZUtils.RedstoneState.OFF) {
            return false;
        }
        boolean bl = state2 = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        if (this.state == ZUtils.RedstoneState.INVERTED) {
            state2 = !state2;
        }
        return state2;
    }

    public void onAdjacentBlockUpdated() {
        if (!this.field_145850_b.field_72995_K && this.getEquivilentPower() && this.linkedRocket != null) {
            this.linkedRocket.prepareLaunch();
        }
    }

    @Override
    public int getMaxLinkDistance() {
        return 300000;
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("%s %s", new Object[]{new TranslationTextComponent("msg.monitoringstation.link"), ": " + this.func_174877_v().func_177958_n() + " " + this.func_174877_v().func_177956_o() + " " + this.func_174877_v().func_177952_p()}));
        }
        return true;
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("msg.linker.error.firstmachine"));
        }
        return false;
    }

    @Override
    public void unlinkRocket() {
        this.linkedRocket = null;
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return false;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.linkedRocket = rocket;
        return true;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_230337_a_(BlockState blkstate, CompoundNBT nbt) {
        super.func_230337_a_(blkstate, nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        if (nbt.func_74764_b("missionID")) {
            long id = nbt.func_74763_f("missionID");
            ResourceLocation dimid = new ResourceLocation(nbt.func_74779_i("missionDimId"));
            SatelliteBase sat = DimensionManager.getInstance().getSatellite(id);
            if (sat instanceof IMission) {
                this.mission = (IMission)((Object)sat);
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        if (this.mission != null) {
            nbt.func_74772_a("missionID", this.mission.getMissionId());
            nbt.func_74778_a("missionDimId", this.mission.getOriginatingDimention().toString());
        }
        return nbt;
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 1) {
            out.writeLong(this.mission == null ? -1L : this.mission.getMissionId());
        } else if (id == 2) {
            out.writeByte(this.state.ordinal());
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == 1) {
            nbt.func_74772_a("id", in.readLong());
        } else if (packetId == 2) {
            nbt.func_74774_a("state", in.readByte());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == 1) {
            long idNum = nbt.func_74763_f("id");
            if (idNum == -1L) {
                this.mission = null;
                this.setMissionText();
            } else {
                SatelliteBase base = DimensionManager.getInstance().getSatellite(idNum);
                if (base instanceof IMission) {
                    this.mission = (IMission)((Object)base);
                    this.setMissionText();
                }
            }
        } else if (id == 2) {
            this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
            this.redstoneControl.setRedstoneState(this.state);
        }
        if (id == 100 && this.linkedRocket != null) {
            this.linkedRocket.prepareLaunch();
        }
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModuleButton(20, 40, "Launch!", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        modules.add((ModuleBase)new ModuleProgress(98, 4, 0, (ProgressBarImage)new IndicatorBarImage(2, 7, 12, 81, 17, 0, 6, 6, 1, 0, Direction.UP, TextureResources.rocketHud), (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(120, 14, 1, (ProgressBarImage)new IndicatorBarImage(2, 95, 12, 71, 17, 0, 6, 6, 1, 0, Direction.UP, TextureResources.rocketHud), (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(142, 14, 2, new ProgressBarImage(2, 173, 12, 71, 17, 6, 3, 69, 1, 1, Direction.UP, TextureResources.rocketHud), (IProgressBar)this));
        modules.add((ModuleBase)this.redstoneControl);
        this.setMissionText();
        modules.add((ModuleBase)this.missionText);
        modules.add((ModuleBase)new ModuleProgress(30, 110, 3, TextureResources.progressToMission, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(30, 120, 4, TextureResources.workMission, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(30, 130, 5, TextureResources.progressFromMission, (IProgressBar)this));
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToPlayer((BasePacket)new PacketMachine((INetworkMachine)this, 1), (PlayerEntity)player);
        }
        return modules;
    }

    private void setMissionText() {
        if (this.mission != null) {
            int time = this.mission.getTimeRemainingInSeconds();
            int seconds = time % 60;
            int minutes = time / 60 % 60;
            int hours = time / 3600;
            this.missionText.setText(((SatelliteBase)((Object)this.mission)).getName() + " " + LibVulpes.proxy.getLocalizedString("msg.monitoringstation.progress") + String.format("\n%02dhr:%02dm:%02ds", hours, minutes, seconds));
        } else {
            this.missionText.setText(LibVulpes.proxy.getLocalizedString("msg.monitoringstation.missionprogressna"));
        }
    }

    public void onInventoryButtonPressed(ModuleButton buttonId) {
        if (buttonId == this.redstoneControl) {
            this.state = this.redstoneControl.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
        } else {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 100));
        }
    }

    public String getModularInventoryName() {
        return "container.monitoringstation";
    }

    public float getNormallizedProgress(int id) {
        if (id == 1) {
            return Math.max(Math.min(0.5f + (float)this.getProgress(id) / (float)this.getTotalProgress(id), 1.0f), 0.0f);
        }
        if (id == 3) {
            if (this.mission == null) {
                return 0.0f;
            }
            return (float)Math.min(3.0 * this.mission.getProgress(this.field_145850_b), 1.0);
        }
        if (id == 4) {
            if (this.mission == null) {
                return 0.0f;
            }
            return (float)Math.min(Math.max(3.0 * (this.mission.getProgress(this.field_145850_b) - (double)0.333f), 0.0), 1.0);
        }
        if (id == 5) {
            if (this.mission == null) {
                return 0.0f;
            }
            return (float)Math.min(Math.max(3.0 * (this.mission.getProgress(this.field_145850_b) - (double)0.666f), 0.0), 1.0);
        }
        if (this.field_145850_b.field_72995_K && this.mission != null) {
            this.setMissionText();
        }
        return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
    }

    public void setProgress(int id, int progress) {
        if (id == 0) {
            this.rocketHeight = progress;
        } else if (id == 1) {
            this.velocity = progress;
        } else if (id == 2) {
            this.fuelLevel = progress;
        }
    }

    public int getProgress(int id) {
        if (this.field_145850_b.field_72995_K) {
            if (this.mission != null && id == 0) {
                return this.getTotalProgress(id);
            }
            if (id == 0) {
                return this.rocketHeight;
            }
            if (id == 1) {
                return this.velocity;
            }
            if (id == 2) {
                return this.fuelLevel;
            }
        }
        if (this.linkedRocket == null) {
            return 0;
        }
        if (id == 0) {
            return (int)this.linkedRocket.func_226278_cu_();
        }
        if (id == 1) {
            return (int)(this.linkedRocket.func_213322_ci().field_72448_b * 100.0);
        }
        if (id == 2) {
            if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, (Fluid)ForgeRegistries.FLUIDS.getValue(this.linkedRocket.stats.getFuelFluid()))) {
                return this.linkedRocket.getFuelAmountMonopropellant();
            }
            return this.linkedRocket.getFuelAmountBipropellant() + this.linkedRocket.getFuelAmountOxidizer();
        }
        return 0;
    }

    public int getTotalProgress(int id) {
        if (id == 0) {
            return (Integer)ARConfiguration.getCurrentConfig().orbit.get();
        }
        if (id == 1) {
            return 200;
        }
        if (id == 2) {
            if (this.field_145850_b.field_72995_K) {
                return this.maxFuelLevel;
            }
            if (this.linkedRocket == null) {
                return 0;
            }
            if (FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID_MONOPROPELLANT, (Fluid)ForgeRegistries.FLUIDS.getValue(this.linkedRocket.stats.getFuelFluid()))) {
                return this.linkedRocket.getFuelCapacityMonopropellant();
            }
            return this.linkedRocket.getFuelCapacityBipropellant() + this.linkedRocket.getFuelCapacityOxidizer();
        }
        return 1;
    }

    public void setTotalProgress(int id, int progress) {
        if (id == 2) {
            this.maxFuelLevel = progress;
        }
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    @Override
    public boolean linkMission(IMission misson) {
        this.mission = misson;
        PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (World)this.field_145850_b, (BlockPos)this.func_174877_v(), (double)16.0);
        return true;
    }

    @Override
    public void unlinkMission() {
        this.mission = null;
        this.setMissionText();
        PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (World)this.field_145850_b, (BlockPos)this.func_174877_v(), (double)16.0);
    }

    @Override
    public boolean canRenderConnection() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULARNOINV;
    }
}

