/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleData;
import zmaster587.advancedRocketry.item.ItemAsteroidChip;
import zmaster587.advancedRocketry.tile.hatch.TileDataBus;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.block.multiblock.BlockMultiblockMachine;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInputHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInventoryHatch;
import zmaster587.libVulpes.tile.multiblock.hatch.TileOutputHatch;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileAstrobodyDataProcessor
extends TileMultiPowerConsumer
implements IModularInventory,
IInventory {
    private static final Object[][][] structure = new Object[][][]{{{"slabs", Character.valueOf('c'), "slabs"}, {"slabs", "slabs", "slabs"}}, {{Character.valueOf('P'), Character.valueOf('I'), Character.valueOf('O')}, {Character.valueOf('D'), Character.valueOf('D'), Character.valueOf('D')}}};
    private TileDataBus[] dataCables = new TileDataBus[3];
    private boolean researchingDistance;
    private boolean researchingAtmosphere;
    private boolean researchingMass;
    private int atmosphereProgress;
    private int distanceProgress;
    private int massProgress;
    private static final int maxResearchTime = 20;
    private EmbeddedInventory inventory;
    TileInventoryHatch inputHatch;
    TileInventoryHatch outputHatch;

    public TileAstrobodyDataProcessor() {
        super(AdvancedRocketryTileEntityType.TILE_ASTROBODY_DATA);
        this.powerPerTick = 100;
        this.atmosphereProgress = -1;
        this.distanceProgress = -1;
        this.massProgress = -1;
        this.inventory = new EmbeddedInventory(1);
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List list = super.getAllowableWildCardBlocks();
        list.add(new BlockMeta(Blocks.field_150339_S, true));
        return list;
    }

    public boolean shouldHideBlock(World world, BlockPos pos2, BlockState tile) {
        return true;
    }

    protected void integrateTile(TileEntity tile) {
        super.integrateTile(tile);
        if (tile instanceof TileDataBus) {
            for (int i = 0; i < this.dataCables.length; ++i) {
                if (this.dataCables[i] != null) continue;
                this.dataCables[i] = (TileDataBus)tile;
                switch (i) {
                    case 0: {
                        this.dataCables[i].lockData(DataStorage.DataType.COMPOSITION);
                        break;
                    }
                    case 1: {
                        this.dataCables[i].lockData(DataStorage.DataType.DISTANCE);
                        break;
                    }
                    case 2: {
                        this.dataCables[i].lockData(DataStorage.DataType.MASS);
                    }
                }
                break;
            }
        } else if (tile instanceof TileInputHatch) {
            this.inputHatch = (TileInventoryHatch)tile;
        } else if (tile instanceof TileOutputHatch) {
            this.outputHatch = (TileInventoryHatch)tile;
        }
    }

    public void deconstructMultiBlock(World world, BlockPos destroyedPos, boolean blockBroken, BlockState state) {
        for (int i = 0; i < this.dataCables.length; ++i) {
            if (this.dataCables[i] == null) continue;
            this.dataCables[i].lockData(null);
        }
        super.deconstructMultiBlock(world, destroyedPos, blockBroken, state);
    }

    public void resetCache() {
        super.resetCache();
        Arrays.fill(this.dataCables, null);
        this.inputHatch = null;
        this.outputHatch = null;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public String getMachineName() {
        return "block.advancedrocketry.planetanalyser";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public void onInventoryUpdated() {
        super.onInventoryUpdated();
        if (this.inputHatch == null) {
            return;
        }
        if (this.func_70301_a(0) == ItemStack.field_190927_a) {
            for (int j = 0; j < this.inputHatch.func_70302_i_(); ++j) {
                ItemStack stack2 = this.inputHatch.func_70301_a(j);
                if (stack2 == null || !(stack2.func_77973_b() instanceof ItemAsteroidChip) || ((ItemAsteroidChip)stack2.func_77973_b()).getUUID(stack2) == null) continue;
                this.func_70299_a(0, this.inputHatch.func_70298_a(j, 1));
                break;
            }
        }
        this.attemptAllResearchStart();
    }

    protected void processComplete() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < this.outputHatch.func_70302_i_(); ++i) {
                if (this.outputHatch.func_70301_a(i) != ItemStack.field_190927_a) continue;
                this.outputHatch.func_70299_a(i, this.func_70298_a(0, 1));
                return;
            }
        }
    }

    public boolean completeStructure(BlockState state) {
        boolean result = super.completeStructure(state);
        if (result) {
            ((BlockMultiblockMachine)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).setBlockState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, true);
        } else {
            ((BlockMultiblockMachine)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).setBlockState(this.field_145850_b, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_174879_c, false);
        }
        return result;
    }

    private void incrementDataOnChip(int planetId, int amount, DataStorage.DataType dataType) {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack.func_77973_b().equals(AdvancedRocketryItems.itemAsteroidChip)) {
            ItemAsteroidChip item = (ItemAsteroidChip)stack.func_77973_b();
            item.addData(stack, amount, dataType);
            int maxData = item.getMaxData(stack);
            if (item.getData(stack, DataStorage.DataType.COMPOSITION) == maxData && item.getData(stack, DataStorage.DataType.DISTANCE) == maxData && item.getData(stack, DataStorage.DataType.MASS) == maxData) {
                this.processComplete();
            }
        }
    }

    private void attemptAllResearchStart() {
        ItemStack stack = this.func_70301_a(0);
        if (stack == null || !(stack.func_77973_b() instanceof ItemAsteroidChip)) {
            return;
        }
        ItemAsteroidChip item = (ItemAsteroidChip)stack.func_77973_b();
        if (this.researchingAtmosphere && this.atmosphereProgress < 0 && this.extractData(1, DataStorage.DataType.COMPOSITION, false) > 0 && !item.isFull(stack, DataStorage.DataType.COMPOSITION)) {
            this.atmosphereProgress = 0;
        }
        if (this.researchingDistance && this.distanceProgress < 0 && this.extractData(1, DataStorage.DataType.DISTANCE, false) > 0 && !item.isFull(stack, DataStorage.DataType.DISTANCE)) {
            this.distanceProgress = 0;
        }
        if (this.researchingMass && this.massProgress < 0 && this.extractData(1, DataStorage.DataType.MASS, false) > 0 && !item.isFull(stack, DataStorage.DataType.MASS)) {
            this.massProgress = 0;
        }
        this.func_70296_d();
    }

    private int extractData(int amt, DataStorage.DataType type, boolean simulate) {
        switch (type) {
            case COMPOSITION: {
                if (this.dataCables[0] != null) {
                    return this.dataCables[0].extractData(1, DataStorage.DataType.COMPOSITION, Direction.UP, !simulate);
                }
            }
            case DISTANCE: {
                if (this.dataCables[1] != null) {
                    return this.dataCables[1].extractData(1, DataStorage.DataType.DISTANCE, Direction.UP, !simulate);
                }
            }
            case MASS: {
                if (this.dataCables[2] == null) break;
                return this.dataCables[2].extractData(1, DataStorage.DataType.MASS, Direction.UP, !simulate);
            }
        }
        return 0;
    }

    protected void onRunningPoweredTick() {
        ItemStack stack;
        if (this.completionTime > 0) {
            super.onRunningPoweredTick();
        }
        if ((stack = this.func_70301_a(0)) != null && stack.func_77973_b().equals(AdvancedRocketryItems.itemAsteroidChip)) {
            ItemAsteroidChip item = (ItemAsteroidChip)stack.func_77973_b();
            if (this.researchingAtmosphere && this.extractData(1, DataStorage.DataType.COMPOSITION, true) > 0 && !item.isFull(stack, DataStorage.DataType.COMPOSITION)) {
                if (this.atmosphereProgress == 20) {
                    this.atmosphereProgress = -1;
                    if (!this.field_145850_b.field_72995_K) {
                        this.incrementDataOnChip(0, 1, DataStorage.DataType.COMPOSITION);
                        this.extractData(1, DataStorage.DataType.COMPOSITION, false);
                    }
                } else {
                    ++this.atmosphereProgress;
                }
            }
            if (this.researchingMass && this.extractData(1, DataStorage.DataType.MASS, true) > 0 && !item.isFull(stack, DataStorage.DataType.MASS)) {
                if (this.massProgress == 20) {
                    this.massProgress = -1;
                    if (!this.field_145850_b.field_72995_K) {
                        this.incrementDataOnChip(0, 1, DataStorage.DataType.MASS);
                        this.extractData(1, DataStorage.DataType.MASS, false);
                    }
                } else {
                    ++this.massProgress;
                }
            }
            if (this.researchingDistance && this.extractData(1, DataStorage.DataType.DISTANCE, true) > 0 && !item.isFull(stack, DataStorage.DataType.DISTANCE)) {
                if (this.distanceProgress == 20) {
                    this.distanceProgress = -1;
                    if (!this.field_145850_b.field_72995_K) {
                        this.incrementDataOnChip(0, 1, DataStorage.DataType.DISTANCE);
                        this.extractData(1, DataStorage.DataType.DISTANCE, false);
                    }
                } else {
                    ++this.distanceProgress;
                }
            }
        }
    }

    public boolean isRunning() {
        return this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b().equals(AdvancedRocketryItems.itemAsteroidChip) && (this.researchingAtmosphere || this.researchingDistance || this.researchingMass);
    }

    public void onInventoryButtonPressed(ModuleButton button) {
        int buttonId;
        int n = buttonId = button.getAdditionalData() == null ? -1 : (Integer)button.getAdditionalData();
        if (buttonId == 0) {
            super.onInventoryButtonPressed(button);
        } else if (buttonId == 1) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
        } else if (buttonId != 2) {
            if (buttonId == 4) {
                this.researchingAtmosphere = !this.researchingAtmosphere;
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
            } else if (buttonId == 5) {
                this.researchingDistance = !this.researchingDistance;
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
            } else if (buttonId == 6) {
                this.researchingMass = !this.researchingMass;
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
            }
        }
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 4) {
            out.writeInt((this.researchingAtmosphere ? 1 : 0) | (this.researchingDistance ? 2 : 0) | (this.researchingMass ? 4 : 0));
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 3 || packetId == 4 || packetId > 100) {
            nbt.func_74768_a("state", in.readInt());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 4) {
            int states = nbt.func_74762_e("state");
            this.researchingAtmosphere = (states & 1) != 0;
            this.researchingDistance = (states & 2) != 0;
            this.researchingMass = (states & 4) != 0;
            this.attemptAllResearchStart();
            this.func_70296_d();
        }
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this.getBatteries()));
        for (int i = 0; i < 3; ++i) {
            if (this.dataCables[i] == null) continue;
            modules.add(new ModuleData(32 + i * 50, 20, 0, this.dataCables[i], this.dataCables[i].getDataObject()));
        }
        int xStart = 150;
        int yStart = 14;
        modules.add((ModuleBase)new ModuleText(15, 76, "Research", 0x404040));
        modules.add((ModuleBase)new ModuleToggleSwitch(15, 86, "", (IToggleButton)this, zmaster587.libVulpes.inventory.TextureResources.buttonToggleImage, LibVulpes.proxy.getLocalizedString("msg.abdp.compositionresearch"), 11, 26, this.researchingAtmosphere).setAdditionalData((Object)4));
        modules.add((ModuleBase)new ModuleToggleSwitch(65, 86, "", (IToggleButton)this, zmaster587.libVulpes.inventory.TextureResources.buttonToggleImage, LibVulpes.proxy.getLocalizedString("msg.abdp.distanceresearch"), 11, 26, this.researchingDistance).setAdditionalData((Object)5));
        modules.add((ModuleBase)new ModuleToggleSwitch(125, 86, "", (IToggleButton)this, zmaster587.libVulpes.inventory.TextureResources.buttonToggleImage, LibVulpes.proxy.getLocalizedString("msg.abdp.massresearch"), 11, 26, this.researchingMass).setAdditionalData((Object)6));
        modules.add((ModuleBase)new ModuleProgress(26, 86, 1, TextureResources.progressScience, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(76, 86, 2, TextureResources.progressScience, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(136, 86, 3, TextureResources.progressScience, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleSlotArray(76, 120, (IInventory)this, 0, 1));
        return modules;
    }

    public int getProgress(int id) {
        if (id == 0) {
            return super.getProgress(id);
        }
        if (id == 1) {
            return this.atmosphereProgress;
        }
        if (id == 2) {
            return this.distanceProgress;
        }
        if (id == 3) {
            return this.massProgress;
        }
        return 0;
    }

    public int getTotalProgress(int id) {
        if (id == 0) {
            return super.getTotalProgress(id);
        }
        return 20;
    }

    public float getNormallizedProgress(int id) {
        if (id != 0) {
            return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
        }
        return 0.0f;
    }

    public void setProgress(int id, int progress) {
        if (id == 1) {
            this.atmosphereProgress = progress;
        } else if (id == 2) {
            this.distanceProgress = progress;
        } else {
            this.massProgress = progress;
        }
    }

    public void setTotalProgress(int id, int progress) {
        if (id == 0) {
            super.setTotalProgress(id, progress);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.readFromNBT(nbt);
        this.atmosphereProgress = nbt.func_74762_e("atmosphereProgress");
        this.distanceProgress = nbt.func_74762_e("distanceProgress");
        this.massProgress = nbt.func_74762_e("massProgress");
    }

    protected void readNetworkData(CompoundNBT nbt) {
        super.readNetworkData(nbt);
        this.researchingAtmosphere = nbt.func_74767_n("researchingAtmosphere");
        this.researchingDistance = nbt.func_74767_n("researchingDistance");
        this.researchingMass = nbt.func_74767_n("researchingMass");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.inventory.write(nbt);
        nbt.func_74757_a("researchingAtmosphere", this.researchingAtmosphere);
        nbt.func_74757_a("researchingDistance", this.researchingDistance);
        nbt.func_74757_a("researchingMass", this.researchingMass);
        nbt.func_74768_a("atmosphereProgress", this.atmosphereProgress);
        nbt.func_74768_a("distanceProgress", this.distanceProgress);
        nbt.func_74768_a("massProgress", this.massProgress);
        return nbt;
    }

    protected void writeNetworkData(CompoundNBT nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74757_a("researchingAtmosphere", this.researchingAtmosphere);
        nbt.func_74757_a("researchingDistance", this.researchingDistance);
        nbt.func_74757_a("researchingMass", this.researchingMass);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
        this.onInventoryUpdated();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_174879_c.func_177951_i((Vector3i)new BlockPos(player.func_213303_ch())) < 4096.0;
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }
}

