/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;

public class TileBiomeScanner
extends TileMultiPowerConsumer {
    private static final Object[][][] structure = new Object[][][]{{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, Character.valueOf('c'), null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, {{null, null, null, null, null}, {null, null, null, null, null}, {null, null, LibVulpesBlocks.motors, null, null}, {null, null, null, null, null}, {null, null, null, null, null}}, {{null, "blockAluminum", "blockAluminum", "blockAluminum", null}, {"blockAluminum", "blockAluminum", AdvancedRocketryBlocks.blockStructureTower, "blockAluminum", "blockAluminum"}, {"blockAluminum", AdvancedRocketryBlocks.blockStructureTower, LibVulpesBlocks.blockStructureBlock, AdvancedRocketryBlocks.blockStructureTower, "blockAluminum"}, {"blockAluminum", "blockAluminum", AdvancedRocketryBlocks.blockStructureTower, "blockAluminum", "blockAluminum"}, {null, "blockAluminum", "blockAluminum", "blockAluminum", null}}, {{Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150451_bX, Blocks.field_150350_a, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}, {Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a, Blocks.field_150350_a}}};

    public TileBiomeScanner() {
        super(AdvancedRocketryTileEntityType.TILE_BIOME_SCANNER);
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> list = new LinkedList<ModuleBase>();
        boolean suitable = true;
        for (int y = this.func_174877_v().func_177956_o() - 4; y > 0; --y) {
            if (this.field_145850_b.func_175623_d(new BlockPos(this.func_174877_v().func_177958_n(), y, this.func_174877_v().func_177952_p()))) continue;
            suitable = false;
            break;
        }
        if (this.field_145850_b.field_72995_K) {
            list.add((ModuleBase)new ModuleImage(24, 14, TextureResources.earthCandyIcon));
            ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
            if (suitable && !SpaceObjectManager.WARPDIMID.equals((Object)spaceObject.getOrbitingPlanetId())) {
                DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(spaceObject.getOrbitingPlanetId());
                LinkedList<ModuleText> list2 = new LinkedList<ModuleText>();
                if (properties.isGasGiant()) {
                    list2.add(new ModuleText(32, 16, LibVulpes.proxy.getLocalizedString("msg.biomescanner.gas"), 0x202020));
                } else if (properties.isStar()) {
                    list2.add(new ModuleText(32, 16, LibVulpes.proxy.getLocalizedString("msg.biomescanner.star"), 0x202020));
                } else {
                    int i = 0;
                    if (properties.getId() == DimensionManager.overworldProperties.getId()) {
                        Iterator<Biome> itr = AdvancedRocketryBiomes.getAllBiomes();
                        while (itr.hasNext()) {
                            Biome biome = itr.next();
                            if (biome == null) continue;
                            list2.add(new ModuleText(32, 16 + 12 * i++, AdvancedRocketry.proxy.getNameFromBiome(biome), 0x202020));
                        }
                    } else {
                        for (Biome biome : properties.getBiomes()) {
                            list2.add(new ModuleText(32, 16 + 12 * i++, AdvancedRocketry.proxy.getNameFromBiome(biome), 0x202020));
                        }
                    }
                }
                ModuleContainerPan pan = new ModuleContainerPan(0, 16, list2, new LinkedList(), null, 148, 110, 0, -64, 0, 1000);
                list.add((ModuleBase)pan);
            } else {
                list.add((ModuleBase)new ModuleText(32, 16, TextFormatting.OBFUSCATED + "Foxes, that is all", 0x202020));
            }
        }
        return list;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -3, -5), this.field_174879_c.func_177982_a(5, 3, 5));
    }

    public String getMachineName() {
        return "block.advancedrocketry.biomescanner";
    }
}

