/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.modules.ModulePlanetSelector;
import zmaster587.advancedRocketry.util.ITilePlanetSystemSelectable;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.util.INetworkMachine;

public class TilePlanetSelector
extends TilePointer
implements ISelectionNotify,
IModularInventory,
IProgressBar,
INetworkMachine {
    protected ModulePlanetSelector container;
    public static final int certaintyDataValue = 5000;
    DimensionProperties dimCache;
    int[] cachedProgressValues = new int[]{-1, -1, -1};

    public TilePlanetSelector() {
        super(AdvancedRocketryTileEntityType.TILE_PLANET_SELECTOR);
    }

    public void onSelectionConfirmed(Object sender) {
        TileEntity tile = this.getMasterBlock();
        if (tile instanceof ITilePlanetSystemSelectable) {
            ((ITilePlanetSystemSelectable)tile).setSelectedPlanetId(this.container.getSelectedSystem());
        }
        this.onSelected(sender);
    }

    public void onSelected(Object sender) {
        this.selectSystem(this.container.getSelectedSystem());
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    private void selectSystem(ResourceLocation id) {
        this.dimCache = Constants.INVALID_PLANET.equals((Object)id) ? null : DimensionManager.getInstance().getDimensionProperties(this.container.getSelectedSystem());
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        DimensionProperties props = DimensionManager.getEffectiveDimId(player.field_70170_p, new BlockPos(player.func_213303_ch()));
        this.container = new ModulePlanetSelector(props != null ? props.getStarId() : DimensionManager.getSol().getId(), TextureResources.starryBG, this, true);
        this.container.setOffset(1000, 1000);
        modules.add((ModuleBase)this.container);
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public float getNormallizedProgress(int id) {
        return 0.0f;
    }

    public void setProgress(int id, int progress) {
        this.cachedProgressValues[id] = progress;
    }

    public int getProgress(int id) {
        if (!this.field_145850_b.field_72995_K) {
            return 25;
        }
        return this.cachedProgressValues[id];
    }

    public int getTotalProgress(int id) {
        if (this.dimCache == null) {
            return 50;
        }
        if (id == 0) {
            return this.dimCache.getAtmosphereDensity() / 16;
        }
        if (id == 1) {
            return this.dimCache.orbitalDist / 16;
        }
        return (int)(this.dimCache.gravitationalMultiplier * 50.0f);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT comp = new CompoundNBT();
        this.writeToNBTHelper(comp);
        this.writeAdditionalNBT(comp);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, comp);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.readAdditionalNBT(pkt.func_148857_g());
    }

    public void writeAdditionalNBT(CompoundNBT nbt) {
        if (this.getMasterBlock() != null) {
            List<ResourceLocation> list = ((ITilePlanetSystemSelectable)this.getMasterBlock()).getVisiblePlanets();
            ListNBT nbtList = new ListNBT();
            for (ResourceLocation planet : list) {
                nbtList.add((Object)StringNBT.func_229705_a_((String)planet.toString()));
            }
            nbt.func_218657_a("visiblePlanets", (INBT)nbtList);
        }
    }

    public void readAdditionalNBT(CompoundNBT nbt) {
        if (this.container != null) {
            ListNBT intArray = nbt.func_150295_c("visiblePlanets", 8);
            for (int i = 0; i < intArray.size(); ++i) {
                this.container.setPlanetAsKnown(new ResourceLocation(intArray.func_150307_f(i)));
            }
        }
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 0) {
            out.func_192572_a(this.container.getSelectedSystem());
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == 0) {
            nbt.func_74778_a("id", in.func_192575_l().toString());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == 0) {
            ResourceLocation dimId = new ResourceLocation(nbt.func_74779_i("id"));
            this.container.setSelectedSystem(dimId);
            this.selectSystem(dimId);
            this.func_70296_d();
        }
    }

    public void onSystemFocusChanged(Object sender) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULARFULLSCREEN;
    }
}

