/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityItemAbducted;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleNumericTextbox;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileRailgun
extends TileMultiPowerConsumer
implements IInventory,
ILinkableTile,
IGuiCallback {
    private EmbeddedInventory inv = new EmbeddedInventory(1);
    public long recoil;
    int minStackTransferSize = 1;
    ModuleNumericTextbox textBox;
    ZUtils.RedstoneState state;
    ModuleRedstoneOutputButton redstoneControl;
    static final Object[][][] structure = new Object[][][]{{{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, new ResourceLocation("forge", "coils/copper"), LibVulpesBlocks.blockStructureBlock, new ResourceLocation("forge", "coils/copper"), null, null, null}, {null, null, null, null, new ResourceLocation("forge", "coils/copper"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "blocks/steel"), null, null, null, null}, {null, null, null, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("forge", "blocks/titanium"), LibVulpesBlocks.blockAdvStructureBlock, null, null, null}, {null, null, new ResourceLocation("forge", "blocks/steel"), new ResourceLocation("forge", "blocks/titanium"), new ResourceLocation("forge", "blocks/titanium"), new ResourceLocation("forge", "blocks/titanium"), new ResourceLocation("forge", "blocks/steel"), null, null}, {null, null, null, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("forge", "blocks/titanium"), LibVulpesBlocks.blockAdvStructureBlock, null, null, null}, {null, null, null, null, new ResourceLocation("forge", "blocks/steel"), null, null, null, null}, {null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null}}, {{new ResourceLocation("forge", "blocks/steel"), null, null, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), null, null, new ResourceLocation("forge", "blocks/steel")}, {null, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), Character.valueOf('I'), Character.valueOf('c'), Character.valueOf('O'), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, null}, {null, new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), null}, {new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs")}, {new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.motors, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs")}, {new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs")}, {null, new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), null}, {null, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), Character.valueOf('P'), Character.valueOf('P'), Character.valueOf('P'), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, null}, {new ResourceLocation("forge", "blocks/steel"), null, null, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), null, null, new ResourceLocation("forge", "blocks/steel")}}};

    public TileRailgun() {
        super(AdvancedRocketryTileEntityType.TILE_RAILGUN);
        this.powerPerTick = 100000;
        this.redstoneControl = new ModuleRedstoneOutputButton(174, 4, "", (IButtonInventory)this);
        this.state = ZUtils.RedstoneState.OFF;
        this.redstoneControl.setRedstoneState(this.state);
    }

    protected int requiredPowerPerTick() {
        BlockPos pos = this.getDestPosition();
        if (pos != null) {
            int distance = (int)Math.sqrt(Math.pow(pos.func_177958_n() - this.field_174879_c.func_177958_n(), 2.0) + Math.pow(pos.func_177952_p() - this.field_174879_c.func_177952_p(), 2.0));
            if (this.getDestDimId() == ZUtils.getDimensionIdentifier((World)this.field_145850_b)) {
                distance = distance * 10 + 50000;
            }
            return Math.min(distance, super.requiredPowerPerTick());
        }
        return super.requiredPowerPerTick();
    }

    public boolean shouldHideBlock(World world, BlockPos pos, BlockState tile) {
        return true;
    }

    private ResourceLocation getDestDimId() {
        ItemStack stack = this.inv.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof ItemLinker) {
            return ItemLinker.getDimId((ItemStack)stack);
        }
        return Constants.INVALID_PLANET;
    }

    private BlockPos getDestPosition() {
        ItemStack stack = this.inv.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof ItemLinker && ItemLinker.isSet((ItemStack)stack)) {
            return ItemLinker.getMasterCoords((ItemStack)stack);
        }
        return null;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        modules.add(new ModuleSlotArray(40, 40, (IInventory)this, 0, 1));
        if (this.field_145850_b.field_72995_K) {
            this.textBox = new ModuleNumericTextbox((IGuiCallback)this, 80, 40, 32, 12, 2);
            this.textBox.setText(String.valueOf(this.minStackTransferSize));
            modules.add(new ModuleText(60, 25, LibVulpes.proxy.getLocalizedString("msg.railgun.transfermin"), 0x2B2B2B));
            modules.add(this.textBox);
        }
        modules.add(this.redstoneControl);
        return modules;
    }

    public void onLoad() {
        super.onLoad();
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            ServerWorld serverworld = (ServerWorld)this.field_145850_b;
            serverworld.func_217458_b(new ChunkPos((BlockPos)this.func_174877_v()).field_77276_a, new ChunkPos((BlockPos)this.func_174877_v()).field_77275_b, false);
        }
    }

    public void onInventoryUpdated() {
        if (this.itemInPorts.isEmpty()) {
            this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
    }

    public void onInventoryButtonPressed(ModuleButton buttonId) {
        super.onInventoryButtonPressed(buttonId);
        if (buttonId == this.redstoneControl) {
            this.state = this.redstoneControl.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 5));
        }
    }

    protected void onRunningPoweredTick() {
    }

    public void useEnergy(int amt) {
        if (!this.field_145850_b.field_72995_K && this.enabled && this.isRedstoneStateSatisfied() && this.attemptCargoTransfer()) {
            super.useEnergy(amt);
        }
    }

    public boolean isRunning() {
        return this.isComplete();
    }

    private boolean isRedstoneStateSatisfied() {
        if (this.state == ZUtils.RedstoneState.OFF) {
            return true;
        }
        boolean powered = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        return this.state == ZUtils.RedstoneState.ON && powered || !powered && this.state == ZUtils.RedstoneState.INVERTED;
    }

    private boolean attemptCargoTransfer() {
        TileEntity tile;
        ServerWorld world;
        ResourceLocation dimId;
        BlockPos pos;
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack tfrStack = null;
        IInventory inv2 = null;
        int index = 0;
        block0: for (IInventory inv : this.itemInPorts) {
            for (int i = inv.func_70302_i_() - 1; i >= 0; --i) {
                tfrStack = inv.func_70301_a(i);
                if (tfrStack != null && inv.func_70301_a(i).func_190916_E() >= this.minStackTransferSize) {
                    inv2 = inv;
                    index = i;
                    break block0;
                }
                tfrStack = null;
            }
        }
        if (tfrStack != null && (pos = this.getDestPosition()) != null && !Constants.INVALID_PLANET.equals((Object)(dimId = this.getDestDimId())) && (world = ZUtils.getWorld((ResourceLocation)dimId)) != null && (tile = world.func_175625_s(pos)) instanceof TileRailgun && ((TileRailgun)tile).canRecieveCargo(tfrStack) && (PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(ZUtils.getDimensionIdentifier((World)this.field_145850_b), DimensionManager.getEffectiveDimId((World)world, pos).getId()) || DimensionManager.getEffectiveDimId((World)world, pos).getId() == DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
            ((TileRailgun)tile).onRecieveCargo(tfrStack);
            inv2.func_70299_a(index, ItemStack.field_190927_a);
            inv2.func_70296_d();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
            Direction dir = RotatableBlock.getFront((BlockState)world.func_180495_p(pos));
            EntityItemAbducted ent = new EntityItemAbducted(this.field_145850_b, (float)(this.field_174879_c.func_177958_n() - 2 * dir.func_82601_c()) + 0.5f, this.field_174879_c.func_177956_o() + 5, (float)(this.field_174879_c.func_177952_p() - 2 * dir.func_82599_e()) + 0.5f, tfrStack);
            this.field_145850_b.func_217376_c((Entity)ent);
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 3), (World)this.field_145850_b, (int)(this.field_174879_c.func_177958_n() - dir.func_82601_c()), (int)(this.field_174879_c.func_177956_o() + 5), (int)(this.field_174879_c.func_177952_p() - dir.func_82599_e()), (double)64.0);
            return true;
        }
        return false;
    }

    public boolean canRecieveCargo(ItemStack stack) {
        for (IInventory inv : this.itemOutPorts) {
            if (ZUtils.numEmptySlots((IInventory)inv) <= 0) continue;
            return true;
        }
        return false;
    }

    public void onRecieveCargo(ItemStack stack) {
        for (IInventory inv : this.itemOutPorts) {
            if (!ZUtils.doesInvHaveRoom((ItemStack)stack, (IInventory)inv)) continue;
            ZUtils.mergeInventory((ItemStack)stack, (IInventory)inv);
            break;
        }
    }

    public String getMachineName() {
        return "block.advancedrocketry.railgun";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 5), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 5), (double)(this.field_174879_c.func_177958_n() + 5), (double)(this.field_174879_c.func_177956_o() + 10), (double)(this.field_174879_c.func_177952_p() + 5));
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inv.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack j) {
        this.inv.func_70299_a(i, j);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return stack == null || stack.func_77973_b() instanceof ItemLinker;
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        ItemLinker.setDimId((ItemStack)item, (ResourceLocation)ZUtils.getDimensionIdentifier((World)world));
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.linker.program"), Util.field_240973_b_);
        }
        return true;
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        return false;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.inv.write(nbt);
        nbt.func_74768_a("minTfrSize", this.minStackTransferSize);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        return nbt;
    }

    public void func_230337_a_(BlockState blkstate, CompoundNBT nbt) {
        super.func_230337_a_(blkstate, nbt);
        this.inv.readFromNBT(nbt);
        this.minStackTransferSize = nbt.func_74762_e("minTfrSize");
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 4) {
            out.writeInt(this.minStackTransferSize);
        } else if (id == 5) {
            out.writeByte(this.state.ordinal());
        } else {
            super.writeDataToNetwork(out, id);
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == 4) {
            nbt.func_74768_a("minTransferSize", in.readInt());
        } else if (packetId == 5) {
            nbt.func_74774_a("state", in.readByte());
        } else {
            super.readDataFromNetwork(in, packetId, nbt);
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (side.isClient()) {
            if (id == 3) {
                Direction dir = RotatableBlock.getFront((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c));
                LibVulpes.proxy.playSound(this.field_145850_b, this.field_174879_c, AudioRegistry.railgunFire, SoundCategory.BLOCKS, Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.BLOCKS), 0.975f + this.field_145850_b.field_73012_v.nextFloat() * 0.05f);
                this.recoil = this.field_145850_b.func_82737_E();
            }
        } else if (id == 4) {
            this.minStackTransferSize = nbt.func_74762_e("minTransferSize");
        } else if (id == 5) {
            this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        } else {
            super.useNetworkData(player, side, id, nbt);
        }
    }

    public void onModuleUpdated(ModuleBase module) {
        if (module == this.textBox) {
            this.minStackTransferSize = this.textBox.getText().isEmpty() ? 1 : MathHelper.func_76125_a((int)Integer.parseInt(this.textBox.getText()), (int)1, (int)64);
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
        }
    }

    protected void writeNetworkData(CompoundNBT nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74774_a("state", (byte)this.state.ordinal());
        nbt.func_74768_a("minTfrSize", this.minStackTransferSize);
    }

    protected void readNetworkData(CompoundNBT nbt) {
        super.readNetworkData(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        this.minStackTransferSize = nbt.func_74762_e("minTfrSize");
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }
}

