/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityElevatorCapsule;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.DimensionBlockPosition;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileSpaceElevator
extends TileMultiPowerConsumer
implements ILinkableTile,
IModularInventory,
ITickableTileEntity {
    boolean openFullScreen = false;
    Object[][][] structure = new Object[][][]{{{null, null, null, Character.valueOf('P'), Character.valueOf('c'), Character.valueOf('P'), null, null, null}, {new ResourceLocation("forge", "blocks/steel"), null, null, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), null, null, new ResourceLocation("forge", "blocks/steel")}, {null, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, null}, {null, new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), null}, {new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs")}, {new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.motors, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs")}, {new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs")}, {null, new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), null}, {null, LibVulpesBlocks.blockAdvStructureBlock, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), LibVulpesBlocks.blockAdvStructureBlock, null}, {new ResourceLocation("forge", "blocks/steel"), null, null, new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), new ResourceLocation("minecraft", "slabs"), null, null, new ResourceLocation("forge", "blocks/steel")}}};
    EntityElevatorCapsule capsule = null;
    boolean firstTick = true;
    DimensionBlockPosition dimBlockPos;
    private ModuleText landingPadDisplayText = new ModuleText(256, 16, "", 65280, 2.0f);
    private static final byte SUMMON_PACKET = 2;
    private static final int BUTTON_ID_OFFSET = 5;

    public TileSpaceElevator() {
        super(AdvancedRocketryTileEntityType.TILE_SPACE_ELEVATOR);
        this.landingPadDisplayText.setColor(65280);
        this.dimBlockPos = null;
    }

    public void deconstructMultiBlock(World world, BlockPos destroyedPos, boolean blockBroken, BlockState state) {
        TileEntity tile;
        ServerWorld otherPlanet;
        super.deconstructMultiBlock(world, destroyedPos, blockBroken, state);
        EntityElevatorCapsule e = this.getCapsuleOnLine();
        if (e != null) {
            e.func_70106_y();
        }
        if ((otherPlanet = ZUtils.getWorld((ResourceLocation)this.dimBlockPos.dimid)) == null) {
            ZUtils.initDimension((ResourceLocation)this.dimBlockPos.dimid);
            otherPlanet = ZUtils.getWorld((ResourceLocation)this.dimBlockPos.dimid);
        }
        if (otherPlanet != null && (tile = otherPlanet.func_175625_s(this.dimBlockPos.pos.getBlockPos())) instanceof TileSpaceElevator) {
            ((TileSpaceElevator)tile).updateTetherLinkPosition(this.dimBlockPos, null);
            this.updateTetherLinkPosition(new DimensionBlockPosition(ZUtils.getDimensionIdentifier((World)world), new HashedBlockPosition(this.func_174877_v())), null);
        }
    }

    public Object[][][] getStructure() {
        return this.structure;
    }

    public String getMachineName() {
        return this.getModularInventoryName();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-5, -300, -5), this.field_174879_c.func_177982_a(5, 3000, 5));
    }

    public boolean shouldHideBlock(World world, BlockPos pos, BlockState tile) {
        return true;
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        if (ID == GuiHandler.guiId.MODULAR.ordinal()) {
            modules.add(new ModuleButton(50, 47, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.button.summon"), (IButtonInventory)this, TextureResources.buttonBuild, 80, 18));
            if (this.isTetherConnected()) {
                modules.add(new ModuleText(30, 23, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.warning.anchored0"), 0x2D2D2D));
                modules.add(new ModuleText(30, 35, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.warning.anchored1"), 0x2D2D2D));
            } else {
                modules.add(new ModuleText(30, 23, LibVulpes.proxy.getLocalizedString("msg.spaceElevator.warning.unanchored"), 0x2D2D2D));
            }
        }
        return modules;
    }

    public static boolean isDestinationValid(ResourceLocation destinationDimensionID, DimensionBlockPosition pos, HashedBlockPosition myPos, ResourceLocation myDimensionID) {
        if (pos == null || pos.pos == null) {
            return false;
        }
        if (DimensionManager.getInstance().isSpaceDimension(myDimensionID) && SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPos.getBlockPos()) != null) {
            return PlanetaryTravelHelper.isTravelWithinGeostationaryOrbit((SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPos.getBlockPos()), pos.dimid);
        }
        if (DimensionManager.getInstance().isSpaceDimension(pos.dimid) && SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos.pos.getBlockPos()) != null) {
            return PlanetaryTravelHelper.isTravelWithinGeostationaryOrbit((SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos.pos.getBlockPos()), myDimensionID);
        }
        return false;
    }

    public static boolean wouldTetherBreakOnConnect(ResourceLocation destinationDimensionID, DimensionBlockPosition pos, HashedBlockPosition myPos, ResourceLocation myDimensionID) {
        SpaceStationObject spaceStation = DimensionManager.getInstance().isSpaceDimension(myDimensionID) ? (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPos.getBlockPos()) : (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos.pos.getBlockPos());
        return spaceStation != null && spaceStation.wouldStationBreakTether();
    }

    public boolean attemptLaunch() {
        if (!(this.isComplete() && this.enabled && this.hasEnergy(50000))) {
            return false;
        }
        this.useEnergy(50000);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onInventoryButtonPressed(ModuleButton button) {
        int buttonId;
        int n = buttonId = button.getAdditionalData() == null ? -1 : (Integer)button.getAdditionalData();
        if (buttonId == 1) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
        }
        if (buttonId >= 5) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)buttonId));
        }
        super.onInventoryButtonPressed(button);
    }

    public void notifyLanded(EntityElevatorCapsule e) {
        if (this.capsule != null && this.capsule != e && this.capsule.func_70089_S()) {
            e.func_70106_y();
        } else {
            this.capsule = e;
            this.capsule.setSourceTile(new DimensionBlockPosition(ZUtils.getDimensionIdentifier((World)this.field_145850_b), new HashedBlockPosition(this.field_174879_c)));
            this.capsule.setDst(this.dimBlockPos);
        }
        int yOffset = this.isAnchorOnSpaceStation() ? -5 : 1;
        this.capsule.func_70107_b(this.getLandingLocationX(), this.func_174877_v().func_177956_o() + yOffset, this.getLandingLocationZ());
        Direction facing = RotatableBlock.getFront((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        switch (facing) {
            case EAST: {
                this.capsule.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                this.capsule.field_70177_z = 90.0f;
                break;
            }
            case NORTH: {
                this.capsule.field_70177_z = 270.0f;
                break;
            }
            default: {
                this.capsule.field_70177_z = 0.0f;
            }
        }
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        super.writeDataToNetwork(out, id);
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == 2) {
            this.summonCapsule();
        } else if (id == 5) {
            this.dimBlockPos = null;
            this.capsule.setDst(null);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
        super.useNetworkData(player, side, id, nbt);
    }

    public EntityElevatorCapsule getCapsuleOnLine() {
        if (this.capsule != null && !this.capsule.func_70089_S()) {
            this.capsule = null;
        }
        double capsulePosX = this.getLandingLocationX();
        double capsulePosZ = this.getLandingLocationZ();
        for (EntityElevatorCapsule e : this.field_145850_b.func_217357_a(EntityElevatorCapsule.class, new AxisAlignedBB(capsulePosX - 3.0, (double)(this.func_174877_v().func_177956_o() - 1), capsulePosZ - 3.0, capsulePosX + 3.0, EntityElevatorCapsule.MAX_HEIGHT, capsulePosZ + 3.0))) {
            if (e.isInMotion() || !e.func_70089_S()) continue;
            this.capsule = e;
        }
        return this.capsule;
    }

    public double getLandingLocationX() {
        Direction facing = RotatableBlock.getFront((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        return (double)(this.func_174877_v().func_177958_n() + facing.func_82601_c() * -5 - facing.func_82599_e() * 2) + 0.5;
    }

    public double getLandingLocationZ() {
        Direction facing = RotatableBlock.getFront((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        return (double)(this.func_174877_v().func_177952_p() + facing.func_82601_c() * 2 + facing.func_82599_e() * -5) + 0.5;
    }

    public void summonCapsule() {
        if (this.getCapsuleOnLine() != null) {
            return;
        }
        this.capsule = new EntityElevatorCapsule(this.field_145850_b);
        Direction facing = RotatableBlock.getFront((BlockState)this.field_145850_b.func_180495_p(this.func_174877_v()));
        switch (facing) {
            case EAST: {
                this.capsule.field_70177_z = 180.0f;
                break;
            }
            case SOUTH: {
                this.capsule.field_70177_z = 90.0f;
                break;
            }
            case NORTH: {
                this.capsule.field_70177_z = 270.0f;
                break;
            }
            default: {
                this.capsule.field_70177_z = 0.0f;
            }
        }
        double capsulePosX = this.getLandingLocationX();
        double capsulePosZ = this.getLandingLocationZ();
        int yOffset = this.isAnchorOnSpaceStation() ? -4 : 1;
        this.capsule.func_70107_b(capsulePosX, this.func_174877_v().func_177956_o() + yOffset, capsulePosZ);
        this.capsule.setDst(this.dimBlockPos);
        this.capsule.setSourceTile(new DimensionBlockPosition(ZUtils.getDimensionIdentifier((World)this.field_145850_b), new HashedBlockPosition(this.func_174877_v())));
        this.field_145850_b.func_217376_c((Entity)this.capsule);
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, PlayerEntity player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        ItemLinker.setDimId((ItemStack)item, (ResourceLocation)ZUtils.getDimensionIdentifier((World)world));
        if (this.dimBlockPos != null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.spaceelevator.linkcannotchangeerror"), Util.field_240973_b_);
            return false;
        }
        if (!world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.linker.program"), Util.field_240973_b_);
        }
        return true;
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, PlayerEntity player, World myWorld) {
        if (!myWorld.field_72995_K) {
            TileEntity tile;
            ResourceLocation dimid = ItemLinker.getDimId((ItemStack)item);
            BlockPos pos = ItemLinker.getMasterCoords((ItemStack)item);
            DimensionBlockPosition dimPos = new DimensionBlockPosition(dimid, new HashedBlockPosition(pos));
            if (dimPos.dimid == ZUtils.getDimensionIdentifier((World)myWorld)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.spaceelevator.samedimensionerror"), Util.field_240973_b_);
                return false;
            }
            ServerWorld world = ZUtils.getWorld((ResourceLocation)dimPos.dimid);
            if (world == null) {
                ZUtils.initDimension((ResourceLocation)dimPos.dimid);
                world = ZUtils.getWorld((ResourceLocation)dimPos.dimid);
            }
            if (!TileSpaceElevator.isDestinationValid(dimPos.dimid, dimPos, new HashedBlockPosition(this.func_174877_v()), ZUtils.getDimensionIdentifier((World)myWorld))) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.spaceElevator.linkNotGeostationaryError"), Util.field_240973_b_);
                return false;
            }
            if (TileSpaceElevator.wouldTetherBreakOnConnect(dimPos.dimid, dimPos, new HashedBlockPosition(this.func_174877_v()), ZUtils.getDimensionIdentifier((World)myWorld))) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.spaceElevator.tetherWouldBreakError"), Util.field_240973_b_);
                return false;
            }
            if (this.dimBlockPos != null) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.spaceElevator.linkCannotChangeError"), Util.field_240973_b_);
                return false;
            }
            if (world != null && (tile = world.func_175625_s(dimPos.pos.getBlockPos())) instanceof TileSpaceElevator) {
                this.updateTetherLinkPosition(new DimensionBlockPosition(ZUtils.getDimensionIdentifier((World)this.field_145850_b), new HashedBlockPosition(this.func_174877_v())), dimPos);
                ((TileSpaceElevator)tile).updateTetherLinkPosition(dimPos, new DimensionBlockPosition(ZUtils.getDimensionIdentifier((World)this.field_145850_b), new HashedBlockPosition(this.func_174877_v())));
                player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.spaceElevator.newDstAdded"), Util.field_240973_b_);
                if (this.capsule != null) {
                    this.capsule.setDst(this.dimBlockPos);
                }
                this.func_70296_d();
                world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                return true;
            }
        }
        return false;
    }

    public boolean isAnchorOnSpaceStation() {
        return DimensionManager.getInstance().isSpaceDimension(this.field_145850_b);
    }

    public void updateTetherLinkPosition(DimensionBlockPosition myPosition, DimensionBlockPosition dimensionBlockPosition) {
        if (DimensionManager.getInstance().isSpaceDimension(myPosition.dimid) && SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()) != null) {
            if (dimensionBlockPosition != null) {
                SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()).setDeltaRotation(0.0, Direction.EAST);
                SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()).setDeltaRotation(0.0, Direction.UP);
                SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()).setDeltaRotation(0.0, Direction.NORTH);
            }
            SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(myPosition.pos.getBlockPos()).setIsAnchored(dimensionBlockPosition != null);
        }
        this.dimBlockPos = dimensionBlockPosition;
    }

    public boolean isTetherConnected() {
        return this.dimBlockPos != null;
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.spaceelevatorcontroller";
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        return true;
    }

    public void writeNetworkData(CompoundNBT nbt) {
        if (this.dimBlockPos != null) {
            nbt.func_74778_a("dstDimId", this.dimBlockPos.dimid.toString());
            nbt.func_74783_a("dstPos", new int[]{this.dimBlockPos.pos.x, this.dimBlockPos.pos.y, this.dimBlockPos.pos.z});
        }
        super.writeNetworkData(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
    }

    public void readNetworkData(CompoundNBT nbt) {
        super.readNetworkData(nbt);
        if (nbt.func_74764_b("dstDimId")) {
            ResourceLocation id = new ResourceLocation(nbt.func_74779_i("dstDimId"));
            int[] pos = nbt.func_74759_k("dstPos");
            this.dimBlockPos = new DimensionBlockPosition(id, new HashedBlockPosition(pos[0], pos[1], pos[2]));
        } else {
            this.dimBlockPos = null;
        }
        this.landingPadDisplayText.setText(this.dimBlockPos != null ? this.dimBlockPos.toString() : LibVulpes.proxy.getLocalizedString("msg.label.noneselected"));
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        GuiHandler.guiId guiType = this.openFullScreen ? GuiHandler.guiId.MODULARFULLSCREEN : this.getModularInvType();
        this.openFullScreen = false;
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(guiType.ordinal(), player), (IModularInventory)this, guiType);
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

