/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.util.ZUtils;

public class TileWarpCore
extends TileMultiBlock {
    private SpaceStationObject station;
    public static final Object[][][] structure = new Object[][][]{{{new ResourceLocation("advancedrocketry", "warpcorerim"), new ResourceLocation("advancedrocketry", "warpcorerim"), new ResourceLocation("advancedrocketry", "warpcorerim")}, {new ResourceLocation("advancedrocketry", "warpcorerim"), Character.valueOf('I'), new ResourceLocation("advancedrocketry", "warpcorerim")}, {new ResourceLocation("advancedrocketry", "warpcorerim"), new ResourceLocation("advancedrocketry", "warpcorerim"), new ResourceLocation("advancedrocketry", "warpcorerim")}}, {{null, new BlockMeta(LibVulpesBlocks.blockStructureBlock), null}, {new BlockMeta(LibVulpesBlocks.blockStructureBlock), new ResourceLocation("advancedrocketry", "warpcore"), new BlockMeta(LibVulpesBlocks.blockStructureBlock)}, {null, new BlockMeta(LibVulpesBlocks.blockStructureBlock), null}}, {{new ResourceLocation("advancedrocketry", "warpcorerim"), Character.valueOf('c'), new ResourceLocation("advancedrocketry", "warpcorerim")}, {new ResourceLocation("advancedrocketry", "warpcorerim"), new ResourceLocation("advancedrocketry", "warpcore"), new ResourceLocation("advancedrocketry", "warpcorerim")}, {new ResourceLocation("advancedrocketry", "warpcorerim"), new ResourceLocation("advancedrocketry", "warpcorerim"), new ResourceLocation("advancedrocketry", "warpcorerim")}}};

    public TileWarpCore() {
        super(AdvancedRocketryTileEntityType.TILE_WARP_CORE);
    }

    private SpaceStationObject getSpaceObject() {
        ISpaceObject object;
        if (this.station == null && ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_145850_b)) && (object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceStationObject) {
            this.station = (SpaceStationObject)object;
        }
        return this.station;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public boolean shouldHideBlock(World world, BlockPos pos, BlockState tile) {
        return pos.compareTo((Vector3i)this.field_174879_c) == 0;
    }

    public void onInventoryUpdated() {
        if (this.itemInPorts.isEmpty()) {
            this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        if (this.getSpaceObject() == null || this.getSpaceObject().getMaxFuelAmount() - this.getSpaceObject().getFuelAmount() < (Integer)ARConfiguration.getCurrentConfig().fuelPointsPerDilithium.get()) {
            return;
        }
        for (IInventory inv : this.itemInPorts) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                int amt = 0;
                if (stack.func_190926_b() || !ItemTags.func_199903_a().func_199913_a((Object)stack.func_77973_b()).stream().anyMatch(value -> value.func_110623_a().equalsIgnoreCase("gems/dilithium"))) continue;
                int stackSize = stack.func_190916_E();
                if (!this.field_145850_b.field_72995_K) {
                    amt = this.getSpaceObject().addFuel((Integer)ARConfiguration.getCurrentConfig().fuelPointsPerDilithium.get());
                }
                inv.func_70298_a(i, amt / (Integer)ARConfiguration.getCurrentConfig().fuelPointsPerDilithium.get());
                inv.func_70296_d();
                if (this.getSpaceObject().getMaxFuelAmount() - this.getSpaceObject().getFuelAmount() >= (Integer)ARConfiguration.getCurrentConfig().fuelPointsPerDilithium.get()) continue;
                return;
            }
        }
    }

    public String getMachineName() {
        return "block.advancedrocketry.warpcore";
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
    }
}

