/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.energy;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerProducer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.MultiBattery;
import zmaster587.libVulpes.util.ZUtils;

public class TileBlackHoleGenerator
extends TileMultiPowerProducer
implements ITickableTileEntity {
    static final Object[][][] structure = new Object[][][]{{{null, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, null}}, {{null, Character.valueOf('c'), null}, {Character.valueOf('*'), LibVulpesBlocks.blockAdvStructureBlock, Character.valueOf('*')}, {null, Character.valueOf('*'), null}}, {{null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, null}}, {{null, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, null}}, {{null, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, null}}};
    int powerMadeLastTick;
    int prevPowerMadeLastTick;
    ModuleText textModule = new ModuleText(40, 20, LibVulpes.proxy.getLocalizedString("msg.microwaverec.notgenerating"), 0x2B2B2B);
    boolean initialCheck = false;
    private long last_usage;

    public TileBlackHoleGenerator() {
        super(AdvancedRocketryTileEntityType.TILE_BLACK_HOLE_GENERATOR);
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        modules.add(this.textModule);
        return modules;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(0.0, 2000.0, 0.0).func_72317_d(0.0, 1000.0, 0.0);
    }

    public boolean shouldHideBlock(World world, BlockPos pos, BlockState tile) {
        return world.func_180495_p(pos).func_177230_c() == AdvancedRocketryBlocks.blockBlackHoleGenerator;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List blocks = super.getAllowableWildCardBlocks();
        blocks.addAll(TileMultiBlock.getMapping((char)'I'));
        blocks.add(new BlockMeta(LibVulpesBlocks.blockAdvStructureBlock));
        blocks.addAll(TileMultiBlock.getMapping((char)'p'));
        return blocks;
    }

    public String getMachineName() {
        return "block.advancedrocketry.blackholegenerator";
    }

    public int getPowerMadeLastTick() {
        return this.powerMadeLastTick;
    }

    public void onInventoryUpdated() {
        super.onInventoryUpdated();
        this.attemptFire();
    }

    private ItemStack consumeItem() {
        for (IInventory i : this.getItemInPorts()) {
            for (int slot = 0; slot < i.func_70302_i_(); ++slot) {
                ItemStack stack = i.func_70301_a(slot);
                if (stack.func_190926_b()) continue;
                return i.func_70298_a(slot, 1);
            }
        }
        return ItemStack.field_190927_a;
    }

    private int getTimeFromStack(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> i : ARConfiguration.getCurrentConfig().blackHoleGeneratorBlocks.entrySet()) {
            if (i.getKey().func_77973_b() != stack.func_77973_b() || i.getKey().func_77952_i() != stack.func_77952_i()) continue;
            return i.getValue();
        }
        return (Integer)ARConfiguration.getCurrentConfig().defaultItemTimeBlackHole.get();
    }

    private void attemptFire() {
        ItemStack stack;
        if (this.enabled && this.isAroundBlackHole() && this.last_usage <= this.field_145850_b.func_82737_E() && !this.isEnergyFull() && !(stack = this.consumeItem()).func_190926_b()) {
            this.last_usage = this.field_145850_b.func_82737_E() + (long)this.getTimeFromStack(stack);
        }
    }

    private boolean isEnergyFull() {
        MultiBattery battery = this.getBatteries();
        return battery.getMaxEnergyStored() == battery.getUniversalEnergyStored();
    }

    public boolean isProducingPower() {
        return this.powerMadeLastTick > 0;
    }

    private boolean isAroundBlackHole() {
        ISpaceObject obj;
        if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_145850_b)) && (obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) != null) {
            DimensionProperties properties = (DimensionProperties)obj.getProperties().getParentProperties();
            return properties != null && properties.isStar() && properties.getStarData().isBlackHole();
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.initialCheck && !this.field_145850_b.field_72995_K) {
            this.completeStructure = this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.onInventoryUpdated();
            this.initialCheck = true;
        }
        if (!this.isComplete()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.isAroundBlackHole()) {
            float energyRecieved = 0.0f;
            this.attemptFire();
            energyRecieved = this.last_usage > this.field_145850_b.func_82737_E() ? 500.0f : 0.0f;
            this.powerMadeLastTick = (int)(energyRecieved * ((Float)ARConfiguration.getCurrentConfig().blackHolePowerMultiplier.get()).floatValue());
            if (this.powerMadeLastTick != this.prevPowerMadeLastTick) {
                this.prevPowerMadeLastTick = this.powerMadeLastTick;
                PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (World)this.field_145850_b, (BlockPos)this.field_174879_c, (double)128.0);
            }
            this.producePower(this.powerMadeLastTick);
        }
        if (this.field_145850_b.field_72995_K) {
            this.textModule.setText(LibVulpes.proxy.getLocalizedString("msg.microwaverec.generating") + ": " + this.powerMadeLastTick + " " + LibVulpes.proxy.getLocalizedString("msg.powerunit.rfpertick") + "\n\nStatus: " + (this.isAroundBlackHole() ? "ready" : "No black hole"));
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.writeNetworkData(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.canRender = nbt.func_74767_n("canRender");
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.readNetworkData(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.canRender = nbt.func_74767_n("canRender");
        this.readNetworkData(nbt);
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 1) {
            out.writeInt(this.powerMadeLastTick);
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 1) {
            nbt.func_74768_a("amtPwr", in.readInt());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 1) {
            this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        }
    }
}

