/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.energy;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergyTransmitter;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerProducer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class TileMicrowaveReciever
extends TileMultiPowerProducer
implements ITickableTileEntity {
    static final BlockMeta iron_block = new BlockMeta(AdvancedRocketryBlocks.blockSolarPanel);
    static final Object[][][] structure = new Object[][][]{{{iron_block, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), iron_block}, {Character.valueOf('*'), iron_block, iron_block, iron_block, Character.valueOf('*')}, {Character.valueOf('*'), iron_block, Character.valueOf('c'), iron_block, Character.valueOf('*')}, {Character.valueOf('*'), iron_block, iron_block, iron_block, Character.valueOf('*')}, {iron_block, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), iron_block}}};
    List<Long> connectedSatellites = new LinkedList<Long>();
    boolean initialCheck = false;
    double insolationPowerMultiplier = 0.0;
    ResourceLocation powerSourceDimensionID;
    int powerMadeLastTick;
    int prevPowerMadeLastTick;
    ModuleText textModule = new ModuleText(40, 20, LibVulpes.proxy.getLocalizedString("msg.microwaverec.notgenerating"), 0x2B2B2B);

    public TileMicrowaveReciever() {
        super(AdvancedRocketryTileEntityType.TILE_MICROWAVE_RECIEVER);
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        modules.add(this.textModule);
        return modules;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(0.0, 2000.0, 0.0).func_72317_d(0.0, 1000.0, 0.0);
    }

    public boolean shouldHideBlock(World world, BlockPos pos, BlockState tile) {
        return false;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List blocks = super.getAllowableWildCardBlocks();
        blocks.addAll(TileMultiBlock.getMapping((char)'I'));
        blocks.add(iron_block);
        blocks.addAll(TileMultiBlock.getMapping((char)'p'));
        return blocks;
    }

    public String getMachineName() {
        return "block.advancedrocketry.microwavereciever";
    }

    public int getPowerMadeLastTick() {
        return this.powerMadeLastTick;
    }

    public void onInventoryUpdated() {
        super.onInventoryUpdated();
        LinkedList<Long> list = new LinkedList<Long>();
        for (IInventory inv : this.itemInPorts) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemSatelliteIdentificationChip)) continue;
                ItemSatelliteIdentificationChip item = (ItemSatelliteIdentificationChip)stack.func_77973_b();
                list.add(item.getSatelliteId(stack));
            }
        }
        this.connectedSatellites = list;
    }

    public void func_73660_a() {
        DimensionProperties properties;
        if (!this.initialCheck && !this.field_145850_b.field_72995_K) {
            this.completeStructure = this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.onInventoryUpdated();
            this.initialCheck = true;
        }
        if (this.insolationPowerMultiplier == 0.0 || ZUtils.getDimensionIdentifier((World)this.field_145850_b).func_110623_a().equals(ARConfiguration.getCurrentConfig().spaceDimId.get()) && this.powerSourceDimensionID != SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c).getOrbitingPlanetId()) {
            properties = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b);
            double d = this.insolationPowerMultiplier = ZUtils.getDimensionIdentifier((World)this.field_145850_b).func_110623_a().equals(ARConfiguration.getCurrentConfig().spaceDimId.get()) ? SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c).getInsolationMultiplier() : properties.getPeakInsolationMultiplierWithoutAtmosphere();
            if (ZUtils.getDimensionIdentifier((World)this.field_145850_b).func_110623_a().equals(ARConfiguration.getCurrentConfig().spaceDimId.get())) {
                this.powerSourceDimensionID = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c).getOrbitingPlanetId();
            }
        }
        if (!this.isComplete()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.getPowerMadeLastTick() > 0 && this.field_145850_b.func_82737_E() % 100L == 0L) {
            Vector3F offset = this.getControllerOffset(this.getStructure());
            List entityList = this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - (Integer)offset.x), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - (Integer)offset.z), (double)(this.func_174877_v().func_177958_n() - (Integer)offset.x + this.getStructure()[0][0].length), 256.0, (double)(this.func_174877_v().func_177952_p() - (Integer)offset.z + this.getStructure()[0].length)));
            for (Entity e : entityList) {
                e.func_70015_d(this.powerMadeLastTick / 10);
            }
            for (int x = 0; x < this.getStructure()[0][0].length; ++x) {
                for (int z = 0; z < this.getStructure()[0].length; ++z) {
                    BlockPos pos2 = this.field_145850_b.func_205770_a(Heightmap.Type.WORLD_SURFACE, this.field_174879_c.func_177982_a(x - (Integer)offset.x, 128, z - (Integer)offset.z)).func_177982_a(0, -1, 0);
                    BlockState state = this.field_145850_b.func_180495_p(pos2);
                    if (pos2.func_177956_o() <= this.func_174877_v().func_177956_o() || this.field_145850_b.func_175623_d(pos2.func_177982_a(0, 1, 0))) continue;
                    this.field_145850_b.func_217377_a(pos2, false);
                    this.field_145850_b.func_184134_a((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p(), new SoundEvent(new ResourceLocation("fire.fire")), SoundCategory.BLOCKS, 1.0f, 3.0f, false);
                }
            }
        }
        ResourceLocation dimid = ZUtils.getDimensionIdentifier((World)this.field_145850_b);
        SpaceStationObject spaceStation = (SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
        if (!this.field_145850_b.field_72995_K && (DimensionManager.getInstance().isDimensionCreated(dimid) || ZUtils.getDimensionIdentifier((World)this.field_145850_b) == DimensionManager.overworldProperties.getId())) {
            properties = spaceStation != null ? spaceStation.getOrbitingPlanet() : DimensionManager.getInstance().getDimensionProperties(dimid);
            int energyRecieved = 0;
            if (this.enabled) {
                for (long lng : this.connectedSatellites) {
                    SatelliteBase satellite = properties.getSatellite(lng);
                    if (!(satellite instanceof IUniversalEnergyTransmitter)) continue;
                    energyRecieved += ((IUniversalEnergyTransmitter)satellite).transmitEnergy(Direction.UP, false);
                }
                energyRecieved = (int)((double)energyRecieved * (2.0 * this.insolationPowerMultiplier));
            }
            this.powerMadeLastTick = (int)((double)energyRecieved * (Double)ARConfiguration.getCurrentConfig().microwaveRecieverMulitplier.get());
            if (this.powerMadeLastTick != this.prevPowerMadeLastTick) {
                this.prevPowerMadeLastTick = this.powerMadeLastTick;
                PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (World)this.field_145850_b, (BlockPos)this.field_174879_c, (double)128.0);
            }
            this.producePower(this.powerMadeLastTick);
        }
        if (this.field_145850_b.field_72995_K) {
            this.textModule.setText(LibVulpes.proxy.getLocalizedString("msg.microwaverec.generating") + this.powerMadeLastTick + " " + LibVulpes.proxy.getLocalizedString("msg.powerunit.rfpertick"));
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.writeNetworkData(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.canRender = nbt.func_74767_n("canRender");
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.readNetworkData(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.canRender = nbt.func_74767_n("canRender");
        this.readNetworkData(nbt);
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 1) {
            out.writeInt(this.powerMadeLastTick);
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 1) {
            nbt.func_74768_a("amtPwr", in.readInt());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 1) {
            this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        int[] intArray = new int[this.connectedSatellites.size() * 2];
        for (int i = 0; i < this.connectedSatellites.size() * 2; i += 2) {
            this.connectedSatellites.get(i / 2);
            intArray[i] = (int)(this.connectedSatellites.get(i / 2) & 0xFFFFFFFFFFFFFFFFL);
            intArray[i + 1] = (int)(this.connectedSatellites.get(i / 2) >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        }
        nbt.func_74783_a("satilliteList", intArray);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        int[] intArray = nbt.func_74759_k("satilliteList");
        this.connectedSatellites.clear();
        for (int i = 0; i < intArray.length / 2; i += 2) {
            this.connectedSatellites.add((long)intArray[i] | (long)intArray[i + 1] << 32);
        }
    }
}

