/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.energy;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerProducer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.Vector3F;

public class TileSolarArray
extends TileMultiPowerProducer
implements ITickableTileEntity {
    static final Object[][][] structure = new Object[][][]{{{Character.valueOf('p'), Character.valueOf('c'), Character.valueOf('p')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}, {Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*')}}};
    boolean initialCheck;
    int powerMadeLastTick;
    int prevPowerMadeLastTick;
    int numPanels;
    ModuleText textModule = new ModuleText(40, 20, LibVulpes.proxy.getLocalizedString("msg.microwaverec.notgenerating"), 0x2B2B2B);

    public TileSolarArray() {
        super(AdvancedRocketryTileEntityType.TILE_SOLAR_ARRAY);
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        modules.add(this.textModule);
        return modules;
    }

    public boolean shouldHideBlock(World world, BlockPos pos, BlockState tile) {
        return true;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List blocks = super.getAllowableWildCardBlocks();
        blocks.add(new BlockMeta(AdvancedRocketryBlocks.blockSolarArrayPanel, true));
        blocks.add(new BlockMeta(Blocks.field_150350_a));
        return blocks;
    }

    protected boolean completeStructure(BlockState state) {
        Direction front = this.getFrontDirection(state);
        Vector3F offset = this.getControllerOffset(structure);
        this.numPanels = 0;
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[0].length; ++z) {
                for (int x = 0; x < structure[0][0].length; ++x) {
                    int globalZ;
                    int globalY;
                    int globalX = this.field_174879_c.func_177958_n() + (x - (Integer)offset.x) * front.func_82599_e() - (z - (Integer)offset.z) * front.func_82601_c();
                    if (this.field_145850_b.func_180495_p(new BlockPos(globalX, globalY = this.field_174879_c.func_177956_o() - y + (Integer)offset.y, globalZ = this.field_174879_c.func_177952_p() - (x - (Integer)offset.x) * front.func_82601_c() - (z - (Integer)offset.z) * front.func_82599_e())).func_177230_c() != AdvancedRocketryBlocks.blockSolarArrayPanel) continue;
                    ++this.numPanels;
                }
            }
        }
        return super.completeStructure(state);
    }

    public String getMachineName() {
        return "block.advancedrocketry.solararray";
    }

    public void func_73660_a() {
        if (!this.initialCheck && !this.field_145850_b.field_72995_K) {
            this.completeStructure = this.attemptCompleteStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            this.initialCheck = true;
        }
        if (!this.isComplete()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean isSpaceDim = DimensionManager.getInstance().isSpaceDimension(this.field_145850_b);
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b);
            double insolationPowerMultiplier = isSpaceDim ? SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c).getInsolationMultiplier() : properties.getPeakInsolationMultiplier();
            int energyRecieved = 0;
            if (this.enabled && (this.field_145850_b.func_72935_r() && this.field_145850_b.func_175710_j(this.field_174879_c.func_177984_a()) || isSpaceDim && this.field_145850_b.func_175710_j(this.field_174879_c.func_177977_b()))) {
                energyRecieved = (int)((double)this.numPanels * 1.0005 * 2.0 * insolationPowerMultiplier);
            }
            this.powerMadeLastTick = energyRecieved * (Integer)ARConfiguration.getCurrentConfig().solarGeneratorMult.get();
            if (this.powerMadeLastTick != this.prevPowerMadeLastTick) {
                this.prevPowerMadeLastTick = this.powerMadeLastTick;
                PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (World)this.field_145850_b, (BlockPos)this.field_174879_c, (double)128.0);
            }
            this.producePower(this.powerMadeLastTick);
        }
        if (this.field_145850_b.field_72995_K) {
            this.textModule.setText(LibVulpes.proxy.getLocalizedString("msg.microwaverec.generating") + " " + this.powerMadeLastTick + " " + LibVulpes.proxy.getLocalizedString("msg.powerunit.rfpertick"));
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.writeNetworkData(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.readNetworkData(nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("powerMadeLastTick", this.powerMadeLastTick);
        nbt.func_74768_a("numPanels", this.numPanels);
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.powerMadeLastTick = nbt.func_74762_e("powerMadeLastTick");
        this.numPanels = nbt.func_74762_e("numPanels");
        this.canRender = nbt.func_74767_n("canRender");
        this.readNetworkData(nbt);
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 1) {
            out.writeInt(this.powerMadeLastTick);
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 1) {
            nbt.func_74768_a("amtPwr", in.readInt());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 1) {
            this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        }
    }

    protected void writeNetworkData(CompoundNBT nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74768_a("numPanels", this.numPanels);
    }

    protected void readNetworkData(CompoundNBT nbt) {
        super.readNetworkData(nbt);
        this.numPanels = nbt.func_74762_e("numPanels");
    }
}

