/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.machine;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.armor.ItemSpaceArmor;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.recipe.RecipeChemicalReactor;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.recipe.NumberedOreDictStack;
import zmaster587.libVulpes.recipe.RecipesMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;

public class TileChemicalReactor
extends TileMultiblockMachine {
    public static final Object[][][] structure = new Object[][][]{{{null, Character.valueOf('c'), null}, {Character.valueOf('L'), Character.valueOf('I'), Character.valueOf('L')}}, {{Character.valueOf('P'), LibVulpesBlocks.motors, Character.valueOf('P')}, {Character.valueOf('l'), Character.valueOf('O'), Character.valueOf('l')}}};

    public TileChemicalReactor() {
        super(AdvancedRocketryTileEntityType.TILE_CHEMICAL_REACTOR);
    }

    public boolean shouldHideBlock(World world, BlockPos pos, BlockState tile) {
        return true;
    }

    public void onInventoryUpdated() {
        int i;
        ListNBT list;
        IRecipe recipe;
        boolean flag = false;
        if (this.getOutputs() == null && (recipe = this.getRecipe(this.getMachineRecipeList())) != null && this.canProcessRecipe(recipe) && !recipe.getOutput().isEmpty() && (list = ((ItemStack)recipe.getOutput().get(0)).func_77986_q()) != null && (i = 0) < list.size()) {
            CompoundNBT tag = (CompoundNBT)list.get(i);
            flag = true;
        }
        if (flag && this.getOutputs() == null) {
            if (this.enabled && (recipe = this.getRecipe(this.getMachineRecipeList())) != null && this.canProcessRecipe(recipe)) {
                this.consumeItemsSpecial(recipe);
                this.setOutputFluids(new LinkedList());
                this.powerPerTick = (int)Math.ceil(this.getPowerMultiplierForRecipe(recipe) * (float)recipe.getPower());
                this.completionTime = Math.max((int)(this.getTimeMultiplierForRecipe(recipe) * (float)recipe.getTime()), 1);
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.setMachineRunning(true);
            } else {
                this.setMachineRunning(false);
            }
        } else {
            super.onInventoryUpdated();
        }
    }

    public void consumeItemsSpecial(IRecipe recipe) {
        List ingredients = recipe.getPossibleIngredients();
        block0: for (int ingredientNum = 0; ingredientNum < ingredients.size(); ++ingredientNum) {
            List ingredient = (List)ingredients.get(ingredientNum);
            for (IInventory hatch : this.itemInPorts) {
                for (int i = 0; i < hatch.func_70302_i_(); ++i) {
                    ItemStack stackInSlot = hatch.func_70301_a(i);
                    for (ItemStack stack : ingredient) {
                        if (stackInSlot == null || stackInSlot.func_190916_E() < stack.func_190916_E() || stackInSlot.func_77973_b() != stack.func_77973_b() || stackInSlot.func_77952_i() != stack.func_77952_i()) continue;
                        ItemStack stack2 = hatch.func_70298_a(i, stack.func_190916_E());
                        if (stack2.func_77973_b() instanceof ArmorItem) {
                            stack2.func_77966_a(AdvancedRocketryAPI.enchantmentSpaceProtection, 1);
                            LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                            list.add(stack2);
                            this.setOutputs(list);
                        }
                        hatch.func_70296_d();
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(((TileEntity)hatch).func_174877_v()), this.field_145850_b.func_180495_p(((TileEntity)hatch).func_174877_v()), 6);
                        continue block0;
                    }
                }
            }
        }
    }

    public void registerRecipes() {
        if (((Boolean)ARConfiguration.getCurrentConfig().enableOxygen.get()).booleanValue()) {
            for (ResourceLocation key : ForgeRegistries.ITEMS.getKeys()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
                if (!(item instanceof ArmorItem) || item instanceof ItemSpaceArmor) continue;
                ItemStack enchanted = new ItemStack((IItemProvider)item);
                enchanted.func_77966_a(AdvancedRocketryAPI.enchantmentSpaceProtection, 1);
                if (((ArmorItem)item).func_185083_B_() == EquipmentSlotType.CHEST) {
                    RecipesMachine.getInstance().addRecipe(key, (IRecipeSerializer)RecipeChemicalReactor.INSTANCE, TileChemicalReactor.class, (Object)enchanted, 100, 10, new Object[]{new ItemStack((IItemProvider)item, 1), new ItemStack((IItemProvider)Items.field_151045_i), new ItemStack((IItemProvider)AdvancedRocketryBlocks.blockPipeSealer, 1), new NumberedOreDictStack(new ResourceLocation("forge", "sheetTitaniumAluminide"), 4), new ItemStack((IItemProvider)AdvancedRocketryItems.itemHighPressureTank, 1)});
                    continue;
                }
                RecipesMachine.getInstance().addRecipe(key, (IRecipeSerializer)RecipeChemicalReactor.INSTANCE, TileChemicalReactor.class, (Object)enchanted, 100, 10, new Object[]{new ItemStack((IItemProvider)item, 1), new ItemStack((IItemProvider)Items.field_151045_i), new ItemStack((IItemProvider)AdvancedRocketryBlocks.blockPipeSealer, 1), new NumberedOreDictStack(new ResourceLocation("forge", "sheetTitaniumAluminide"), 4)});
            }
        }
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public SoundEvent getSound() {
        return AudioRegistry.rollingMachine;
    }

    public int getSoundDuration() {
        return 30;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        modules.add(new ModuleProgress(100, 4, 0, TextureResources.crystallizerProgressBar, (IProgressBar)this));
        return modules;
    }

    public String getMachineName() {
        return "block.advancedrocketry.chemicalreactor";
    }
}

