/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.machine;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.util.AudioRegistry;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.material.Material;
import zmaster587.libVulpes.api.material.MaterialRegistry;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;

public class TileCrystallizer
extends TileMultiblockMachine
implements IModularInventory {
    public static final Object[][][] structure = new Object[][][]{{{AdvancedRocketryBlocks.blockQuartzCrucible, AdvancedRocketryBlocks.blockQuartzCrucible, AdvancedRocketryBlocks.blockQuartzCrucible}, {AdvancedRocketryBlocks.blockQuartzCrucible, AdvancedRocketryBlocks.blockQuartzCrucible, AdvancedRocketryBlocks.blockQuartzCrucible}}, {{Character.valueOf('O'), Character.valueOf('c'), Character.valueOf('I')}, {Character.valueOf('l'), Character.valueOf('P'), Character.valueOf('L')}}};
    Material[] coil = new Material[2];

    public TileCrystallizer() {
        super(AdvancedRocketryTileEntityType.TILE_CRYSTALLIZER);
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public float getTimeMultiplierForBlock(BlockState state, TileEntity tile) {
        Material material = MaterialRegistry.getMaterialFromItemStack((ItemStack)new ItemStack((IItemProvider)state.func_177230_c(), 1));
        if (material == MaterialRegistry.getMaterialFromName((String)"Gold")) {
            return 0.9f;
        }
        if (material == MaterialRegistry.getMaterialFromName((String)"Aluminum")) {
            return 0.8f;
        }
        if (material == MaterialRegistry.getMaterialFromName((String)"Titanium")) {
            return 0.75f;
        }
        if (material == MaterialRegistry.getMaterialFromName((String)"Iridium")) {
            return 0.5f;
        }
        return super.getTimeMultiplierForBlock(state, tile);
    }

    public boolean shouldHideBlock(World world, BlockPos pos2, BlockState tile) {
        return true;
    }

    public SoundEvent getSound() {
        return AudioRegistry.crystallizer;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-2, -2, -2), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public boolean isGravityWithinBounds() {
        if ((Integer)ARConfiguration.getCurrentConfig().crystalliserMaximumGravity.get() != 0) {
            return (float)((Integer)ARConfiguration.getCurrentConfig().crystalliserMaximumGravity.get()).intValue() > DimensionManager.getInstance().getDimensionProperties((World)this.field_145850_b).gravitationalMultiplier;
        }
        return true;
    }

    protected void onRunningPoweredTick() {
        if (this.isGravityWithinBounds()) {
            super.onRunningPoweredTick();
        }
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        List modules = super.getModules(ID, player);
        modules.add(new ModuleProgress(100, 4, 0, TextureResources.crystallizerProgressBar, (IProgressBar)this));
        if (!this.isGravityWithinBounds()) {
            modules.add(new ModuleText(10, 75, LibVulpes.proxy.getLocalizedString("msg.crystalliser.gravityTooHigh"), 0xFF1B1B));
        }
        return modules;
    }

    public String getMachineName() {
        return "container.crystallizer";
    }
}

