/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.entity.EntityLaserNode;
import zmaster587.advancedRocketry.event.BlockBreakEvent;
import zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill.AbstractDrill;

class MiningDrill
extends AbstractDrill {
    private EntityLaserNode laser;
    private Vector3i ticketLaser;
    protected boolean finished = false;

    MiningDrill() {
    }

    @Override
    ItemStack[] performOperation() {
        ItemStack[] stacks = new ItemStack[]{};
        for (int i = 0; i < 9; ++i) {
            int x = (int)this.laser.func_226277_ct_() + i % 3 - 1;
            int z = (int)this.laser.func_226281_cx_() + i / 3 - 1;
            BlockPos laserPos = new BlockPos(x, (int)this.laser.func_226278_cu_(), z);
            BlockState state = this.laser.field_70170_p.func_180495_p(laserPos);
            BlockBreakEvent.LaserBreakEvent event = new BlockBreakEvent.LaserBreakEvent(x, (int)this.laser.func_226278_cu_(), z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) continue;
            if (state == Blocks.field_150350_a.func_176223_P() || state.func_185904_a().func_76222_j() || state.func_185904_a().func_76224_d()) {
                this.laser.field_70170_p.func_175656_a(laserPos, AdvancedRocketryBlocks.blockLightSource.func_176223_P());
                continue;
            }
            Object items = NonNullList.func_191196_a();
            items = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)this.laser.field_70170_p), (BlockPos)laserPos, (TileEntity)this.laser.field_70170_p.func_175625_s(laserPos));
            if (!state.func_185904_a().func_76218_k() || state.func_177230_c() == Blocks.field_150357_h) continue;
            if (items.isEmpty()) {
                this.laser.field_70170_p.func_175656_a(laserPos, AdvancedRocketryBlocks.blockLightSource.func_176223_P());
                continue;
            }
            stacks = new ItemStack[items.size()];
            stacks = items.toArray(stacks);
            this.laser.field_70170_p.func_175656_a(laserPos, AdvancedRocketryBlocks.blockLightSource.func_176223_P());
        }
        boolean blockInWay = false;
        block1: do {
            if (this.laser.func_226278_cu_() < 1.0) {
                this.laser.func_70106_y();
                this.laser = null;
                this.finished = true;
                break;
            }
            this.laser.func_70107_b((int)this.laser.func_226277_ct_(), this.laser.func_226278_cu_() - 1.0, (int)this.laser.func_226281_cx_());
            for (int i = 0; i < 9; ++i) {
                int x = (int)this.laser.func_226277_ct_() + i % 3 - 1;
                int z = (int)this.laser.func_226281_cx_() + i / 3 - 1;
                BlockPos laserPos = new BlockPos(x, (int)this.laser.func_226278_cu_(), z);
                BlockState state = this.laser.field_70170_p.func_180495_p(laserPos);
                if (!state.func_185904_a().func_76218_k() || state.func_177230_c() == Blocks.field_150357_h) continue;
                if (state == Blocks.field_150350_a.func_176223_P() || state.func_185904_a().func_76224_d()) {
                    this.laser.field_70170_p.func_175656_a(laserPos, Blocks.field_150350_a.func_176223_P());
                    continue;
                }
                if (state == Blocks.field_150350_a.func_176223_P()) continue;
                blockInWay = true;
                continue block1;
            }
        } while (!blockInWay);
        return stacks;
    }

    @Override
    boolean activate(World world, int x, int z) {
        ServerWorld worldServer = (ServerWorld)world;
        this.ticketLaser = new Vector3i(x >> 4, 0, z >> 4);
        worldServer.func_217458_b(x >> 4, z >> 4, true);
        if (this.ticketLaser != null) {
            int y = 64;
            if (world.func_217349_x(new BlockPos(x, 0, z)).func_201589_g().func_209003_a(ChunkStatus.field_222617_m)) {
                for (int i = 0; i < 9; ++i) {
                    int current = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x + i % 3 - 1, z + i / 3 - 1);
                    if (current <= y) continue;
                    y = current;
                }
            } else {
                y = 255;
            }
            this.laser = new EntityLaserNode(world, x, y, z);
            this.laser.markValid();
            this.laser.field_98038_p = true;
            world.func_217376_c((Entity)this.laser);
            return true;
        }
        return false;
    }

    @Override
    void deactivate() {
        if (this.laser != null) {
            this.laser.func_70106_y();
            this.laser = null;
        }
        if (this.ticketLaser != null) {
            ServerWorld worldServer = (ServerWorld)this.laser.func_130014_f_();
            worldServer.func_217458_b(this.ticketLaser.func_177958_n(), this.ticketLaser.func_177952_p(), true);
            this.ticketLaser = null;
        }
        this.finished = false;
    }

    @Override
    boolean isFinished() {
        return this.finished;
    }

    @Override
    boolean needsRestart() {
        return this.laser == null || this.ticketLaser == null;
    }
}

