/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill.AbstractDrill;
import zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill.MiningDrill;
import zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill.VoidDrill;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.compat.InventoryCompat;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleNumericTextbox;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTextBox;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.MultiInventory;
import zmaster587.libVulpes.util.ZUtils;

public class TileOrbitalLaserDrill
extends TileMultiPowerConsumer
implements ISidedInventory,
IGuiCallback,
IButtonInventory {
    ItemStack lens;
    private final AbstractDrill drill;
    protected boolean isRunning;
    protected boolean finished;
    protected boolean isJammed;
    private int radius = 0;
    private int xCenter = 0;
    private int yCenter = 0;
    private int numSteps = 0;
    private Direction prevDir = null;
    public int laserX = 0;
    public int laserZ = 0;
    public int tickSinceLastOperation = 0;
    private static final Direction[] VALID_INVENTORY_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final int POWER_PER_OPERATION = (int)(10000.0 * (Double)ARConfiguration.getCurrentConfig().spaceLaserPowerMult.get());
    private ModuleTextBox locationX;
    private ModuleTextBox locationZ;
    private ModuleText updateText;
    MultiInventory inv;
    Object[][][] structure = new Object[][][]{{{null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null, null, null, null, null, null, null, null, null}, {LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, null, null, null, null, null, null, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null}}, {{null, null, null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, null}, {null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockLens, AdvancedRocketryBlocks.blockLens, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, Character.valueOf('P')}, {null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, Character.valueOf('P')}, {LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockStructureBlock, null, AdvancedRocketryBlocks.blockLens, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, null}, {LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockLens, LibVulpesBlocks.blockAdvStructureBlock, null, null, null, null, null, null}, {LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockStructureBlock, null, AdvancedRocketryBlocks.blockLens, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, null}, {null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, Character.valueOf('P')}, {null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockLens, AdvancedRocketryBlocks.blockLens, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, Character.valueOf('P')}, {null, null, null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, null}}, {{null, null, null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, null}, {null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockLens, AdvancedRocketryBlocks.blockLens, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, Character.valueOf('P')}, {Character.valueOf('O'), Character.valueOf('c'), Character.valueOf('O'), null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, Character.valueOf('P')}, {LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, null, AdvancedRocketryBlocks.blockLens, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, null}, {LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, AdvancedRocketryBlocks.blockLens, LibVulpesBlocks.blockAdvStructureBlock, null, null, null, null, null, null}, {LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, LibVulpesBlocks.blockStructureBlock, null, AdvancedRocketryBlocks.blockLens, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, null}, {null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, Character.valueOf('P')}, {null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockLens, AdvancedRocketryBlocks.blockLens, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, Character.valueOf('P')}, {null, null, null, null, null, null, LibVulpesBlocks.blockAdvStructureBlock, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, AdvancedRocketryBlocks.blockVacuumLaser, null}}};
    private MODE mode;

    public TileOrbitalLaserDrill() {
        super(AdvancedRocketryTileEntityType.TILE_SPACE_LASER);
        this.lens = ItemStack.field_190927_a;
        this.inv = new MultiInventory((List)this.itemOutPorts);
        this.drill = (Boolean)ARConfiguration.getCurrentConfig().laserDrillPlanet.get() != false ? new MiningDrill() : new VoidDrill();
        this.isRunning = false;
        this.finished = false;
        this.isJammed = false;
        this.mode = MODE.SINGLE;
    }

    public Object[][][] getStructure() {
        return this.structure;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 5), (double)(this.field_174879_c.func_177956_o() - 1000), (double)(this.field_174879_c.func_177952_p() - 5), (double)(this.field_174879_c.func_177958_n() + 5), (double)(this.field_174879_c.func_177956_o() + 50), (double)(this.field_174879_c.func_177952_p() + 5));
    }

    public boolean shouldHideBlock(World world, BlockPos pos, BlockState tile) {
        return true;
    }

    public String getMachineName() {
        return this.getModularInventoryName();
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 10) {
            out.writeInt(this.laserX);
        } else if (id == 11) {
            out.writeInt(this.laserZ);
        } else if (id == 12) {
            out.writeBoolean(this.isRunning);
        } else if (id == 13) {
            out.writeInt(this.mode.ordinal());
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte id, CompoundNBT nbt) {
        super.readDataFromNetwork(in, id, nbt);
        if (id == 10) {
            nbt.func_74768_a("laserX", in.readInt());
        } else if (id == 11) {
            nbt.func_74768_a("laserZ", in.readInt());
        } else if (id == 12) {
            nbt.func_74757_a("isRunning", in.readBoolean());
        } else if (id == 13) {
            nbt.func_74768_a("mode", in.readInt());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 10) {
            this.laserX = nbt.func_74762_e("laserX");
            this.finished = false;
            if (this.mode == MODE.SPIRAL) {
                this.resetSpiral();
            }
        } else if (id == 11) {
            this.laserZ = nbt.func_74762_e("laserZ");
            this.finished = false;
            if (this.mode == MODE.SPIRAL) {
                this.resetSpiral();
            }
        } else if (id == 12) {
            this.isRunning = nbt.func_74767_n("isRunning");
        } else if (id == 13 && !this.isRunning()) {
            this.mode = MODE.values()[nbt.func_74762_e("mode")];
        } else if (id == 14) {
            this.attemptUnjam();
        }
        this.func_70296_d();
    }

    private void resetSpiral() {
        this.radius = 0;
        this.prevDir = null;
        this.xCenter = 0;
        this.yCenter = 0;
        this.numSteps = 0;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void incrementMode() {
        if (this.mode == MODE.SPIRAL) {
            this.resetSpiral();
        }
        int num = this.mode.ordinal();
        if (++num >= MODE.values().length) {
            num = 0;
        }
        this.mode = MODE.values()[num];
    }

    public void decrementMode() {
        if (this.mode == MODE.SPIRAL) {
            this.resetSpiral();
        }
        int num = this.mode.ordinal();
        if (--num < 0) {
            num = MODE.values().length - 1;
        }
        this.mode = MODE.values()[num];
    }

    public void setMode(MODE m) {
        this.mode = m;
    }

    public void setFinished(boolean value) {
        this.finished = value;
    }

    public void setRunning(boolean value) {
        this.isRunning = value;
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.timeAlive == 0 && !this.field_145850_b.field_72995_K) {
            if (this.isComplete()) {
                this.canRender = this.completeStructure = this.completeStructure(this.field_145850_b.func_180495_p(this.field_174879_c));
            }
            this.timeAlive = 1;
            this.checkCanRun();
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickSinceLastOperation;
            if (this.unableToRun()) {
                this.drill.deactivate();
                this.setFinished(true);
                this.setRunning(false);
            } else if (this.hasPowerForOperation() && this.isReadyForOperation() && !this.isJammed) {
                if (this.drill.needsRestart()) {
                    this.setRunning(false);
                    return;
                }
                ItemStack[] stacks = this.drill.performOperation();
                ZUtils.mergeInventory((ItemStack[])stacks, (IInventory)this.inv);
                if (!ZUtils.isInvEmpty((ItemStack[])stacks)) {
                    this.drill.deactivate();
                    this.isJammed = true;
                }
                this.batteries.setEnergyStored(this.batteries.getUniversalEnergyStored() - POWER_PER_OPERATION);
                this.tickSinceLastOperation = 0;
            }
        }
        if (this.drill.isFinished()) {
            this.setRunning(false);
            this.drill.deactivate();
            if (!this.isJammed) {
                if (this.mode == MODE.SINGLE) {
                    this.finished = true;
                }
                if (this.field_145850_b.func_175676_y(this.func_174877_v()) != 0) {
                    if (this.mode == MODE.LINE_X) {
                        this.laserX += 3;
                    } else if (this.mode == MODE.LINE_Z) {
                        this.laserZ += 3;
                    } else if (this.mode == MODE.SPIRAL) {
                        ++this.numSteps;
                        if (this.radius < this.numSteps) {
                            this.numSteps = 0;
                            if (this.prevDir == Direction.NORTH) {
                                this.prevDir = Direction.EAST;
                            } else if (this.prevDir == Direction.EAST) {
                                this.prevDir = Direction.SOUTH;
                                ++this.radius;
                            } else if (this.prevDir == Direction.SOUTH) {
                                this.prevDir = Direction.WEST;
                            } else {
                                this.prevDir = Direction.NORTH;
                                ++this.radius;
                            }
                        }
                        this.laserX += 3 * this.prevDir.func_82601_c();
                        this.laserZ += 3 * this.prevDir.func_82599_e();
                    }
                }
                this.checkCanRun();
            }
        }
    }

    public boolean isReadyForOperation() {
        if (this.batteries.getUniversalEnergyStored() == 0) {
            return false;
        }
        return (float)this.tickSinceLastOperation > (float)(3 * this.batteries.getMaxEnergyStored()) / (float)this.batteries.getUniversalEnergyStored();
    }

    public void onDestroy() {
        if (this.drill != null) {
            this.drill.deactivate();
        }
        if (!this.field_145850_b.field_72995_K) {
            ServerWorld svrWorld = (ServerWorld)this.field_145850_b;
            svrWorld.func_217458_b(new ChunkPos((BlockPos)this.func_174877_v()).field_77276_a, new ChunkPos((BlockPos)this.func_174877_v()).field_77275_b, false);
        }
    }

    public void onChunkUnloaded() {
        if (this.drill != null) {
            this.drill.deactivate();
        }
        this.isRunning = false;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        nbt.func_74757_a("IsRunning", this.isRunning);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.isRunning = pkt.func_148857_g().func_74767_n("IsRunning");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.lens != null) {
            CompoundNBT tag = new CompoundNBT();
            this.lens.func_77955_b(tag);
            nbt.func_218657_a("GlassPane", (INBT)tag);
        }
        nbt.func_74768_a("laserX", this.laserX);
        nbt.func_74768_a("laserZ", this.laserZ);
        nbt.func_74774_a("mode", (byte)this.mode.ordinal());
        nbt.func_74757_a("jammed", this.isJammed);
        if (this.mode == MODE.SPIRAL && this.prevDir != null) {
            nbt.func_74768_a("CenterX", this.xCenter);
            nbt.func_74768_a("CenterY", this.yCenter);
            nbt.func_74768_a("radius", this.radius);
            nbt.func_74768_a("numSteps", this.numSteps);
            nbt.func_74768_a("prevDir", this.prevDir.ordinal());
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("GlassPane")) {
            CompoundNBT tag = nbt.func_74775_l("GlassPane");
            this.lens = ItemStack.func_199557_a((CompoundNBT)tag);
        }
        this.laserX = nbt.func_74762_e("laserX");
        this.laserZ = nbt.func_74762_e("laserZ");
        this.mode = MODE.values()[nbt.func_74771_c("mode")];
        this.isJammed = nbt.func_74767_n("jammed");
        if (this.mode == MODE.SPIRAL && nbt.func_74764_b("prevDir")) {
            this.xCenter = nbt.func_74762_e("CenterX");
            this.yCenter = nbt.func_74762_e("CenterY");
            this.radius = nbt.func_74762_e("radius");
            this.numSteps = nbt.func_74762_e("numSteps");
            this.prevDir = Direction.values()[nbt.func_74762_e("prevDir")];
        }
    }

    public void attemptUnjam() {
        if (!this.isJammed) {
            return;
        }
        if (this.hatchesAreEmpty()) {
            this.isJammed = false;
        }
        this.finished = false;
        this.checkCanRun();
    }

    private boolean hatchesAreEmpty() {
        for (int i = 1; i < this.inv.func_70302_i_(); ++i) {
            if (this.inv.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean canMachineSeeEarth() {
        return true;
    }

    private boolean unableToRun() {
        return this.lens.func_190926_b() || !this.canMachineSeeEarth() || this.batteries.getUniversalEnergyStored() == 0 || ZUtils.getDimensionIdentifier((World)this.field_145850_b).equals((Object)ARConfiguration.GetSpaceDimId()) || !DimensionManager.getInstance().canTravelTo(DimensionManager.getInstance().getDimensionProperties(this.field_145850_b, this.func_174877_v()).getParentPlanet()) || ((List)ARConfiguration.getCurrentConfig().laserBlackListDims.get()).contains(DimensionManager.getInstance().getDimensionProperties(this.field_145850_b, this.func_174877_v()).getParentPlanet().toString());
    }

    public void checkCanRun() {
        if (this.field_145850_b.func_175687_A(this.func_174877_v()) == 0 || this.unableToRun()) {
            this.drill.deactivate();
            this.setRunning(false);
        } else if (!this.finished && !this.isJammed && this.field_145850_b.func_175640_z(this.func_174877_v())) {
            ResourceLocation orbitDimId = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c).getOrbitingPlanetId();
            if (SpaceObjectManager.WARPDIMID.equals((Object)orbitDimId)) {
                return;
            }
            ServerWorld orbitWorld = ZUtils.getWorld((ResourceLocation)orbitDimId);
            if (orbitWorld == null) {
                ZUtils.initDimension((ResourceLocation)orbitDimId);
                orbitWorld = ZUtils.getWorld((ResourceLocation)orbitDimId);
                if (orbitWorld == null) {
                    return;
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                ServerWorld svrWorld = (ServerWorld)this.field_145850_b;
                svrWorld.func_217458_b(new ChunkPos((BlockPos)this.func_174877_v()).field_77276_a, new ChunkPos((BlockPos)this.func_174877_v()).field_77275_b, false);
            }
            this.setRunning(this.drill.activate((World)orbitWorld, this.laserX, this.laserZ));
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 12), (ResourceLocation)ZUtils.getDimensionIdentifier((World)this.field_145850_b), (BlockPos)this.field_174879_c, (double)128.0);
        }
    }

    public int getEnergyPercentScaled(int max) {
        return (int)((float)max * ((float)this.batteries.getUniversalEnergyStored() / (float)this.batteries.getMaxEnergyStored()));
    }

    public boolean hasEnergy() {
        return this.batteries.getUniversalEnergyStored() != 0;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return this.lens;
        }
        return this.inv.func_70301_a(--i);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (i == 0) {
            ItemStack ret = this.lens.func_77946_l();
            this.lens = ItemStack.field_190927_a;
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            this.lens = itemstack;
        } else {
            if (InventoryCompat.canInjectItems((IInventory)this.inv, (ItemStack)itemstack)) {
                InventoryCompat.injectItem((Object)this.inv, (ItemStack)itemstack);
            }
            this.checkCanRun();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity entityplayer) {
        return this.field_174879_c.func_177951_i((Vector3i)new BlockPos(entityplayer.func_213303_ch())) <= 64.0;
    }

    public boolean func_191420_l() {
        return this.lens.func_190926_b();
    }

    public void func_174889_b(PlayerEntity entity) {
    }

    public void func_174886_c(PlayerEntity entity) {
    }

    public int[] func_180463_a(Direction side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i == 0) {
            return AdvancedRocketryItems.itemLens == itemstack.func_77973_b();
        }
        return this.inv.func_94041_b(i, itemstack);
    }

    public boolean hasPowerForOperation() {
        return POWER_PER_OPERATION <= this.batteries.getUniversalEnergyStored();
    }

    public void setEnergy(int amt) {
        this.batteries.setEnergyStored(amt);
    }

    public boolean isJammed() {
        return this.isJammed;
    }

    public void setJammed(boolean b) {
        this.isJammed = b;
    }

    public void onModuleUpdated(ModuleBase module) {
        if (module == this.locationX) {
            if (!((ModuleTextBox)module).getText().isEmpty() && !((ModuleTextBox)module).getText().contentEquals("-")) {
                this.laserX = Integer.parseInt(((ModuleTextBox)module).getText());
            }
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 10));
        } else if (module == this.locationZ) {
            if (!((ModuleTextBox)module).getText().isEmpty() && !((ModuleTextBox)module).getText().contentEquals("-")) {
                this.laserZ = Integer.parseInt(((ModuleTextBox)module).getText());
            }
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 11));
        }
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        if (this.field_145850_b.field_72995_K) {
            this.locationX = new ModuleNumericTextbox((IGuiCallback)this, 113, 31, 50, 10, 16);
            modules.add((ModuleBase)this.locationX);
            this.locationZ = new ModuleNumericTextbox((IGuiCallback)this, 113, 41, 50, 10, 16);
            modules.add((ModuleBase)this.locationZ);
            this.locationX.setText(String.valueOf(this.laserX));
            this.locationZ.setText(String.valueOf(this.laserZ));
            this.updateText = new ModuleText(130, 20, this.getMode().toString(), 723723, true);
            modules.add((ModuleBase)this.updateText);
            modules.add((ModuleBase)new ModuleText(103, 33, "X:", 723723));
            modules.add((ModuleBase)new ModuleText(103, 43, "Z:", 723723));
            modules.add((ModuleBase)new ModuleImage(8, 16, TextureResources.laserGuiBG));
        }
        modules.add((ModuleBase)new ModuleButton(103, 20, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonLeft, 5, 8).setAdditionalData((Object)0));
        modules.add((ModuleBase)new ModuleButton(157, 20, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonRight, 5, 8).setAdditionalData((Object)1));
        modules.add((ModuleBase)new ModuleButton(103, 62, LibVulpes.proxy.getLocalizedString("msg.spacelaser.reset"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 64, 20).setAdditionalData((Object)2));
        modules.add((ModuleBase)new ModulePower(11, 25, (IUniversalEnergy)this.batteries));
        modules.add((ModuleBase)new ModuleSlotArray(56, 54, (IInventory)this, 0, 1));
        return modules;
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.spacelaser";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void onInventoryButtonPressed(ModuleButton button) {
        int buttonId;
        int n = buttonId = button.getAdditionalData() == null ? -1 : (Integer)button.getAdditionalData();
        if (buttonId == 0) {
            this.decrementMode();
            this.updateText.setText(this.getMode().toString());
        } else if (buttonId == 1) {
            this.incrementMode();
            this.updateText.setText(this.getMode().toString());
        } else {
            if (buttonId == 2) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 14));
                return;
            }
            return;
        }
        if (!this.isRunning()) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 13));
        }
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_174888_l() {
    }

    public static enum MODE {
        SINGLE,
        LINE_X,
        LINE_Z,
        SPIRAL;

    }
}

