/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill.AbstractDrill;

class VoidDrill
extends AbstractDrill {
    private final Random random = new Random();
    private List<ItemStack> ores;
    private boolean planetOresInitialized = false;

    VoidDrill() {
        this.loadGlobalOres();
    }

    private void loadGlobalOres() {
        if (this.ores == null && !ARConfiguration.getCurrentConfig().standardLaserDrillOres.isEmpty()) {
            this.ores = new ArrayList<ItemStack>();
            for (int i = 0; i < ARConfiguration.getCurrentConfig().standardLaserDrillOres.size(); ++i) {
                String oreDictName = ARConfiguration.getCurrentConfig().standardLaserDrillOres.get(i);
                String[] args = oreDictName.split(";");
                List items = ItemTags.func_199903_a().func_241834_b(new ResourceLocation(args[0])).func_230236_b_();
                LinkedList<ItemStack> globalOres = new LinkedList<ItemStack>();
                for (Item item : items) {
                    globalOres.add(item.func_190903_i());
                }
                if (globalOres != null && !globalOres.isEmpty()) {
                    int amt = 5;
                    if (args.length > 1) {
                        try {
                            amt = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException item) {
                            // empty catch block
                        }
                    }
                    this.ores.add(new ItemStack((IItemProvider)((ItemStack)globalOres.get(0)).func_77973_b(), amt));
                    continue;
                }
                String[] splitStr = oreDictName.split(";");
                ResourceLocation name = ResourceLocation.func_208304_a((String)splitStr[0]);
                if (name == null) {
                    AdvancedRocketry.logger.error("Cannot load item or itemtag '" + name + "' for void Drill");
                    continue;
                }
                int size = 1;
                if (splitStr.length > 2) {
                    try {
                        size = Integer.parseInt(splitStr[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ItemStack stack = ItemStack.field_190927_a;
                if (!ForgeRegistries.ITEMS.containsKey(name)) {
                    AdvancedRocketry.logger.error("Cannot load item or itemtag '" + name + "' for void Drill");
                    continue;
                }
                stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(name), size);
                if (stack.func_190926_b()) continue;
                this.ores.add(stack);
            }
        }
    }

    @Override
    ItemStack[] performOperation() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.random.nextInt(10) == 0) {
            ItemStack item = this.ores.get(this.random.nextInt(this.ores.size()));
            ItemStack newStack = item.func_77946_l();
            items.add(newStack);
        } else {
            items.add(new ItemStack((IItemProvider)Blocks.field_150347_e, 5));
        }
        ItemStack[] stacks = new ItemStack[items.size()];
        stacks = items.toArray(stacks);
        return stacks;
    }

    @Override
    boolean activate(World world, int x, int z) {
        if (!this.planetOresInitialized) {
            DimensionProperties dimProperties = DimensionManager.getInstance().getDimensionProperties(world);
            this.ores.addAll(dimProperties.laserDrillOres.stream().filter(s -> !this.ores.contains(s)).collect(Collectors.toSet()));
            this.planetOresInitialized = true;
        }
        return true;
    }

    @Override
    void deactivate() {
    }

    @Override
    boolean isFinished() {
        return false;
    }

    @Override
    boolean needsRestart() {
        return false;
    }
}

