/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.satellite;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleData;
import zmaster587.advancedRocketry.inventory.modules.ModuleSatellite;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.satellite.SatelliteData;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.advancedRocketry.util.PlanetaryTravelHelper;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumer;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileSatelliteTerminal
extends TileInventoriedRFConsumer
implements INetworkMachine,
IModularInventory,
IButtonInventory,
IDataInventory {
    ModuleSatellite moduleSatellite;
    ModuleText moduleText;
    DataStorage data = new DataStorage();

    public TileSatelliteTerminal() {
        super(AdvancedRocketryTileEntityType.TILE_SAT_CONTROL, 10000, 2);
        this.data.setMaxData(1000);
        this.moduleSatellite = new ModuleSatellite(152, 10, this, 0);
    }

    public int[] func_180463_a(Direction side) {
        return new int[0];
    }

    public String getModularInventoryName() {
        return "container.satelliteMonitor";
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public boolean canPerformFunction() {
        return this.field_145850_b.func_82737_E() % 16L == 0L && this.getSatelliteFromSlot(0) != null;
    }

    public int getPowerPerOperation() {
        return 1;
    }

    public void performFunction() {
        if (this.field_145850_b.field_72995_K) {
            this.updateInventoryInfo();
        }
    }

    public void writeDataToNetwork(PacketBuffer out, byte packetId) {
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == 0) {
            this.storeData(0);
        } else if (id == 100) {
            SatelliteBase satellite = this.moduleSatellite.getSatellite();
            if (satellite != null && PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(satellite.getDimensionId().get(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
                satellite.performAction(player, this.field_145850_b, this.field_174879_c);
            }
        } else if (id == 101) {
            this.actionById(id - 100);
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        this.moduleSatellite.setSatellite(this.getSatelliteFromSlot(0));
        this.updateInventoryInfo();
    }

    public void updateInventoryInfo() {
        if (this.moduleText != null) {
            SatelliteBase satellite = this.moduleSatellite.getSatellite();
            if (satellite != null) {
                if (this.getUniversalEnergyStored() < this.getPowerPerOperation()) {
                    this.moduleText.setText(LibVulpes.proxy.getLocalizedString("msg.notenoughpower"));
                } else if (!PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(satellite.getDimensionId().get(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
                    this.moduleText.setText(satellite.getName() + "\n\n" + LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.toofar"));
                } else {
                    this.moduleText.setText(satellite.getName() + "\n\n" + LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.info") + "\n" + satellite.getInfo(this.field_145850_b));
                }
            } else {
                this.moduleText.setText(LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.nolink"));
            }
        }
    }

    public SatelliteBase getSatelliteFromSlot(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            ItemSatelliteIdentificationChip idchip = (ItemSatelliteIdentificationChip)stack.func_77973_b();
            return idchip.getSatellite(stack);
        }
        return null;
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this.energy));
        modules.add((ModuleBase)new ModuleButton(116, 70, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.connect"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild).setAdditionalData((Object)0));
        modules.add((ModuleBase)new ModuleButton(173, 3, "", (IButtonInventory)this, TextureResources.buttonKill, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.destroysat"), 24, 24).setAdditionalData((Object)1));
        modules.add(new ModuleData(28, 20, 1, this, this.data));
        modules.add((ModuleBase)this.moduleSatellite);
        this.moduleSatellite.setSatellite(this.getSatelliteFromSlot(0));
        this.moduleText = new ModuleText(60, 20, LibVulpes.proxy.getLocalizedString("msg.satctrlcenter.nolink"), 0x404040);
        modules.add((ModuleBase)this.moduleText);
        this.updateInventoryInfo();
        return modules;
    }

    private void actionById(int buttonId) {
        ItemStack stack;
        if (buttonId == 0) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(100 + buttonId)));
        } else if (buttonId == 1 && (stack = this.func_70301_a(0)) != null && stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
            ItemSatelliteIdentificationChip idchip = (ItemSatelliteIdentificationChip)stack.func_77973_b();
            SatelliteBase satellite = idchip.getSatellite(stack);
            if (satellite != null) {
                DimensionManager.getInstance().getDimensionProperties(satellite.getDimensionId().get()).removeSatellite(satellite.getId());
            }
            idchip.erase(stack);
            this.func_70299_a(0, stack);
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(100 + buttonId)));
        }
    }

    public void onInventoryButtonPressed(ModuleButton buttonId) {
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        CompoundNBT data = new CompoundNBT();
        this.data.writeToNBT(data);
        nbt.func_218657_a("data", (INBT)data);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        CompoundNBT data = nbt.func_74775_l("data");
        this.data.readFromNBT(data);
    }

    @Override
    public void loadData(int id) {
    }

    @Override
    public void storeData(int id) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack inv = this.func_70301_a(1);
            if (inv != null && inv.func_77973_b() instanceof ItemData && inv.func_190916_E() == 1) {
                ItemData dataItem = (ItemData)inv.func_77973_b();
                this.data.removeData(dataItem.addData(inv, this.data.getData(), this.data.getDataType()), true);
            }
        } else {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        }
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        SatelliteBase satellite = this.getSatelliteFromSlot(0);
        if (satellite != null && satellite instanceof SatelliteData && PlanetaryTravelHelper.isTravelAnywhereInPlanetarySystem(satellite.getDimensionId().get(), DimensionManager.getEffectiveDimId(this.field_145850_b, this.field_174879_c).getId())) {
            satellite.performAction(null, this.field_145850_b, this.field_174879_c);
        }
        if (type == this.data.getDataType() || this.data.getDataType() == DataStorage.DataType.UNDEFINED) {
            return this.data.removeData(maxAmount, commit);
        }
        return 0;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        return this.data.addData(maxAmount, type, commit);
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

