/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTextBox;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileDockingPort
extends TileEntity
implements IModularInventory,
IGuiCallback,
INetworkMachine {
    ModuleTextBox myId;
    ModuleTextBox targetId;
    String targetIdStr = "";
    String myIdStr = "";

    public TileDockingPort() {
        super(AdvancedRocketryTileEntityType.TILE_DOCKING_PORT);
    }

    public String getTargetId() {
        return this.targetIdStr;
    }

    public String getMyId() {
        return this.myIdStr;
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModuleText(20, 50, LibVulpes.proxy.getLocalizedString("msg.dockingport.target"), 0x2A2A2A));
        if (this.field_145850_b.field_72995_K) {
            this.myId = new ModuleTextBox((IGuiCallback)this, 20, 30, 60, 12, 9);
            this.targetId = new ModuleTextBox((IGuiCallback)this, 20, 60, 60, 12, 9);
            this.targetId.setText(this.targetIdStr);
            this.myId.setText(this.myIdStr);
            modules.add((ModuleBase)this.targetId);
            modules.add((ModuleBase)this.myId);
        }
        modules.add((ModuleBase)new ModuleText(20, 20, LibVulpes.proxy.getLocalizedString("msg.dockingport.me"), 0x2A2A2A));
        return modules;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        if (this.targetId != null) {
            this.targetId.setText(this.targetIdStr);
            this.myId.setText(this.myIdStr);
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        if (this.targetId != null) {
            this.targetId.setText(this.targetIdStr);
            this.myId.setText(this.myIdStr);
        }
    }

    public void onModuleUpdated(ModuleBase module) {
        if (module == this.myId) {
            this.myIdStr = this.myId.getText();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        } else if (module == this.targetId) {
            this.targetIdStr = this.targetId.getText();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 1));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.myIdStr.isEmpty()) {
            nbt.func_74778_a("myId", this.myIdStr);
        }
        if (!this.targetIdStr.isEmpty()) {
            nbt.func_74778_a("targetId", this.targetIdStr);
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.myIdStr = nbt.func_74779_i("myId");
        this.targetIdStr = nbt.func_74779_i("targetId");
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.unregisterTileWithStation(this.field_145850_b, this.field_174879_c);
    }

    public void onLoad() {
        super.onLoad();
        this.registerTileWithStation(this.field_145850_b, this.field_174879_c);
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.stationmarker";
    }

    public void registerTileWithStation(World world, BlockPos pos) {
        ISpaceObject spaceObj;
        if (!world.field_72995_K && ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)world)) && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos)) instanceof SpaceStationObject) {
            ((SpaceStationObject)spaceObj).addDockingPosition(pos, this.myIdStr);
        }
    }

    public void unregisterTileWithStation(World world, BlockPos pos) {
        ISpaceObject spaceObj;
        if (!world.field_72995_K && ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)world)) && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos)) instanceof SpaceStationObject) {
            ((SpaceStationObject)spaceObj).removeDockingPosition(pos);
        }
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 0) {
            PacketBuffer buff = new PacketBuffer((ByteBuf)out);
            buff.writeInt(this.myIdStr.length());
            buff.func_180714_a(this.myIdStr);
        } else if (id == 1) {
            PacketBuffer buff = new PacketBuffer((ByteBuf)out);
            buff.writeInt(this.targetIdStr.length());
            buff.func_180714_a(this.targetIdStr);
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        int len = in.readInt();
        PacketBuffer buff = new PacketBuffer((ByteBuf)in);
        nbt.func_74778_a("id", buff.func_150789_c(len));
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        if (id == 0) {
            ISpaceObject spaceObj;
            this.myIdStr = nbt.func_74779_i("id");
            if (!this.field_145850_b.field_72995_K && ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_145850_b)) && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceStationObject) {
                ((SpaceStationObject)spaceObj).addDockingPosition(this.field_174879_c, this.myIdStr);
            }
        } else if (id == 1) {
            this.targetIdStr = nbt.func_74779_i("id");
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

