/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileStationGravityController
extends TileEntity
implements IModularInventory,
ITickableTileEntity,
INetworkMachine,
ISliderBar {
    int progress;
    public static int minGravity = 10;
    private ModuleText moduleGrav = new ModuleText(6, 15, LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.alt"), 0xAA2020);
    private ModuleText maxGravBuildSpeed = new ModuleText(6, 25, LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.maxaltrate"), 0xAA2020);
    private ModuleText targetGrav = new ModuleText(6, 35, LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.tgtalt"), 0x202020);

    public TileStationGravityController() {
        super(AdvancedRocketryTileEntityType.TILE_STATION_GRAVITY_CONTROLLER);
        minGravity = (Boolean)ARConfiguration.getCurrentConfig().allowZeroGSpacestations.get() != false ? 0 : 10;
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.moduleGrav);
        modules.add((ModuleBase)this.maxGravBuildSpeed);
        modules.add((ModuleBase)this.targetGrav);
        modules.add((ModuleBase)new ModuleSlider(6, 60, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        this.updateText();
        return modules;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = this.func_189515_b(new CompoundNBT());
        SUpdateTileEntityPacket packet = new SUpdateTileEntityPacket(this.field_174879_c, 0, nbt);
        return packet;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    private void updateText() {
        if (this.field_145850_b.field_72995_K) {
            ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
            if (object != null) {
                this.moduleGrav.setText(String.format("%s%.2f", LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.alt"), Float.valueOf(object.getProperties().getGravitationalMultiplier())));
                this.maxGravBuildSpeed.setText(String.format("%s%.1f", LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.maxaltrate"), 7200.0 * object.getMaxRotationalAcceleration()));
            }
            this.targetGrav.setText(String.format("%s%d", LibVulpes.proxy.getLocalizedString("msg.stationgravctrl.tgtalt"), ((SpaceStationObject)object).targetGravity));
        }
    }

    public void func_73660_a() {
        if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_145850_b))) {
            if (!this.field_145850_b.field_72995_K) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
                if (object != null) {
                    this.progress = ((SpaceStationObject)object).targetGravity - minGravity;
                    int targetMultiplier = (Boolean)ARConfiguration.getCurrentConfig().allowZeroGSpacestations.get() != false ? ((SpaceStationObject)object).targetGravity : Math.max(11, ((SpaceStationObject)object).targetGravity);
                    double targetGravity = (double)targetMultiplier / 100.0;
                    double angVel = object.getProperties().getGravitationalMultiplier();
                    double acc = 0.001;
                    double difference = targetGravity - angVel;
                    if (Math.abs(difference) > 0.01) {
                        double finalVel = angVel;
                        if (difference < 0.0) {
                            finalVel = angVel + Math.max(difference, -acc);
                        } else if (difference > 0.0) {
                            finalVel = angVel + Math.min(difference, acc);
                        }
                        object.getProperties().setGravitationalMultiplier((float)finalVel);
                        if (!this.field_145850_b.field_72995_K) {
                            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(object, PacketStationUpdate.Type.DIM_PROPERTY_UPDATE));
                        } else {
                            this.updateText();
                        }
                    }
                }
            } else {
                this.updateText();
            }
        }
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.gravitycontroller";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 0) {
            out.writeShort(this.progress);
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == 0) {
            this.setProgress(0, in.readShort());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(0) / (float)this.getTotalProgress(0);
    }

    public void setProgress(int id, int progress) {
        this.progress = progress;
        if (SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c) != null) {
            ((SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords((BlockPos)this.field_174879_c)).targetGravity = progress + minGravity;
        }
    }

    public int getProgress(int id) {
        return this.progress;
    }

    public int getTotalProgress(int id) {
        return 100 - minGravity;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setProgressByUser(int id, int progress) {
        this.setProgress(id, progress);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

