/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileStationOrientationController
extends TileEntity
implements ITickableTileEntity,
IModularInventory,
INetworkMachine,
ISliderBar {
    int[] progress;
    private ModuleText moduleAngularVelocity = new ModuleText(6, 15, LibVulpes.proxy.getLocalizedString("msg.stationorientctrl.alt"), 0xAA2020);
    private ModuleText numThrusters;
    private ModuleText maxAngularAcceleration;
    private ModuleText targetRotations = new ModuleText(6, 25, LibVulpes.proxy.getLocalizedString("msg.stationorientctrl.tgtalt"), 0x202020);

    public TileStationOrientationController() {
        super(AdvancedRocketryTileEntityType.TILE_ORIENTATION_CONTROLLER);
        this.progress = new int[3];
        this.progress[0] = this.getTotalProgress(0) / 2;
        this.progress[1] = this.getTotalProgress(1) / 2;
        this.progress[2] = this.getTotalProgress(2) / 2;
    }

    public List<ModuleBase> getModules(int id, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.moduleAngularVelocity);
        modules.add((ModuleBase)this.targetRotations);
        modules.add((ModuleBase)new ModuleText(10, 54, "X:", 0x202020));
        modules.add((ModuleBase)new ModuleText(10, 69, "Y:", 0x202020));
        modules.add((ModuleBase)new ModuleSlider(24, 50, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        modules.add((ModuleBase)new ModuleSlider(24, 65, 1, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        this.updateText();
        return modules;
    }

    private void updateText() {
        if (this.field_145850_b.field_72995_K) {
            ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
            if (object != null) {
                this.moduleAngularVelocity.setText(String.format("%s%.1f %.1f %.1f", LibVulpes.proxy.getLocalizedString("msg.stationorientctrl.alt"), 72000.0 * object.getDeltaRotation(Direction.EAST), 72000.0 * object.getDeltaRotation(Direction.UP), 7200.0 * object.getDeltaRotation(Direction.NORTH)));
            }
            int[] targetRotationsPerHour = ((SpaceStationObject)object).targetRotationsPerHour;
            this.targetRotations.setText(String.format("%s%d %d %d", LibVulpes.proxy.getLocalizedString("msg.stationorientctrl.tgtalt"), targetRotationsPerHour[0], targetRotationsPerHour[1], targetRotationsPerHour[2]));
        }
    }

    public void func_73660_a() {
        if (ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_145850_b))) {
            if (!this.field_145850_b.field_72995_K) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c);
                boolean update = false;
                if (object != null) {
                    int i;
                    Direction[] dirs = new Direction[]{Direction.EAST, Direction.UP, Direction.NORTH};
                    int[] targetRotationsPerHour = ((SpaceStationObject)object).targetRotationsPerHour;
                    for (i = 0; i < 3; ++i) {
                        this.setProgress(i, targetRotationsPerHour[i] + this.getTotalProgress(i) / 2);
                    }
                    for (i = 0; i < 3; ++i) {
                        double targetAngularVelocity = (double)targetRotationsPerHour[i] / 72000.0;
                        double angVel = object.getDeltaRotation(dirs[i]);
                        double acc = object.getMaxRotationalAcceleration();
                        double difference = targetAngularVelocity - angVel;
                        if (difference == 0.0) continue;
                        double finalVel = angVel;
                        if (difference < 0.0) {
                            finalVel = angVel + Math.max(difference, -acc);
                        } else if (difference > 0.0) {
                            finalVel = angVel + Math.min(difference, acc);
                        }
                        object.setDeltaRotation(finalVel, dirs[i]);
                        update = true;
                    }
                    if (!this.field_145850_b.field_72995_K && update) {
                        PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(object, PacketStationUpdate.Type.ROTANGLE_UPDATE));
                    }
                } else {
                    this.updateText();
                }
            } else {
                this.updateText();
            }
        }
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.orientationcontroller";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 0) {
            out.writeShort(this.progress[0]);
            out.writeShort(this.progress[1]);
            out.writeShort(this.progress[2]);
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == 0) {
            nbt.func_74777_a("0", in.readShort());
            nbt.func_74777_a("1", in.readShort());
            nbt.func_74777_a("2", in.readShort());
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        this.setProgress(0, nbt.func_74765_d("0"));
        this.setProgress(1, nbt.func_74765_d("1"));
        this.setProgress(2, nbt.func_74765_d("2"));
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
    }

    public void setProgress(int id, int progress) {
        this.progress[id] = progress;
        if (SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c) != null) {
            ((SpaceStationObject)SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)).setTargetRotationsPerHour(id, progress - this.getTotalProgress(id) / 2);
        }
    }

    public int getProgress(int id) {
        return this.progress[id];
    }

    public int getTotalProgress(int id) {
        return 120;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setProgressByUser(int id, int progress) {
        this.setProgress(id, progress);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(this.getModularInvType().ordinal(), player), (IModularInventory)this, this.getModularInvType());
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULAR;
    }
}

