/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkHooks;
import zmaster587.advancedRocketry.achievements.ARAdvancements;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryTileEntityType;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.ModuleData;
import zmaster587.advancedRocketry.inventory.modules.ModulePanetImage;
import zmaster587.advancedRocketry.inventory.modules.ModulePlanetSelector;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.item.ItemPlanetIdentificationChip;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.tile.multiblock.TileWarpCore;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.advancedRocketry.world.util.MultiData;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibvulpesGuiRegistry;
import zmaster587.libVulpes.client.util.IndicatorBarImage;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.inventory.ContainerModular;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IDataSync;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ISelectionNotify;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleScaledImage;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleSync;
import zmaster587.libVulpes.inventory.modules.ModuleTab;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTexturedSlotArray;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.EmbeddedInventory;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileWarpController
extends TileEntity
implements ITickableTileEntity,
IModularInventory,
ISelectionNotify,
INetworkMachine,
IButtonInventory,
IProgressBar,
IDataSync,
IGuiCallback,
IDataInventory,
IPlanetDefiner {
    protected ModulePlanetSelector container;
    private ModuleText canWarp;
    DimensionProperties dimCache;
    private SpaceStationObject station;
    private static final int ARTIFACT_BEGIN_RANGE = 4;
    private static final int ARTIFACT_END_RANGE = 8;
    ModulePanetImage srcPlanetImg;
    ModulePanetImage dstPlanetImg;
    ModuleSync sync3;
    ModuleText srcPlanetText;
    ModuleText dstPlanetText;
    ModuleText warpFuel;
    ModuleText status;
    ModuleText warpCapacity;
    int warpCost = -1;
    private ModuleTab tabModule = new ModuleTab(4, 0, 0, (IGuiCallback)this, 3, new String[]{LibVulpes.proxy.getLocalizedString("msg.warpmon.tab.warp"), LibVulpes.proxy.getLocalizedString("msg.warpmon.tab.data"), LibVulpes.proxy.getLocalizedString("msg.warpmon.tab.tracking")}, (ResourceLocation[][])new ResourceLocation[][]{TextureResources.tabWarp, TextureResources.tabData, TextureResources.tabPlanetTracking});
    private static final byte TAB_SWITCH = 4;
    private static final byte STORE_DATA = 10;
    private static final byte LOAD_DATA = 20;
    private static final byte SEARCH = 5;
    private static final byte PROGRAMFROMCHIP = 6;
    private MultiData data = new MultiData();
    private EmbeddedInventory inv;
    private static final int DISTANCESLOT = 0;
    private static final int MASSSLOT = 1;
    private static final int COMPOSITION = 2;
    private static final int PLANETSLOT = 3;
    private static final int MAX_PROGRESS = 1000;
    private ModuleProgress programmingProgress;
    private int progress;
    private boolean openFullScreen = false;

    public TileWarpController() {
        super(AdvancedRocketryTileEntityType.TILE_WARP_SHIP_CONTROLLER);
        this.data.setMaxData(10000);
        this.inv = new EmbeddedInventory(9);
        this.programmingProgress = new ModuleProgress(35, 80, 3, TextureResources.terraformProgressBar, (IProgressBar)this);
        this.progress = -1;
    }

    private SpaceStationObject getSpaceObject() {
        ISpaceObject object;
        if (this.station == null && ARConfiguration.GetSpaceDimId().equals((Object)ZUtils.getDimensionIdentifier((World)this.field_145850_b)) && (object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceStationObject) {
            this.station = (SpaceStationObject)object;
        }
        return this.station;
    }

    protected int getTravelCost() {
        if (this.getSpaceObject() != null) {
            DimensionProperties properties = this.getSpaceObject().getProperties().getParentProperties();
            DimensionProperties destProperties = DimensionManager.getInstance().getDimensionProperties(this.getSpaceObject().getDestOrbitingBody());
            if (properties == DimensionManager.defaultSpaceDimensionProperties) {
                return Integer.MAX_VALUE;
            }
            if (destProperties.getStar() != properties.getStar()) {
                return 500;
            }
            while (destProperties.getParentProperties() != null && destProperties.isMoon()) {
                destProperties = destProperties.getParentProperties();
            }
            if (destProperties.isMoon() && destProperties.getParentPlanet() == properties.getId() || properties.isMoon() && properties.getParentPlanet() == destProperties.getId()) {
                return 1;
            }
            while (properties.isMoon()) {
                properties = properties.getParentProperties();
            }
            if (properties.getStar().getId() == destProperties.getStar().getId()) {
                double x1 = (float)properties.orbitalDist * MathHelper.func_76134_b((float)((float)properties.orbitTheta));
                double y1 = (float)properties.orbitalDist * MathHelper.func_76126_a((float)((float)properties.orbitTheta));
                double x2 = (float)destProperties.orbitalDist * MathHelper.func_76134_b((float)((float)destProperties.orbitTheta));
                double y2 = (float)destProperties.orbitalDist * MathHelper.func_76126_a((float)((float)destProperties.orbitTheta));
                return Math.max((int)Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0)), 1);
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        return this.data.addData(maxAmount, type, dir, commit);
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, Direction dir, boolean commit) {
        return this.data.extractData(maxAmount, type, dir, commit);
    }

    public List<ModuleBase> getModules(int ID, PlayerEntity player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        if (ID == GuiHandler.guiId.MODULARNOINV.ordinal()) {
            if (this.tabModule.getTab() == 0) {
                boolean artifactFlag;
                boolean isOnStation;
                modules.add((ModuleBase)this.tabModule);
                if (this.sync3 == null) {
                    this.sync3 = new ModuleSync(2, (IDataSync)this);
                }
                modules.add((ModuleBase)this.sync3);
                SpaceStationObject station = this.getSpaceObject();
                boolean bl = isOnStation = station != null;
                if (this.field_145850_b.field_72995_K) {
                    this.setPlanetModuleInfo();
                }
                int baseX = 10;
                int baseY = 20;
                int sizeX = 70;
                int sizeY = 70;
                if (this.field_145850_b.field_72995_K) {
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY, sizeX, sizeY, zmaster587.libVulpes.inventory.TextureResources.starryBG));
                    modules.add(this.srcPlanetImg);
                    ModuleText text = new ModuleText(baseX + 4, baseY + 4, "Orbiting:", 0xFFFFFF);
                    text.setAlwaysOnTop(true);
                    modules.add((ModuleBase)text);
                    modules.add((ModuleBase)this.srcPlanetText);
                    modules.add((ModuleBase)new ModuleScaledImage(baseX - 3, baseY, 3, sizeY, TextureResources.verticalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX + sizeX, baseY, -3, sizeY, TextureResources.verticalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY, 70, 3, TextureResources.horizontalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY + sizeY - 3, 70, -3, TextureResources.horizontalBar));
                }
                modules.add((ModuleBase)new ModuleButton(baseX - 3, baseY + sizeY, LibVulpes.proxy.getLocalizedString("msg.warpmon.selectplanet"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, sizeX + 6, 16).setAdditionalData((Object)0));
                modules.add((ModuleBase)new ModuleText(baseX, baseY + sizeY + 20, LibVulpes.proxy.getLocalizedString("msg.warpmon.corestatus"), 0x1B1B1B));
                boolean flag = isOnStation && this.getSpaceObject().getFuelAmount() >= this.getTravelCost() && this.getSpaceObject().hasUsableWarpCore();
                flag = flag && (!isOnStation || !Constants.INVALID_PLANET.equals((Object)this.getSpaceObject().getDestOrbitingBody()) && this.getSpaceObject().getOrbitingPlanetId() != this.getSpaceObject().getDestOrbitingBody());
                boolean bl2 = artifactFlag = this.dimCache != null && this.meetsArtifactReq(this.dimCache);
                this.canWarp = new ModuleText(baseX, baseY + sizeY + 30, this.getSpaceObject().isAnchored() ? LibVulpes.proxy.getLocalizedString("msg.warpmon.anchored") : (isOnStation && (this.getSpaceObject().getDestOrbitingBody() == Constants.INVALID_PLANET || this.getSpaceObject().getOrbitingPlanetId().equals((Object)this.getSpaceObject().getDestOrbitingBody())) ? LibVulpes.proxy.getLocalizedString("msg.warpmon.nowhere") : (!artifactFlag ? LibVulpes.proxy.getLocalizedString("msg.warpmon.missingart") : (flag ? LibVulpes.proxy.getLocalizedString("msg.warpmon.ready") : LibVulpes.proxy.getLocalizedString("msg.warpmon.notready")))), flag && artifactFlag && !this.getSpaceObject().isAnchored() ? 0x1BAA1B : 0xFF1B1B);
                modules.add((ModuleBase)this.canWarp);
                modules.add((ModuleBase)new ModuleProgress(baseX, baseY + sizeY + 40, 10, (ProgressBarImage)new IndicatorBarImage(70, 58, 53, 8, 122, 58, 5, 8, Direction.EAST, TextureResources.progressBars), (IProgressBar)this));
                this.warpCost = this.getTravelCost();
                baseX = 94;
                baseY = 20;
                sizeX = 70;
                sizeY = 70;
                ModuleButton warp = new ModuleButton(baseX - 3, baseY + sizeY, LibVulpes.proxy.getLocalizedString("msg.warpmon.warp"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, sizeX + 6, 16).setAdditionalData((Object)1);
                modules.add((ModuleBase)warp);
                if (this.dimCache == null && isOnStation && !SpaceObjectManager.WARPDIMID.equals((Object)station.getOrbitingPlanetId())) {
                    this.dimCache = DimensionManager.getInstance().getDimensionProperties(station.getOrbitingPlanetId());
                }
                if (!this.field_145850_b.field_72995_K && isOnStation) {
                    PacketHandler.sendToPlayer((BasePacket)new PacketSpaceStationInfo(this.getSpaceObject().getId(), this.getSpaceObject()), (PlayerEntity)player);
                }
                if (this.field_145850_b.field_72995_K) {
                    this.warpFuel.setText(LibVulpes.proxy.getLocalizedString("msg.warpmon.fuelcost") + (flag ? String.valueOf(this.warpCost) : LibVulpes.proxy.getLocalizedString("msg.warpmon.na")));
                    this.warpCapacity.setText(LibVulpes.proxy.getLocalizedString("msg.warpmon.fuel") + (isOnStation ? Integer.valueOf(this.getSpaceObject().getFuelAmount()) : LibVulpes.proxy.getLocalizedString("msg.warpmon.na")));
                    modules.add((ModuleBase)this.warpFuel);
                    modules.add((ModuleBase)this.warpCapacity);
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY, sizeX, sizeY, zmaster587.libVulpes.inventory.TextureResources.starryBG));
                    if (this.dimCache != null && this.field_145850_b.field_72995_K) {
                        modules.add(this.dstPlanetImg);
                    }
                    ModuleText text = new ModuleText(baseX + 4, baseY + 4, LibVulpes.proxy.getLocalizedString("msg.warpmon.dest"), 0xFFFFFF);
                    modules.add((ModuleBase)text);
                    modules.add((ModuleBase)this.dstPlanetText);
                    modules.add((ModuleBase)new ModuleScaledImage(baseX - 3, baseY, 3, sizeY, TextureResources.verticalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX + sizeX, baseY, -3, sizeY, TextureResources.verticalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY, 70, 3, TextureResources.horizontalBar));
                    modules.add((ModuleBase)new ModuleScaledImage(baseX, baseY + sizeY - 3, 70, -3, TextureResources.horizontalBar));
                }
            } else if (this.tabModule.getTab() == 1) {
                modules.add((ModuleBase)this.tabModule);
                modules.add(new ModuleData(35, 20, 0, this, this.data.getDataStorageForType(DataStorage.DataType.DISTANCE)));
                modules.add(new ModuleData(75, 20, 1, this, this.data.getDataStorageForType(DataStorage.DataType.MASS)));
                modules.add(new ModuleData(115, 20, 2, this, this.data.getDataStorageForType(DataStorage.DataType.COMPOSITION)));
            } else {
                modules.add((ModuleBase)this.tabModule);
                modules.add((ModuleBase)new ModuleText(65, 20, LibVulpes.proxy.getLocalizedString("msg.warpmon.artifact"), 0x202020));
                modules.add((ModuleBase)new ModuleSlotArray(30, 35, (IInventory)this, 4, 5));
                modules.add((ModuleBase)new ModuleSlotArray(55, 60, (IInventory)this, 5, 6));
                modules.add((ModuleBase)new ModuleSlotArray(80, 35, (IInventory)this, 6, 7));
                modules.add((ModuleBase)new ModuleSlotArray(105, 60, (IInventory)this, 7, 8));
                modules.add((ModuleBase)new ModuleSlotArray(130, 35, (IInventory)this, 8, 9));
                modules.add((ModuleBase)new ModuleButton(50, 117, LibVulpes.proxy.getLocalizedString("msg.warpmon.search"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, LibVulpes.proxy.getLocalizedString("msg.warpmon.datareq"), 100, 10).setAdditionalData((Object)3));
                modules.add((ModuleBase)new ModuleButton(50, 127, LibVulpes.proxy.getLocalizedString("msg.warpmon.chip"), (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 100, 10).setAdditionalData((Object)4));
                modules.add((ModuleBase)new ModuleTexturedSlotArray(30, 120, (IInventory)this, 3, 4, TextureResources.idChip));
                modules.add((ModuleBase)this.programmingProgress);
            }
        } else if (ID == GuiHandler.guiId.MODULARFULLSCREEN.ordinal()) {
            SpaceStationObject station = this.getSpaceObject();
            ResourceLocation starId = Constants.INVALID_STAR;
            if (station != null) {
                starId = station.getProperties().getParentProperties().getStar().getId();
            }
            this.container = new ModulePlanetSelector(starId, zmaster587.libVulpes.inventory.TextureResources.starryBG, this, this, true);
            this.container.setOffset(1000, 1000);
            this.container.setAllowStarSelection(true);
            modules.add((ModuleBase)this.container);
        }
        return modules;
    }

    private void setPlanetModuleInfo() {
        boolean flag;
        String planetName;
        DimensionProperties location;
        boolean isOnStation;
        SpaceStationObject station = this.getSpaceObject();
        boolean bl = isOnStation = station != null;
        if (isOnStation) {
            DimensionProperties properties;
            location = properties = DimensionManager.getInstance().getDimensionProperties(station.getOrbitingPlanetId());
            planetName = properties.getName();
        } else {
            location = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b);
            planetName = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b).getName();
            if (planetName.isEmpty()) {
                planetName = "???";
            }
        }
        boolean bl2 = flag = isOnStation && this.getSpaceObject().getFuelAmount() >= this.warpCost && this.getSpaceObject().hasUsableWarpCore();
        if (this.canWarp != null) {
            boolean artifactFlag;
            flag = flag && (!isOnStation || !Constants.INVALID_PLANET.equals((Object)this.getSpaceObject().getDestOrbitingBody()) && !this.getSpaceObject().getOrbitingPlanetId().equals((Object)this.getSpaceObject().getDestOrbitingBody()));
            boolean bl3 = artifactFlag = this.dimCache != null && this.meetsArtifactReq(this.dimCache);
            this.canWarp.setText(this.getSpaceObject().isAnchored() ? LibVulpes.proxy.getLocalizedString("msg.warpmon.anchored") : (isOnStation && (this.getSpaceObject().getDestOrbitingBody() == Constants.INVALID_PLANET || this.getSpaceObject().getOrbitingPlanetId() == this.getSpaceObject().getDestOrbitingBody()) ? LibVulpes.proxy.getLocalizedString("msg.warpmon.nowhere") : (!artifactFlag ? LibVulpes.proxy.getLocalizedString("msg.warpmon.missingart") : (flag ? LibVulpes.proxy.getLocalizedString("msg.warpmon.ready") : LibVulpes.proxy.getLocalizedString("msg.warpmon.notready")))));
            this.canWarp.setColor(flag && artifactFlag && !this.getSpaceObject().isAnchored() ? 0x1BAA1B : 0xFF1B1B);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.srcPlanetImg == null) {
                int baseX = 10;
                int baseY = 20;
                int sizeX = 65;
                int sizeY = 65;
                this.srcPlanetImg = new ModulePanetImage(baseX + 10, baseY + 10, sizeX - 20, location);
                this.srcPlanetText = new ModuleText(baseX + 4, baseY + 56, "", 0xFFFFFF);
                this.srcPlanetText.setAlwaysOnTop(true);
                this.warpFuel = new ModuleText(baseX + 100, baseY + sizeY + 25, "", 0x1B1B1B);
                this.warpCapacity = new ModuleText(baseX + 100, baseY + sizeY + 35, "", 0x1B1B1B);
                baseX = 94;
                baseY = 20;
                sizeX = 65;
                sizeY = 65;
                this.dstPlanetImg = new ModulePanetImage(baseX + 10, baseY + 10, sizeX - 20, location);
                this.dstPlanetText = new ModuleText(baseX + 4, baseY + 56, "", 0xFFFFFF);
                this.dstPlanetText.setAlwaysOnTop(true);
            }
            this.srcPlanetImg.setDimProperties(location);
            this.srcPlanetText.setText(planetName);
            this.warpFuel.setText(LibVulpes.proxy.getLocalizedString("msg.warpmon.fuelcost") + (this.warpCost < Integer.MAX_VALUE ? String.valueOf(this.warpCost) : LibVulpes.proxy.getLocalizedString("msg.warpmon.na")));
            this.warpCapacity.setText(LibVulpes.proxy.getLocalizedString("msg.warpmon.fuel") + (isOnStation ? Integer.valueOf(station.getFuelAmount()) : LibVulpes.proxy.getLocalizedString("msg.warpmon.na")));
            DimensionProperties dstProps = null;
            if (isOnStation && !SpaceObjectManager.WARPDIMID.equals((Object)station.getOrbitingPlanetId()) && station.getDestOrbitingBody() != null) {
                ResourceLocation dstBody = station.getDestOrbitingBody();
                if (DimensionManager.getInstance().isStar(dstBody)) {
                    DimensionProperties starProps = new DimensionProperties(dstBody);
                    starProps.setStar(dstBody);
                    starProps.setName(starProps.getStar().getName());
                    dstProps = starProps;
                } else {
                    dstProps = DimensionManager.getInstance().getDimensionProperties(station.getDestOrbitingBody());
                }
            }
            if (dstProps != null) {
                planetName = dstProps.getName();
                location = dstProps;
                this.dstPlanetImg.setDimProperties(location);
                this.dstPlanetText.setText(planetName);
                this.dstPlanetImg.setVisible(true);
            } else {
                this.dstPlanetText.setText("???");
                this.dstPlanetImg.setVisible(false);
            }
        }
    }

    public String getModularInventoryName() {
        return "block.advancedrocketry.stationmonitor";
    }

    public boolean canInteractWithContainer(PlayerEntity entity) {
        return true;
    }

    public void onInventoryButtonPressed(ModuleButton button) {
        if (this.getSpaceObject() != null) {
            int buttonId = (Integer)button.getAdditionalData();
            if (buttonId == 0) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
            } else if (buttonId == 1) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
            } else if (buttonId == 3) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 5));
            } else if (buttonId == 4) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 6));
            }
        }
    }

    public void writeDataToNetwork(PacketBuffer out, byte id) {
        if (id == 1 || id == 3) {
            out.func_180714_a(this.container.getSelectedSystem().toString());
        } else if (id == 4) {
            out.writeShort(this.tabModule.getTab());
        } else if (id >= 10 && id < 20) {
            out.writeByte(id - 10);
        } else if (id >= 20 && id < 30) {
            out.writeByte(id - 20);
        }
    }

    public void readDataFromNetwork(PacketBuffer in, byte packetId, CompoundNBT nbt) {
        if (packetId == 1 || packetId == 3) {
            nbt.func_74778_a("id", in.func_218666_n());
        } else if (packetId == 4) {
            nbt.func_74777_a("tab", in.readShort());
        } else if (packetId >= 10 && packetId < 20) {
            nbt.func_74774_a("id", (byte)(in.readByte() - 10));
        } else if (packetId >= 20 && packetId < 30) {
            nbt.func_74774_a("id", (byte)(in.readByte() - 20));
        }
    }

    public void useNetworkData(PlayerEntity player, Dist side, byte id, CompoundNBT nbt) {
        ItemStack stack;
        SpaceStationObject obj;
        if (id == 0) {
            this.openFullScreen = true;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> {
                buf.writeInt(GuiHandler.guiId.MODULARFULLSCREEN.ordinal());
                buf.func_179255_a(this.field_174879_c);
            });
        } else if (id == 1 || id == 3) {
            ISpaceObject station;
            ResourceLocation dimId = new ResourceLocation(nbt.func_74779_i("id"));
            if (this.isPlanetKnown(DimensionManager.getInstance().getDimensionProperties(dimId))) {
                this.container.setSelectedSystem(dimId);
                this.selectSystem(dimId);
            }
            if (id == 3 && (station = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_174877_v())) != null) {
                station.setDestOrbitingBody(dimId);
            }
            this.func_70296_d();
            if (id == 3) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> {
                    buf.writeInt(this.getModularInvType().ordinal());
                    buf.func_179255_a(this.field_174879_c);
                });
            }
        } else if (id == 2) {
            final SpaceStationObject station = this.getSpaceObject();
            if (station != null && !station.isAnchored() && station.hasUsableWarpCore() && station.useFuel(this.getTravelCost()) != 0 && this.meetsArtifactReq(DimensionManager.getInstance().getDimensionProperties(station.getDestOrbitingBody()))) {
                SpaceObjectManager.getSpaceManager().moveStationToBody((ISpaceObject)station, station.getDestOrbitingBody(), Math.max(Math.min(this.getTravelCost() * 5, 5000), 0));
                for (PlayerEntity player2 : ((ServerWorld)this.field_145850_b).func_217490_a((Predicate)new com.google.common.base.Predicate<PlayerEntity>(){

                    public boolean apply(PlayerEntity input) {
                        return SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(new BlockPos(input.func_213303_ch())) == station;
                    }
                })) {
                    ARAdvancements.triggerAchievement(ARAdvancements.ALL_SHE_GOT, (ServerPlayerEntity)player2);
                    if (DimensionManager.hasReachedWarp) continue;
                    ARAdvancements.triggerAchievement(ARAdvancements.FLIGHT_OF_PHEONIX, (ServerPlayerEntity)player2);
                }
                DimensionManager.hasReachedWarp = true;
                for (HashedBlockPosition vec : station.getWarpCoreLocations()) {
                    TileEntity tile = this.field_145850_b.func_175625_s(vec.getBlockPos());
                    if (tile == null || !(tile instanceof TileWarpCore)) continue;
                    ((TileWarpCore)tile).onInventoryUpdated();
                }
            }
        } else if (id == 4 && !this.field_145850_b.field_72995_K) {
            this.tabModule.setTab((int)nbt.func_74765_d("tab"));
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> {
                buf.writeInt(this.getModularInvType().ordinal());
                buf.func_179255_a(this.field_174879_c);
            });
        } else if (id >= 10 && id < 20) {
            this.storeData(nbt.func_74771_c("id") + 10);
        } else if (id >= 20 && id < 30) {
            this.loadData(nbt.func_74771_c("id") + 20);
        } else if (id == 5) {
            if (this.progress == -1 && this.data.getDataAmount(DataStorage.DataType.COMPOSITION) >= 100 && this.data.getDataAmount(DataStorage.DataType.DISTANCE) >= 100 && this.data.getDataAmount(DataStorage.DataType.MASS) >= 100) {
                this.progress = 0;
            }
        } else if (id == 6 && (obj = this.getSpaceObject()) != null && (stack = this.func_70301_a(3)) != null && stack.func_77973_b() instanceof ItemPlanetIdentificationChip) {
            if (DimensionManager.getInstance().isDimensionCreated(((ItemPlanetIdentificationChip)stack.func_77973_b()).getDimensionId(stack))) {
                // empty if block
            }
            obj.discoverPlanet(((ItemPlanetIdentificationChip)stack.func_77973_b()).getDimensionId(stack));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.inv.write(compound);
        this.data.writeToNBT(compound);
        compound.func_74768_a("progress", this.progress);
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inv.readFromNBT(compound);
        this.data.readFromNBT(compound);
        this.progress = compound.func_74762_e("progress");
    }

    public void onSelectionConfirmed(Object sender) {
        this.onSelected(sender);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 3));
    }

    public void onSelected(Object sender) {
        this.selectSystem(this.container.getSelectedSystem());
    }

    private void selectSystem(ResourceLocation dimId) {
        this.dimCache = SpaceObjectManager.WARPDIMID.equals((Object)this.getSpaceObject().getOrbitingPlanetId()) || SpaceObjectManager.WARPDIMID.equals((Object)dimId) ? null : DimensionManager.getInstance().getDimensionProperties(this.container.getSelectedSystem());
    }

    public void onSystemFocusChanged(Object sender) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 1));
    }

    public float getNormallizedProgress(int id) {
        if (this.field_145850_b.field_72995_K) {
            this.setPlanetModuleInfo();
        }
        return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
    }

    public void setProgress(int id, int progress) {
        if (id == 10) {
            if (this.getSpaceObject() != null) {
                this.getSpaceObject().setFuelAmount(progress);
            }
        } else if (id == 3) {
            this.progress = progress;
        }
    }

    public int getProgress(int id) {
        if (id == 10 && this.getSpaceObject() != null) {
            return this.getSpaceObject().getFuelAmount();
        }
        if (id == 0) {
            return 30;
        }
        if (id == 1) {
            return 30;
        }
        if (id == 2) {
            return 30;
        }
        if (id == 3) {
            return this.progress == -1 ? 0 : this.progress;
        }
        return 0;
    }

    public int getTotalProgress(int id) {
        if (id == 10 && this.getSpaceObject() != null) {
            return this.getSpaceObject().getMaxFuelAmount();
        }
        if (this.dimCache == null) {
            return 0;
        }
        if (id == 0) {
            return this.dimCache.getAtmosphereDensity() / 2;
        }
        if (id == 1) {
            return this.dimCache.orbitalDist / 2;
        }
        if (id == 2) {
            return (int)(this.dimCache.gravitationalMultiplier * 50.0f);
        }
        if (id == 3) {
            return 1000;
        }
        return 0;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setData(int id, int value) {
        if (id == 2) {
            this.warpCost = value;
        }
        this.setPlanetModuleInfo();
    }

    public int getData(int id) {
        if (id == 2) {
            return this.getTravelCost();
        }
        SpaceStationObject station = this.getSpaceObject();
        boolean isOnStation = station != null;
        return 0;
    }

    public void onModuleUpdated(ModuleBase module) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 4));
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public void func_174889_b(PlayerEntity player) {
        this.inv.func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.inv.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inv.func_94041_b(index, stack);
    }

    public void func_174888_l() {
    }

    @Override
    public void loadData(int id) {
        ItemData item;
        ItemStack stack = null;
        DataStorage.DataType type = DataStorage.DataType.HUMIDITY;
        if (id == 0) {
            stack = this.inv.func_70301_a(0);
            type = DataStorage.DataType.DISTANCE;
        } else if (id == 1) {
            stack = this.inv.func_70301_a(1);
            type = DataStorage.DataType.MASS;
        } else if (id == 2) {
            stack = this.inv.func_70301_a(2);
            type = DataStorage.DataType.COMPOSITION;
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemData && (item = (ItemData)stack.func_77973_b()).getDataType(stack) == type) {
            item.removeData(stack, this.addData(item.getData(stack), item.getDataType(stack), Direction.UP, true), type);
        }
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(20 + id)));
        }
    }

    @Override
    public void storeData(int id) {
        ItemStack stack = null;
        DataStorage.DataType type = null;
        if (id == 0) {
            stack = this.inv.func_70301_a(0);
            type = DataStorage.DataType.DISTANCE;
        } else if (id == 1) {
            stack = this.inv.func_70301_a(1);
            type = DataStorage.DataType.MASS;
        } else if (id == 2) {
            stack = this.inv.func_70301_a(2);
            type = DataStorage.DataType.COMPOSITION;
        }
        if (stack != null && stack.func_77973_b() instanceof ItemData) {
            ItemData item = (ItemData)stack.func_77973_b();
            this.data.extractData(item.addData(stack, this.data.getDataAmount(type), type), type, Direction.UP, true);
        }
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)(10 + id)));
        }
    }

    private boolean meetsArtifactReq(DimensionProperties properties) {
        if (properties.getRequiredArtifacts().isEmpty()) {
            return true;
        }
        LinkedList<ItemStack> list = new LinkedList<ItemStack>(properties.getRequiredArtifacts());
        for (int i = 4; i <= 8; ++i) {
            ItemStack stack2 = this.func_70301_a(i);
            if (stack2 == null) continue;
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                ItemStack stackInList = (ItemStack)itr.next();
                if (!stackInList.func_77973_b().equals(stack2.func_77973_b()) || stackInList.func_77952_i() != stack2.func_77952_i() || !ItemStack.func_77970_a((ItemStack)stackInList, (ItemStack)stack2) || stack2.func_190916_E() < stackInList.func_190916_E()) continue;
                itr.remove();
            }
        }
        return list.isEmpty();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.progress != -1) {
            ++this.progress;
            if (this.progress >= 1000) {
                ItemStack stack;
                SpaceStationObject obj = this.getSpaceObject();
                if (Math.abs(this.field_145850_b.field_73012_v.nextInt()) % (Integer)ARConfiguration.getCurrentConfig().planetDiscoveryChance.get() == 0 && obj != null && (stack = this.func_70301_a(3)) != null && stack.func_77973_b() instanceof ItemPlanetIdentificationChip) {
                    DimensionProperties props;
                    ItemPlanetIdentificationChip item = (ItemPlanetIdentificationChip)stack.func_77973_b();
                    LinkedList<ResourceLocation> unknownPlanets = new LinkedList<ResourceLocation>();
                    for (ResourceLocation id : DimensionManager.getInstance().getLoadedDimensions()) {
                        props = DimensionManager.getInstance().getDimensionProperties(id);
                        if (this.isPlanetKnown(props) || props.getRequiredArtifacts().isEmpty() || !this.meetsArtifactReq(props)) continue;
                        unknownPlanets.add(id);
                    }
                    if (unknownPlanets.isEmpty()) {
                        for (ResourceLocation id : DimensionManager.getInstance().getLoadedDimensions()) {
                            props = DimensionManager.getInstance().getDimensionProperties(id);
                            if (this.isPlanetKnown(props) || !props.getRequiredArtifacts().isEmpty()) continue;
                            unknownPlanets.add(id);
                        }
                    }
                    if (!unknownPlanets.isEmpty()) {
                        int newIndex = (int)(this.field_145850_b.field_73012_v.nextFloat() * (float)unknownPlanets.size());
                        ResourceLocation newId = (ResourceLocation)unknownPlanets.get(newIndex);
                        item.setDimensionId(stack, newId);
                        obj.discoverPlanet(newId);
                    }
                }
                this.data.extractData(100, DataStorage.DataType.COMPOSITION, Direction.UP, true);
                this.data.extractData(100, DataStorage.DataType.DISTANCE, Direction.UP, true);
                this.data.extractData(100, DataStorage.DataType.MASS, Direction.UP, true);
                this.progress = -1;
            }
        }
    }

    @Override
    public boolean isPlanetKnown(IDimensionProperties properties) {
        SpaceStationObject obj = this.getSpaceObject();
        if (obj != null) {
            return obj.isPlanetKnown(properties);
        }
        return false;
    }

    @Override
    public boolean isStarKnown(StellarBody body) {
        SpaceStationObject obj = this.getSpaceObject();
        if (obj != null) {
            return obj.isStarKnown(body);
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getModularInventoryName());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        GuiHandler.guiId guiType = this.openFullScreen ? GuiHandler.guiId.MODULARFULLSCREEN : this.getModularInvType();
        this.openFullScreen = false;
        return new ContainerModular(LibvulpesGuiRegistry.CONTAINER_MODULAR_TILE, id, player, this.getModules(guiType.ordinal(), player), (IModularInventory)this, guiType);
    }

    public GuiHandler.guiId getModularInvType() {
        return GuiHandler.guiId.MODULARNOINV;
    }
}

