/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.armor.IFillableArmor;
import zmaster587.advancedRocketry.api.armor.IProtectiveArmor;

public class ItemAirUtils
implements IFillableArmor {
    public static final ItemAirUtils INSTANCE = new ItemAirUtils();

    @Override
    public int getAirRemaining(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e("air");
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("air", 0);
        stack.func_77982_d(nbt);
        return this.getMaxAir(stack);
    }

    @Override
    public void setAirRemaining(ItemStack stack, int amt) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a("air", amt);
        stack.func_77982_d(nbt);
    }

    @Override
    public int decrementAir(ItemStack stack, int amt) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int prevAmt = nbt.func_74762_e("air");
        int newAmt = Math.max(prevAmt - amt, 0);
        nbt.func_74768_a("air", newAmt);
        stack.func_77982_d(nbt);
        return prevAmt - newAmt;
    }

    @Override
    public int increment(ItemStack stack, int amt) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int prevAmt = nbt.func_74762_e("air");
        int newAmt = Math.min(prevAmt + amt, this.getMaxAir(stack));
        nbt.func_74768_a("air", newAmt);
        stack.func_77982_d(nbt);
        return newAmt - prevAmt;
    }

    @Override
    public int getMaxAir(ItemStack stack) {
        return (Integer)ARConfiguration.getCurrentConfig().spaceSuitOxygenTime.get() * 1200;
    }

    public boolean isStackValidAirContainer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        boolean isEnchanted = false;
        ListNBT enchList = stack.func_77986_q();
        if (enchList != null) {
            for (int i = 0; i < enchList.size(); ++i) {
                CompoundNBT compound = enchList.func_150305_b(i);
                isEnchanted = AdvancedRocketryAPI.enchantmentSpaceProtection.getRegistryName().equals((Object)ResourceLocation.func_208304_a((String)compound.func_74779_i("id")));
                if (isEnchanted) break;
            }
        }
        return isEnchanted;
    }

    public static class ItemAirWrapper
    implements IFillableArmor,
    IProtectiveArmor {
        ItemStack stack;

        public ItemAirWrapper(ItemStack myStack) {
            this.stack = myStack;
        }

        @Override
        public int getAirRemaining(ItemStack stack) {
            return INSTANCE.getAirRemaining(this.stack);
        }

        @Override
        public void setAirRemaining(ItemStack stack, int amt) {
            INSTANCE.setAirRemaining(this.stack, amt);
        }

        @Override
        public int decrementAir(ItemStack stack, int amt) {
            return INSTANCE.decrementAir(this.stack, amt);
        }

        @Override
        public int increment(ItemStack stack, int amt) {
            return INSTANCE.increment(this.stack, amt);
        }

        @Override
        public int getMaxAir(ItemStack stack) {
            return INSTANCE.getMaxAir(this.stack);
        }

        @Override
        public boolean protectsFromSubstance(IAtmosphere atmosphere, ItemStack stack, boolean commitProtection) {
            if (stack != null && stack.func_77973_b() instanceof ArmorItem) {
                if (((ArmorItem)stack.func_77973_b()).func_185083_B_() == EquipmentSlotType.CHEST) {
                    return this.decrementAir(stack, 1) == 1;
                }
                return true;
            }
            return false;
        }
    }
}

