/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import net.minecraft.util.ResourceLocation;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceStationObject;

public class PlanetaryTravelHelper {
    public static boolean isTravelWithinPlanetarySystem(ResourceLocation currentDimensionID, ResourceLocation destinationDimensionID) {
        boolean isPlanetMoonSystem = false;
        DimensionProperties launchworldProperties = DimensionManager.getInstance().getDimensionProperties(currentDimensionID);
        if (launchworldProperties.isMoon()) {
            isPlanetMoonSystem = destinationDimensionID == launchworldProperties.getParentPlanet();
            for (ResourceLocation moonDimID : launchworldProperties.getParentProperties().getChildPlanets()) {
                if (destinationDimensionID != moonDimID) continue;
                isPlanetMoonSystem = true;
            }
        } else {
            for (ResourceLocation moonDimID : launchworldProperties.getChildPlanets()) {
                if (destinationDimensionID != moonDimID) continue;
                isPlanetMoonSystem = true;
            }
        }
        return isPlanetMoonSystem;
    }

    public static int getTransbodyInjectionBurn(ResourceLocation currentDimensionID, ResourceLocation destinationDimensionID, boolean toAsteroids) {
        int baseInjectionHeight = (Integer)ARConfiguration.getCurrentConfig().transBodyInjection.get();
        return PlanetaryTravelHelper.isTravelWithinPlanetarySystem(currentDimensionID, destinationDimensionID) ? (int)((double)baseInjectionHeight * Math.pow(PlanetaryTravelHelper.getBodyDistanceMultiplier(currentDimensionID, destinationDimensionID, toAsteroids), 0.5)) : (int)((Double)ARConfiguration.getCurrentConfig().warpTBIBurnMult.get() * (double)baseInjectionHeight);
    }

    public static double getBodyDistanceMultiplier(ResourceLocation currentDimensionID, ResourceLocation destinationDimensionID, boolean toAsteroids) {
        double bodyDistanceMultiplier = 1.0;
        DimensionProperties destinationProperties = DimensionManager.getInstance().getDimensionProperties(destinationDimensionID);
        if (destinationProperties.isMoon()) {
            bodyDistanceMultiplier = (double)destinationProperties.getOrbitalDist() / 100.0;
        } else {
            for (ResourceLocation moonDimID : destinationProperties.getChildPlanets()) {
                if (currentDimensionID != moonDimID) continue;
                bodyDistanceMultiplier = (double)DimensionManager.getInstance().getDimensionProperties(moonDimID).getOrbitalDist() / 100.0;
            }
        }
        if (toAsteroids) {
            bodyDistanceMultiplier = (Double)ARConfiguration.getCurrentConfig().asteroidTBIBurnMult.get();
        }
        return bodyDistanceMultiplier;
    }

    public static boolean isTravelAnywhereInPlanetarySystem(ResourceLocation currentDimensionID, ResourceLocation destinationDimensionID) {
        return PlanetaryTravelHelper.isTravelWithinOrbit(currentDimensionID, destinationDimensionID) || PlanetaryTravelHelper.isTravelWithinPlanetarySystem(currentDimensionID, destinationDimensionID);
    }

    public static boolean isTravelWithinOrbit(ResourceLocation currentDimensionID, ResourceLocation destinationDimensionID) {
        return currentDimensionID.equals((Object)destinationDimensionID);
    }

    public static boolean isTravelWithinGeostationaryOrbit(SpaceStationObject spaceStation, ResourceLocation planetID) {
        return spaceStation.getOrbitingPlanetId().equals((Object)planetID) && spaceStation.getOrbitalDistance() >= 177.0f && 181.0f >= spaceStation.getOrbitalDistance();
    }
}

