/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.IFluidBlock;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.atmosphere.IAtmosphereSealHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;

public final class SealableBlockHandler
implements IAtmosphereSealHandler {
    private List<Block> blockBanList = new ArrayList<Block>();
    private List<Block> blockAllowList = new ArrayList<Block>();
    private List<Material> materialBanList = new ArrayList<Material>();
    private List<Material> materialAllowList = new ArrayList<Material>();
    private HashSet<HashedBlockPosition> doorPositions = new HashSet();
    public static final SealableBlockHandler INSTANCE = new SealableBlockHandler();

    private SealableBlockHandler() {
    }

    @Override
    public boolean isBlockSealed(World world, BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() <= 256) {
            if (world instanceof ServerWorld && !((ServerWorld)world).func_72863_F().func_73149_a(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) {
                return false;
            }
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            Material material = state.func_185904_a();
            if (this.blockAllowList.contains(block) || this.materialAllowList.contains(material)) {
                return true;
            }
            if (this.blockBanList.contains(block) || this.materialBanList.contains(material)) {
                return false;
            }
            if (material.func_76224_d() || !material.func_76220_a()) {
                return false;
            }
            if (world.func_175623_d(pos) || block instanceof IFluidBlock) {
                return false;
            }
            if (block == AdvancedRocketryBlocks.blockAirLock) {
                HashedBlockPosition myPos = new HashedBlockPosition(pos);
                if (this.doorPositions.contains(myPos)) {
                    return true;
                }
                this.doorPositions.add(myPos);
                boolean doorIsSealed = this.checkDoorIsSealed(world, pos, state);
                this.doorPositions.remove(myPos);
                return doorIsSealed;
            }
            return SealableBlockHandler.isFullBlock(world, pos);
        }
        return false;
    }

    @Override
    public void addUnsealableBlock(Block block) {
        if (!this.blockBanList.contains(block)) {
            this.blockBanList.add(block);
        }
        if (this.blockAllowList.contains(block)) {
            this.blockAllowList.remove(block);
        }
    }

    @Override
    public void addSealableBlock(Block block) {
        if (!this.blockAllowList.contains(block)) {
            this.blockAllowList.add(block);
        }
        if (this.blockBanList.contains(block)) {
            this.blockBanList.remove(block);
        }
    }

    @Override
    public List<Block> getOverridenSealableBlocks() {
        return this.blockAllowList;
    }

    public static boolean isFullBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos) == VoxelShapes.func_197868_b();
    }

    public static boolean isFullBlock(World world, BlockPos pos, BlockState state) {
        AxisAlignedBB bb = state.func_196952_d((IBlockReader)world, pos).func_197752_a();
        if (bb == null) {
            return false;
        }
        int minX = (int)(bb.field_72340_a * 100.0);
        int minY = (int)(bb.field_72338_b * 100.0);
        int minZ = (int)(bb.field_72339_c * 100.0);
        int maxX = (int)(bb.field_72336_d * 100.0);
        int maxY = (int)(bb.field_72337_e * 100.0);
        int maxZ = (int)(bb.field_72334_f * 100.0);
        return minX == 0 && minY == 0 && minZ == 0 && maxX == 100 && maxY == 100 && maxZ == 100;
    }

    private boolean checkDoorIsSealed(World world, BlockPos pos, BlockState state) {
        boolean sealed;
        BlockState state2 = state;
        if (state.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER) {
            state2 = world.func_180495_p(pos.func_177977_b());
        }
        if (((Boolean)state.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
            return this.isBlockSealed(world, pos.func_177972_a((Direction)state2.func_177229_b((Property)DoorBlock.field_176520_a))) && this.isBlockSealed(world, pos.func_177972_a(((Direction)state2.func_177229_b((Property)DoorBlock.field_176520_a)).func_176735_f().func_176735_f()));
        }
        boolean bl = sealed = this.isBlockSealed(world, pos.func_177972_a(((Direction)state2.func_177229_b((Property)DoorBlock.field_176520_a)).func_176746_e())) && this.isBlockSealed(world, pos.func_177972_a(((Direction)state2.func_177229_b((Property)DoorBlock.field_176520_a)).func_176735_f()));
        if (!sealed && !((Boolean)state.func_177229_b((Property)DoorBlock.field_176519_b)).booleanValue()) {
            Direction face = (Direction)state2.func_177229_b((Property)DoorBlock.field_176520_a);
            sealed = this.isBlockSealed(world, pos.func_177972_a(face.func_176735_f()).func_177972_a(face.func_176734_d())) && this.isBlockSealed(world, pos.func_177972_a(face.func_176746_e()).func_177972_a(face.func_176734_d()));
        }
        return sealed;
    }

    public boolean isBlockBanned(Block block) {
        return this.blockBanList.contains(block);
    }

    public boolean isMaterialBanned(Material mat) {
        return this.materialBanList.contains(mat);
    }

    public void loadDefaultData() {
        this.materialBanList.add(Material.field_151579_a);
        this.materialBanList.add(Material.field_151570_A);
        this.materialBanList.add(Material.field_151597_y);
        this.materialBanList.add(Material.field_151581_o);
        this.materialBanList.add(Material.field_151584_j);
        this.materialBanList.add(Material.field_151567_E);
        this.materialBanList.add(Material.field_151585_k);
        this.materialBanList.add(Material.field_151589_v);
        this.materialBanList.add(Material.field_151569_G);
        this.materialBanList.add(Material.field_151583_m);
        this.materialBanList.add(Material.field_151595_p);
    }
}

