/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;

public class SpacePosition {
    public double x;
    public double y;
    public double z;
    public double yaw;
    public double pitch;
    public double roll;
    public StellarBody star;
    public DimensionProperties world;
    public boolean isInInterplanetarySpace;

    public double distanceToSpacePosition2(SpacePosition s) {
        double xx = this.x - s.x;
        double yy = this.y - s.y;
        double zz = this.z - s.z;
        return xx * xx + yy * yy + zz * zz;
    }

    public void writeToNBT(CompoundNBT nbt) {
        CompoundNBT subTag = new CompoundNBT();
        subTag.func_74780_a("x", this.x);
        subTag.func_74780_a("y", this.y);
        subTag.func_74780_a("z", this.z);
        subTag.func_74780_a("yaw", this.yaw);
        subTag.func_74780_a("pitch", this.pitch);
        subTag.func_74780_a("roll", this.roll);
        if (this.star != null) {
            subTag.func_74778_a("star", this.star.getId().toString());
        }
        if (this.world != null) {
            subTag.func_74778_a("world", this.world.getId().toString());
        }
        subTag.func_74757_a("isInInterplanetarySpace", this.isInInterplanetarySpace);
        nbt.func_218657_a("spacePosition", (INBT)subTag);
    }

    public void readFromNBT(CompoundNBT nbt) {
        if (!nbt.func_74764_b("spacePosition")) {
            return;
        }
        CompoundNBT subTag = nbt.func_74775_l("spacePosition");
        this.x = subTag.func_74769_h("x");
        this.y = subTag.func_74769_h("y");
        this.z = subTag.func_74769_h("z");
        this.yaw = subTag.func_74769_h("yaw");
        this.pitch = subTag.func_74769_h("pitch");
        this.roll = subTag.func_74769_h("roll");
        subTag.func_74780_a("pitch", this.pitch);
        subTag.func_74780_a("roll", this.roll);
        this.star = subTag.func_74764_b("star") ? DimensionManager.getInstance().getStar(new ResourceLocation(subTag.func_74779_i("star"))) : null;
        this.world = subTag.func_74764_b("world") ? DimensionManager.getInstance().getDimensionProperties(new ResourceLocation(subTag.func_74779_i("world"))) : null;
        this.isInInterplanetarySpace = subTag.func_74767_n("isInInterplanetarySpace");
    }

    public Vector3d getNormalVectorTo(SpacePosition other) {
        double distance = Math.sqrt(this.distanceToSpacePosition2(other));
        double x = (other.x - this.x) / distance;
        double y = (other.y - this.y) / distance;
        double z = (other.z - this.z) / distance;
        return new Vector3d(x, y, z);
    }

    public SpacePosition getFromSpherical(double radius, double theta) {
        SpacePosition returnPos = new SpacePosition();
        returnPos.world = this.world;
        returnPos.star = this.star;
        returnPos.isInInterplanetarySpace = this.isInInterplanetarySpace;
        returnPos.x = this.x + Math.cos(theta) * radius;
        returnPos.y = this.y;
        returnPos.z = this.z + Math.sin(theta) * radius;
        return returnPos;
    }
}

