/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import net.minecraft.entity.Entity;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.util.SpacePosition;

public class SpaceTravelInteraction {
    public static void tick(SpacePosition spacePosition, Entity entity) {
        double distanceSq;
        if (spacePosition.world == null && spacePosition.star != null) {
            for (IDimensionProperties properties : spacePosition.star.getPlanets()) {
                SpacePosition worldSpacePosition = properties.getSpacePosition();
                double distanceSq2 = spacePosition.distanceToSpacePosition2(worldSpacePosition);
                if (!(distanceSq2 < 200.0)) continue;
                spacePosition.world = (DimensionProperties)properties;
                double radius = -480.0;
                SpacePosition planetPosition = new SpacePosition();
                double theta = Math.atan2(entity.func_213322_ci().field_72449_c, entity.func_213322_ci().field_72450_a);
                spacePosition.x = planetPosition.x + Math.cos(theta) * radius;
                spacePosition.y = planetPosition.y;
                spacePosition.z = planetPosition.z + Math.sin(theta) * radius;
                break;
            }
        }
        if (spacePosition.world != null && (distanceSq = spacePosition.distanceToSpacePosition2(new SpacePosition())) > 320000.0) {
            double radius = 12.0;
            SpacePosition planetPosition = spacePosition.world.getSpacePosition();
            spacePosition.world = null;
            double theta = Math.atan2(entity.func_213322_ci().field_72449_c, entity.func_213322_ci().field_72450_a);
            spacePosition.x = planetPosition.x + Math.cos(theta) * radius;
            spacePosition.y = planetPosition.y;
            spacePosition.z = planetPosition.z + Math.sin(theta) * radius;
        }
    }

    public static boolean isCloseToWorld(SpacePosition spacePosition, IDimensionProperties properties) {
        SpacePosition worldSpacePosition;
        double distanceSq;
        return spacePosition.world == null && spacePosition.star != null && (distanceSq = spacePosition.distanceToSpacePosition2(worldSpacePosition = properties.getSpacePosition())) < 200.0;
    }

    public static boolean isExitingWorld(SpacePosition spacePosition, IDimensionProperties properties) {
        double distanceSq;
        return spacePosition.world != null && (distanceSq = spacePosition.distanceToSpacePosition2(new SpacePosition())) > 320000.0;
    }
}

