/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.logging.log4j.LogManager;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.Constants;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.IStorageChunk;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.tile.multiblock.TileWarpCore;
import zmaster587.advancedRocketry.world.util.WorldDummy;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.Vector3F;
import zmaster587.libVulpes.util.ZUtils;

public class StorageChunk
implements IWorld,
IStorageChunk {
    private static final int CHUNK_SIZE = 16;
    private static final int CHUNK_HEIGHT = 256;
    int sizeX;
    int sizeY;
    int sizeZ;
    public Chunk chunk;
    ArrayList<TileEntity> tileEntities;
    ArrayList<TileEntity> inventoryTiles;
    ArrayList<TileEntity> liquidTiles;
    public WorldDummy world;
    private Entity entity;
    public boolean finalized = false;

    public StorageChunk() {
        this.sizeX = 0;
        this.sizeY = 0;
        this.sizeZ = 0;
        this.tileEntities = new ArrayList();
        this.inventoryTiles = new ArrayList();
        this.liquidTiles = new ArrayList();
        this.world = new WorldDummy(AdvancedRocketry.proxy.getProfiler(), this);
        this.chunk = new Chunk((World)this.world, new ChunkPos(0, 0), new BiomeContainer(null, new ChunkPos(0, 0), (BiomeProvider)new SingleBiomeProvider(AdvancedRocketryBiomes.getBiomeFromResourceLocation(Biomes.field_76771_b.func_240901_a_()))));
        this.world.setChunk(this.chunk);
    }

    protected StorageChunk(int xSize, int ySize, int zSize) {
        this.sizeX = xSize;
        this.sizeY = ySize;
        this.sizeZ = zSize;
        this.tileEntities = new ArrayList();
        this.inventoryTiles = new ArrayList();
        this.liquidTiles = new ArrayList();
        this.world = new WorldDummy(AdvancedRocketry.proxy.getProfiler(), this);
        ObjectIntIdentityMap registry = new ObjectIntIdentityMap(1);
        registry.func_195867_b((Object)AdvancedRocketryBiomes.getBiomeFromResourceLocation(Biomes.field_76771_b.getRegistryName()));
        this.chunk = new Chunk((World)this.world, new ChunkPos(0, 0), new BiomeContainer((IObjectIntIterable)registry, new ChunkPos(0, 0), (BiomeProvider)new SingleBiomeProvider(AdvancedRocketryBiomes.getBiomeFromResourceLocation(Biomes.field_76771_b.func_240901_a_()))));
        this.world.setChunk(this.chunk);
    }

    public void setEntity(EntityRocketBase entity) {
        this.entity = entity;
    }

    public EntityRocketBase getEntity() {
        return (EntityRocketBase)this.entity;
    }

    @Override
    public int getSizeX() {
        return this.sizeX;
    }

    @Override
    public int getSizeY() {
        return this.sizeY;
    }

    @Override
    public int getSizeZ() {
        return this.sizeZ;
    }

    @Override
    public List<TileEntity> getTileEntityList() {
        return this.tileEntities;
    }

    public List<TileEntity> getFluidTiles() {
        return this.liquidTiles;
    }

    public List<TileEntity> getInventoryTiles() {
        return this.inventoryTiles;
    }

    public List<TileEntity> getGUItiles() {
        LinkedList<TileEntity> list = new LinkedList<TileEntity>(this.inventoryTiles);
        return list;
    }

    public BlockState func_180495_p(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ || this.chunk == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.chunk.func_180495_p(pos);
    }

    public void setBlockState(BlockPos pos, BlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.chunk.func_177436_a(pos, state, false);
    }

    public void writeToNBT(CompoundNBT nbt) {
        BiomeContainer biomecontainer;
        nbt.func_74768_a("xSize", this.sizeX);
        nbt.func_74768_a("ySize", this.sizeY);
        nbt.func_74768_a("zSize", this.sizeZ);
        ChunkPos chunkpos = this.chunk.func_76632_l();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        ChunkSection[] achunksection = this.chunk.func_76587_i();
        ListNBT listnbt = new ListNBT();
        WorldLightManager worldlightmanager = this.world.func_72863_F().func_212863_j_();
        boolean flag = this.chunk.func_217310_r();
        for (int i = -1; i < 17; ++i) {
            int j = i;
            ChunkSection chunksection = Arrays.stream(achunksection).filter(p_222657_1_ -> p_222657_1_ != null && p_222657_1_.func_222632_g() >> 4 == j).findFirst().orElse(Chunk.field_186036_a);
            NibbleArray nibblearray = worldlightmanager.func_215569_a(LightType.BLOCK).func_215612_a(SectionPos.func_218156_a((ChunkPos)chunkpos, (int)j));
            NibbleArray nibblearray1 = worldlightmanager.func_215569_a(LightType.SKY).func_215612_a(SectionPos.func_218156_a((ChunkPos)chunkpos, (int)j));
            if (chunksection == Chunk.field_186036_a && nibblearray == null && nibblearray1 == null) continue;
            CompoundNBT compoundnbt2 = new CompoundNBT();
            compoundnbt2.func_74774_a("Y", (byte)(j & 0xFF));
            if (chunksection != Chunk.field_186036_a) {
                chunksection.func_186049_g().func_196963_b(compoundnbt2, "Palette", "BlockStates");
            }
            if (nibblearray != null && !nibblearray.func_215655_c()) {
                compoundnbt2.func_74773_a("BlockLight", nibblearray.func_177481_a());
            }
            if (nibblearray1 != null && !nibblearray1.func_215655_c()) {
                compoundnbt2.func_74773_a("SkyLight", nibblearray1.func_177481_a());
            }
            listnbt.add((Object)compoundnbt2);
        }
        compoundnbt1.func_218657_a("Sections", (INBT)listnbt);
        if (flag) {
            compoundnbt1.func_74757_a("isLightOn", true);
        }
        if ((biomecontainer = this.chunk.func_225549_i_()) != null) {
            compoundnbt1.func_74783_a("Biomes", biomecontainer.func_227055_a_());
        }
        ListNBT listnbt1 = new ListNBT();
        for (TileEntity tile : this.tileEntities) {
            CompoundNBT compoundnbt4 = tile.func_189515_b(new CompoundNBT());
            if (compoundnbt4 == null) continue;
            listnbt1.add((Object)compoundnbt4);
        }
        compoundnbt1.func_218657_a("TileEntities", (INBT)listnbt1);
        ListNBT listnbt2 = new ListNBT();
        this.chunk.func_177409_g(false);
        for (int k = 0; k < this.chunk.func_177429_s().length; ++k) {
            for (Entity entity : this.chunk.func_177429_s()[k]) {
                CompoundNBT compoundnbt3 = new CompoundNBT();
                try {
                    if (!entity.func_70039_c(compoundnbt3)) continue;
                    this.chunk.func_177409_g(true);
                    listnbt2.add((Object)compoundnbt3);
                }
                catch (Exception e) {
                    LogManager.getLogger().error("An Entity type {} has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Object)entity.func_200600_R(), (Object)e);
                }
            }
        }
        try {
            CompoundNBT capTag = this.chunk.writeCapsToNBT();
            if (capTag != null) {
                compoundnbt1.func_218657_a("ForgeCaps", (INBT)capTag);
            }
        }
        catch (Exception exception) {
            LogManager.getLogger().error("A capability provider has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Throwable)exception);
        }
        compoundnbt1.func_218657_a("Entities", (INBT)listnbt2);
        CompoundNBT compoundnbt6 = new CompoundNBT();
        for (Map.Entry entry : this.chunk.func_217311_f()) {
            if (!this.chunk.func_201589_g().func_222595_h().contains(entry.getKey())) continue;
            compoundnbt6.func_218657_a(((Heightmap.Type)entry.getKey()).func_203500_b(), (INBT)new LongArrayNBT(((Heightmap)entry.getValue()).func_202269_a()));
        }
        compoundnbt1.func_218657_a("Heightmaps", (INBT)compoundnbt6);
        nbt.func_197643_a(compoundnbt1);
    }

    @Override
    public void rotateBy(Direction dir) {
        HashedBlockPosition newSizes = new HashedBlockPosition(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        HashedBlockPosition newerSize = this.remapCoord(newSizes, dir);
        newSizes = this.remapCoord(newSizes, dir);
        BlockState[][][] blocks = new BlockState[newSizes.x][newSizes.y][newSizes.z];
        for (int y = 0; y < this.getSizeY(); ++y) {
            for (int z = 0; z < this.getSizeZ(); ++z) {
                for (int x = 0; x < this.getSizeX(); ++x) {
                    newSizes = this.getNewCoord(new HashedBlockPosition(x, y, z), dir);
                    blocks[newSizes.x][newSizes.y][newSizes.z] = this.func_180495_p(new BlockPos(x, y, z));
                }
            }
        }
        int oldX = this.sizeX;
        int oldY = this.sizeY;
        int oldZ = this.sizeZ;
        this.sizeX = newerSize.x;
        this.sizeY = newerSize.y;
        this.sizeZ = newerSize.z;
        for (int y = 0; y < this.getSizeY(); ++y) {
            for (int z = 0; z < this.getSizeZ(); ++z) {
                for (int x = 0; x < this.getSizeX(); ++x) {
                    this.chunk.func_177436_a(new BlockPos(x, y, z), blocks[newSizes.x][newSizes.y][newSizes.z], false);
                }
            }
        }
        this.sizeX = oldX;
        this.sizeY = oldY;
        this.sizeZ = oldZ;
        for (TileEntity e : this.tileEntities) {
            newSizes = this.getNewCoord(new HashedBlockPosition(e.func_174877_v()), dir);
            e.func_174878_a(newSizes.getBlockPos());
        }
        this.sizeX = newerSize.x;
        this.sizeY = newerSize.y;
        this.sizeZ = newerSize.z;
    }

    private HashedBlockPosition remapCoord(HashedBlockPosition in, Direction dir) {
        HashedBlockPosition out = new HashedBlockPosition(0, 0, 0);
        switch (dir) {
            case DOWN: {
                out.x = in.z;
                out.y = in.y;
                out.z = in.x;
                break;
            }
            case UP: {
                out.x = in.z;
                out.y = in.y;
                out.z = in.x;
                break;
            }
            case NORTH: {
                out.x = in.y;
                out.y = (short)in.x;
                out.z = in.z;
                break;
            }
            case SOUTH: {
                out.x = in.y;
                out.y = (short)in.x;
                out.z = in.z;
                break;
            }
            case EAST: {
                out.x = in.x;
                out.y = (short)in.z;
                out.z = in.y;
                break;
            }
            case WEST: {
                out.x = in.x;
                out.y = (short)in.z;
                out.z = in.y;
            }
        }
        return out;
    }

    public HashedBlockPosition getNewCoord(HashedBlockPosition in, Direction dir) {
        HashedBlockPosition out = new HashedBlockPosition(0, 0, 0);
        switch (dir) {
            case DOWN: {
                out.x = in.z;
                out.y = in.y;
                out.z = this.getSizeX() - in.x - 1;
                break;
            }
            case UP: {
                out.x = this.getSizeZ() - in.z - 1;
                out.y = in.y;
                out.z = in.x;
                break;
            }
            case NORTH: {
                out.x = in.y;
                out.y = (short)(this.getSizeX() - in.x - 1);
                out.z = in.z;
                break;
            }
            case SOUTH: {
                out.x = this.getSizeY() - in.y - 1;
                out.y = (short)in.x;
                out.z = in.z;
                break;
            }
            case EAST: {
                out.x = in.x;
                out.y = (short)(this.getSizeZ() - in.z - 1);
                out.z = in.y;
                break;
            }
            case WEST: {
                out.x = in.x;
                out.y = (short)in.z;
                out.z = this.getSizeY() - in.y - 1;
            }
        }
        return out;
    }

    private static boolean isInventoryBlock(TileEntity tile) {
        return tile instanceof IInventory || tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && !(tile instanceof TileGuidanceComputer);
    }

    private static boolean isLiquidContainerBlock(TileEntity tile) {
        return tile instanceof IFluidHandler;
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.sizeX = nbt.func_74762_e("xSize");
        this.sizeY = nbt.func_74762_e("ySize");
        this.sizeZ = nbt.func_74762_e("zSize");
        CompoundNBT compoundnbt = nbt;
        ChunkPos pos = new ChunkPos(0, 0);
        this.inventoryTiles.clear();
        this.liquidTiles.clear();
        this.tileEntities.clear();
        boolean flag = compoundnbt.func_74767_n("isLightOn");
        ListNBT listnbt = compoundnbt.func_150295_c("Sections", 10);
        ChunkSection[] achunksection = new ChunkSection[16];
        boolean flag1 = true;
        AbstractChunkProvider abstractchunkprovider = this.world.func_72863_F();
        WorldLightManager worldlightmanager = abstractchunkprovider.func_212863_j_();
        for (int j = 0; j < listnbt.size(); ++j) {
            CompoundNBT compoundnbt1 = listnbt.func_150305_b(j);
            byte k = compoundnbt1.func_74771_c("Y");
            if (compoundnbt1.func_150297_b("Palette", 9) && compoundnbt1.func_150297_b("BlockStates", 12)) {
                ChunkSection chunksection = new ChunkSection(k << 4);
                chunksection.func_186049_g().func_222642_a(compoundnbt1.func_150295_c("Palette", 10), compoundnbt1.func_197645_o("BlockStates"));
                chunksection.func_76672_e();
                if (!chunksection.func_76663_a()) {
                    achunksection[k] = chunksection;
                }
            }
            if (!flag) continue;
            if (compoundnbt1.func_150297_b("BlockLight", 7)) {
                worldlightmanager.func_215574_a(LightType.BLOCK, SectionPos.func_218156_a((ChunkPos)pos, (int)k), new NibbleArray(compoundnbt1.func_74770_j("BlockLight")), true);
            }
            if (!flag1 || !compoundnbt1.func_150297_b("SkyLight", 7)) continue;
            worldlightmanager.func_215574_a(LightType.SKY, SectionPos.func_218156_a((ChunkPos)pos, (int)k), new NibbleArray(compoundnbt1.func_74770_j("SkyLight")), true);
        }
        Chunk ichunk = new Chunk((World)this.world, pos, new BiomeContainer(AdvancedRocketryBiomes.getBiomeRegistry(), pos, (BiomeProvider)new SingleBiomeProvider(AdvancedRocketryBiomes.getBiomeFromResourceLocation(Biomes.field_76771_b.func_240901_a_()))), UpgradeData.field_196994_a, (ITickList)EmptyTickList.func_205388_a(), (ITickList)EmptyTickList.func_205388_a(), 0L, achunksection, null);
        if (compoundnbt.func_74764_b("ForgeCaps")) {
            ichunk.readCapsFromNBT(compoundnbt.func_74775_l("ForgeCaps"));
        }
        ichunk.func_217305_b(flag);
        CompoundNBT compoundnbt3 = compoundnbt.func_74775_l("Heightmaps");
        EnumSet<Heightmap.Type> enumset = EnumSet.noneOf(Heightmap.Type.class);
        for (Heightmap.Type heightmap$type : ichunk.func_201589_g().func_222595_h()) {
            String s = heightmap$type.func_203500_b();
            if (compoundnbt3.func_150297_b(s, 12)) {
                ichunk.func_201607_a(heightmap$type, compoundnbt3.func_197645_o(s));
                continue;
            }
            enumset.add(heightmap$type);
        }
        Heightmap.func_222690_a((IChunk)ichunk, enumset);
        ListNBT listnbt3 = compoundnbt.func_150295_c("PostProcessing", 9);
        for (int l1 = 0; l1 < listnbt3.size(); ++l1) {
            ListNBT listnbt1 = listnbt3.func_202169_e(l1);
            for (int l = 0; l < listnbt1.size(); ++l) {
                ichunk.func_201636_b(listnbt1.func_202170_f(l), l1);
            }
        }
        this.chunk = ichunk;
        ListNBT listnbt1 = nbt.func_150295_c("TileEntities", 10);
        for (int j = 0; j < listnbt1.size(); ++j) {
            CompoundNBT compoundnbt1 = listnbt1.func_150305_b(j);
            BlockPos blockpos = new BlockPos(compoundnbt1.func_74762_e("x"), compoundnbt1.func_74762_e("y"), compoundnbt1.func_74762_e("z"));
            TileEntity tileentity = TileEntity.func_235657_b_((BlockState)this.chunk.func_180495_p(blockpos), (CompoundNBT)compoundnbt1);
            if (tileentity == null) continue;
            if (StorageChunk.isInventoryBlock(tileentity)) {
                this.inventoryTiles.add(tileentity);
            }
            if (StorageChunk.isLiquidContainerBlock(tileentity)) {
                this.liquidTiles.add(tileentity);
            }
            this.tileEntities.add(tileentity);
            tileentity.func_226984_a_((World)this.world, blockpos);
            this.chunk.func_150813_a(tileentity);
        }
    }

    public static StorageChunk copyWorldBB(World world, AxisAlignedBB bb) {
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int x = (int)bb.field_72340_a;
        while ((double)x <= bb.field_72336_d) {
            int z = (int)bb.field_72339_c;
            while ((double)z <= bb.field_72334_f) {
                int y = (int)bb.field_72338_b;
                while ((double)y <= bb.field_72337_e) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (!block.isAir(world.func_180495_p(pos), (IBlockReader)world, pos)) {
                        if (x < actualMinX) {
                            actualMinX = x;
                        }
                        if (y < actualMinY) {
                            actualMinY = y;
                        }
                        if (z < actualMinZ) {
                            actualMinZ = z;
                        }
                        if (x > actualMaxX) {
                            actualMaxX = x;
                        }
                        if (y > actualMaxY) {
                            actualMaxY = y;
                        }
                        if (z > actualMaxZ) {
                            actualMaxZ = z;
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        bb = new AxisAlignedBB((double)actualMinX, (double)actualMinY, (double)actualMinZ, (double)actualMaxX, (double)actualMaxY, (double)actualMaxZ);
        StorageChunk ret = new StorageChunk(actualMaxX - actualMinX + 1, actualMaxY - actualMinY + 1, actualMaxZ - actualMinZ + 1);
        for (int x2 = actualMinX; x2 <= actualMaxX; ++x2) {
            for (int z = actualMinZ; z <= actualMaxZ; ++z) {
                for (int y = actualMinY; y <= actualMaxY; ++y) {
                    BlockPos pos = new BlockPos(x2, y, z);
                    BlockState state = world.func_180495_p(pos);
                    TileEntity entity = world.func_175625_s(pos);
                    ret.setBlockState(new BlockPos(x2 - actualMinX, y - actualMinY, z - actualMinZ), state);
                    if (entity == null) continue;
                    CompoundNBT nbt = new CompoundNBT();
                    entity.func_189515_b(nbt);
                    nbt.func_74768_a("x", nbt.func_74762_e("x") - actualMinX);
                    nbt.func_74768_a("y", nbt.func_74762_e("y") - actualMinY);
                    nbt.func_74768_a("z", nbt.func_74762_e("z") - actualMinZ);
                    TileEntity newTile = entity.func_200662_C().func_200968_a();
                    newTile.deserializeNBT(nbt);
                    if (newTile != null) {
                        newTile.func_226984_a_((World)ret.world, pos.func_177982_a(-actualMinX, -actualMinY, -actualMinZ));
                        if (StorageChunk.isInventoryBlock(newTile)) {
                            ret.inventoryTiles.add(newTile);
                        }
                        if (StorageChunk.isLiquidContainerBlock(newTile)) {
                            ret.liquidTiles.add(newTile);
                        }
                        ret.tileEntities.add(newTile);
                    }
                    ret.chunk.func_177426_a(pos, newTile);
                }
            }
        }
        return ret;
    }

    @Override
    public void pasteInWorld(World world, int xCoord, int yCoord, int zCoord) {
        for (int x = 0; x < this.sizeX; ++x) {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int y = 0; y < this.sizeY; ++y) {
                    if (this.chunk == null || this.chunk.func_180495_p(new BlockPos(x, y, z)).func_196958_f()) continue;
                    world.func_180501_a(new BlockPos(xCoord + x, yCoord + y, zCoord + z), this.chunk.func_180495_p(new BlockPos(x, y, z)), 2);
                }
            }
        }
        for (TileEntity tile : this.tileEntities) {
            CompoundNBT nbt = new CompoundNBT();
            tile.func_189515_b(nbt);
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            int tmpX = x + xCoord;
            int tmpY = y + yCoord;
            int tmpZ = z + zCoord;
            nbt.func_74768_a("x", tmpX);
            nbt.func_74768_a("y", tmpY);
            nbt.func_74768_a("z", tmpZ);
            TileEntity entity = world.func_175625_s(new BlockPos(tmpX, tmpY, tmpZ));
            if (entity == null) continue;
            entity.deserializeNBT(nbt);
        }
    }

    public TileEntity func_175625_s(BlockPos pos) {
        for (TileEntity tileE : this.tileEntities) {
            if (tileE.func_174877_v().compareTo((Vector3i)pos) != 0) continue;
            return tileE;
        }
        return null;
    }

    public boolean func_175623_d(BlockPos pos) {
        if (pos.func_177958_n() >= 16 || pos.func_177956_o() >= 256 || pos.func_177952_p() >= 16) {
            return true;
        }
        return this.chunk.func_180495_p(pos).func_196958_f();
    }

    public Biome func_226691_t_(BlockPos pos) {
        return AdvancedRocketryBiomes.getBiomeFromResourceLocation(Biomes.field_76771_b.getRegistryName());
    }

    public static StorageChunk cutWorldBB(World worldObj, AxisAlignedBB bb) {
        StorageChunk chunk = StorageChunk.copyWorldBB(worldObj, bb);
        int x = (int)bb.field_72340_a;
        while ((double)x <= bb.field_72336_d) {
            int z = (int)bb.field_72339_c;
            while ((double)z <= bb.field_72334_f) {
                int y = (int)bb.field_72338_b;
                while ((double)y <= bb.field_72337_e) {
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity tile = worldObj.func_175625_s(pos);
                    if (tile instanceof IInventory) {
                        IInventory inv = (IInventory)tile;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            inv.func_70299_a(i, ItemStack.field_190927_a);
                        }
                    }
                    worldObj.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        for (Object entity : worldObj.func_217357_a(ItemEntity.class, bb.func_72314_b(5.0, 5.0, 5.0))) {
            ((Entity)entity).func_70106_y();
        }
        return chunk;
    }

    public List<TileSatelliteHatch> getSatelliteHatches() {
        LinkedList<TileSatelliteHatch> satelliteHatches = new LinkedList<TileSatelliteHatch>();
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileSatelliteHatch)) continue;
            satelliteHatches.add((TileSatelliteHatch)tile);
        }
        return satelliteHatches;
    }

    @Deprecated
    public List<SatelliteBase> getSatellites() {
        LinkedList<SatelliteBase> satellites = new LinkedList<SatelliteBase>();
        LinkedList<TileSatelliteHatch> satelliteHatches = new LinkedList<TileSatelliteHatch>();
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileSatelliteHatch)) continue;
            satelliteHatches.add((TileSatelliteHatch)tile);
        }
        for (TileSatelliteHatch tile : satelliteHatches) {
            SatelliteBase satellite = tile.getSatellite();
            if (satellite == null) continue;
            satellites.add(satellite);
        }
        return satellites;
    }

    @Deprecated
    public TileGuidanceComputer getGuidanceComputer() {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return (TileGuidanceComputer)tile;
        }
        return null;
    }

    public boolean hasWarpCore() {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileWarpCore)) continue;
            return true;
        }
        return false;
    }

    public ResourceLocation getDestinationDimId(ResourceLocation currentDimId, int x, int z) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getDestinationDimId(currentDimId, new BlockPos(x, 0, z));
        }
        return Constants.INVALID_PLANET;
    }

    public ResourceLocation getDestinationDimId(World world, int x, int z) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getDestinationDimId(ZUtils.getDimensionIdentifier((World)world), new BlockPos(x, 0, z));
        }
        return Constants.INVALID_PLANET;
    }

    public Vector3F<Float> getDestinationCoordinates(ResourceLocation destDimID, boolean commit) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getLandingLocation(destDimID, commit);
        }
        return null;
    }

    public String getDestinationName(ResourceLocation destDimID) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getDestinationName(destDimID);
        }
        return "";
    }

    public void setDestinationCoordinates(Vector3F<Float> vec, ResourceLocation dimid) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            ((TileGuidanceComputer)tile).setReturnPosition(vec, dimid);
        }
    }

    public void writeToNetwork(PacketBuffer out) {
        CompoundNBT nbt = new CompoundNBT();
        this.writeToNBT(nbt);
        out.func_150786_a(nbt);
    }

    public void readFromNetwork(PacketBuffer in) {
        PacketBuffer buffer = new PacketBuffer((ByteBuf)in);
        this.readFromNBT(in.func_150793_b());
    }

    public int func_175627_a(BlockPos pos, Direction direction) {
        return 0;
    }

    public DynamicRegistries func_241828_r() {
        return null;
    }

    public List<Entity> func_175674_a(Entity entityIn, AxisAlignedBB boundingBox, Predicate<? super Entity> predicate) {
        return new LinkedList<Entity>();
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, Predicate<? super T> filter) {
        return new LinkedList();
    }

    public List<? extends PlayerEntity> func_217369_A() {
        return new LinkedList();
    }

    public IChunk func_217353_a(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return this.chunk;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        return this.chunk.func_217303_b(heightmapType).func_202273_a(x, z);
    }

    public int func_175657_ab() {
        return 0;
    }

    public BiomeManager func_225523_d_() {
        return null;
    }

    public Biome func_225604_a_(int x, int y, int z) {
        return AdvancedRocketryBiomes.getBiomeFromResourceLocation(Biomes.field_76771_b.getRegistryName());
    }

    public boolean func_201670_d() {
        return false;
    }

    public int func_181545_F() {
        return 0;
    }

    public DimensionType func_230315_m_() {
        return null;
    }

    public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
        return 0.0f;
    }

    public WorldLightManager func_225524_e_() {
        return this.chunk.func_217307_e();
    }

    public FluidState func_204610_c(BlockPos pos) {
        return this.chunk.func_204610_c(pos);
    }

    public WorldBorder func_175723_af() {
        return new WorldBorder();
    }

    public boolean func_217375_a(BlockPos p_217375_1_, Predicate<BlockState> p_217375_2_) {
        return false;
    }

    public boolean func_241211_a_(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        return false;
    }

    public boolean func_217377_a(BlockPos pos, boolean isMoving) {
        this.chunk.func_177436_a(pos, Blocks.field_150350_a.func_176223_P(), isMoving);
        return true;
    }

    public boolean func_241212_a_(BlockPos pos, boolean dropBlock, @Nullable Entity entity, int recursionLeft) {
        return false;
    }

    public ITickList<Block> func_205220_G_() {
        return null;
    }

    public ITickList<Fluid> func_205219_F_() {
        return null;
    }

    public IWorldInfo func_72912_H() {
        return this.world.func_72912_H();
    }

    public DifficultyInstance func_175649_E(BlockPos pos) {
        return null;
    }

    public AbstractChunkProvider func_72863_F() {
        return this.world.func_72863_F();
    }

    public Random func_201674_k() {
        return null;
    }

    public void func_184133_a(PlayerEntity player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
    }

    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void func_217378_a(PlayerEntity player, int type, BlockPos pos, int data) {
    }
}

