/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class MapGenInvertedPillar
extends WorldCarver<ProbabilityConfig> {
    int chancePerChunk;
    BlockState block;
    BlockState topBlock;
    BlockState bottomBlock;

    public MapGenInvertedPillar(Codec<ProbabilityConfig> codec, int chancePerChunk, BlockState bottom, BlockState blockType, BlockState blockTop) {
        super(codec, chancePerChunk);
        this.chancePerChunk = chancePerChunk;
        this.block = blockType;
        this.topBlock = blockTop;
        this.bottomBlock = bottom;
    }

    public boolean carveRegion(IChunk chunkPrimerIn, Function<BlockPos, Biome> func, Random rand, int p_225555_4_, int rangeX, int rangeZ, int chunkX, int chunkZ, BitSet carvingMask, ProbabilityConfig config) {
        int x = (rangeX - chunkX) * 16 + rand.nextInt(15);
        int z = (rangeZ - chunkZ) * 16 + rand.nextInt(15);
        int y = 56;
        int treeHeight = rand.nextInt(10) + 20;
        int radius = 5;
        int edgeRadius = 2;
        int numDiag = edgeRadius + 1;
        float SHAPE = -0.005f;
        int currentEdgeRadius = (int)((double)-0.005f * ((double)edgeRadius * Math.pow(treeHeight, 2.0)) + (double)(1.005f * (float)edgeRadius));
        ++y;
        for (int yOff = -20; yOff < treeHeight; ++yOff) {
            BlockState actualBlock;
            int xOff;
            int zOff;
            currentEdgeRadius = (int)((double)-0.005f * ((double)edgeRadius * Math.pow(treeHeight - yOff, 2.0)) + (double)(1.005f * (float)edgeRadius));
            for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
                for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                    actualBlock = this.getBlockAtPercentHeight((float)yOff / (float)(treeHeight + rand.nextInt(4)));
                    this.setBlock(x + xOff, y + yOff, z + zOff, actualBlock, chunkPrimerIn);
                }
                ++currentEdgeRadius;
            }
            for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
                for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                    actualBlock = this.getBlockAtPercentHeight((float)yOff / (float)(treeHeight + rand.nextInt(4)));
                    this.setBlock(x + xOff, y + yOff, z + zOff, actualBlock, chunkPrimerIn);
                }
            }
            for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
                for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                    actualBlock = this.getBlockAtPercentHeight((float)yOff / (float)(treeHeight + rand.nextInt(4)));
                    this.setBlock(x + xOff, y + yOff, z + zOff, actualBlock, chunkPrimerIn);
                }
            }
        }
        return true;
    }

    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, ProbabilityConfig config) {
        return rand.nextInt(this.chancePerChunk) == Math.abs(chunkX) % this.chancePerChunk || rand.nextInt(this.chancePerChunk) == Math.abs(chunkZ) % this.chancePerChunk;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return false;
    }

    protected BlockState getBlockAtPercentHeight(float percent) {
        return percent > 0.95f && this.topBlock == Blocks.field_150346_d.func_176223_P() ? Blocks.field_150349_c.func_176223_P() : (percent > 0.66f ? this.topBlock : (percent < 0.33f ? this.bottomBlock : this.block));
    }

    private void setBlock(int x, int y, int z, BlockState block, IChunk primer) {
        if (x > 15 || x < 0 || z > 15 || z < 0 || y < 0 || y > 255) {
            return;
        }
        primer.func_177436_a(new BlockPos(x, y, z), block, false);
    }
}

